/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class SourceInformationAnnotator
extends NodeTraversal.AbstractPostOrderCallback {
    private final String sourceFile;
    private final boolean doSanityChecks;

    public SourceInformationAnnotator(String sourceFile, boolean doSanityChecks) {
        this.sourceFile = sourceFile;
        this.doSanityChecks = doSanityChecks;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.doSanityChecks && this.sourceFile != null) {
            Preconditions.checkState((boolean)this.sourceFile.equals(n.getSourceFileName()));
        }
        switch (n.getType()) {
            case 33: {
                Node propNode = n.getLastChild();
                SourceInformationAnnotator.setOriginalName(n, propNode.getString());
                break;
            }
            case 105: {
                String functionName = NodeUtil.getNearestFunctionName(n);
                if (functionName == null) break;
                SourceInformationAnnotator.setOriginalName(n, functionName);
                break;
            }
            case 38: {
                SourceInformationAnnotator.setOriginalName(n, n.getString());
                break;
            }
            case 64: {
                for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                    if (key.isQuotedString()) continue;
                    SourceInformationAnnotator.setOriginalName(key, key.getString());
                }
                break;
            }
        }
    }

    static void setOriginalName(Node n, String name) {
        if (!name.isEmpty() && n.getProp(40) == null) {
            n.putProp(40, name);
        }
    }
}

