/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionProvider;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.NameReferenceGraphConstruction;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PureFunctionIdentifier
implements CompilerPass {
    static final DiagnosticType INVALID_NO_SIDE_EFFECT_ANNOTATION = DiagnosticType.error("JSC_INVALID_NO_SIDE_EFFECT_ANNOTATION", "@nosideeffects may only appear in externs files.");
    static final DiagnosticType INVALID_MODIFIES_ANNOTATION = DiagnosticType.error("JSC_INVALID_MODIFIES_ANNOTATION", "@modifies may only appear in externs files.");
    private final AbstractCompiler compiler;
    private final DefinitionProvider definitionProvider;
    private final Map<Node, FunctionInformation> functionSideEffectMap;
    private final List<Node> allFunctionCalls;
    private Node externs;
    private Node root;

    public PureFunctionIdentifier(AbstractCompiler compiler, DefinitionProvider definitionProvider) {
        this.compiler = compiler;
        this.definitionProvider = definitionProvider;
        this.functionSideEffectMap = Maps.newHashMap();
        this.allFunctionCalls = Lists.newArrayList();
        this.externs = null;
        this.root = null;
    }

    @Override
    public void process(Node externsAst, Node srcAst) {
        if (this.externs != null || this.root != null) {
            throw new IllegalStateException("It is illegal to call PureFunctionIdentifier.process twice the same instance.  Please use a new PureFunctionIdentifier instance each time.");
        }
        this.externs = externsAst;
        this.root = srcAst;
        NodeTraversal.traverse(this.compiler, this.externs, new FunctionAnalyzer(true));
        NodeTraversal.traverse(this.compiler, this.root, new FunctionAnalyzer(false));
        this.propagateSideEffects();
        this.markPureFunctionCalls();
    }

    String getDebugReport() {
        FunctionInformation functionInfo;
        Node function;
        Preconditions.checkNotNull((Object)this.externs);
        Preconditions.checkNotNull((Object)this.root);
        StringBuilder sb = new StringBuilder();
        FunctionNames functionNames = new FunctionNames(this.compiler);
        functionNames.process(null, this.externs);
        functionNames.process(null, this.root);
        sb.append("Pure functions:\n");
        for (Map.Entry<Node, FunctionInformation> entry : this.functionSideEffectMap.entrySet()) {
            function = entry.getKey();
            functionInfo = entry.getValue();
            boolean isPure = functionInfo.mayBePure() && !functionInfo.mayHaveSideEffects();
            if (!isPure) continue;
            sb.append("  " + functionNames.getFunctionName(function) + "\n");
        }
        sb.append("\n");
        for (Map.Entry<Node, FunctionInformation> entry : this.functionSideEffectMap.entrySet()) {
            function = entry.getKey();
            functionInfo = entry.getValue();
            HashSet depFunctionNames = Sets.newHashSet();
            for (Node callSite : functionInfo.getCallsInFunctionBody()) {
                Collection<DefinitionsRemover.Definition> defs = PureFunctionIdentifier.getCallableDefinitions(this.definitionProvider, callSite.getFirstChild());
                if (defs == null) {
                    depFunctionNames.add("<null def list>");
                    continue;
                }
                for (DefinitionsRemover.Definition def : defs) {
                    depFunctionNames.add(functionNames.getFunctionName(def.getRValue()));
                }
            }
            sb.append(functionNames.getFunctionName(function) + " " + functionInfo.toString() + " Calls: " + depFunctionNames + "\n");
        }
        return sb.toString();
    }

    private static Collection<DefinitionsRemover.Definition> getCallableDefinitions(DefinitionProvider definitionProvider, Node name) {
        if (name.isGetProp() || name.isName()) {
            ArrayList result = Lists.newArrayList();
            Collection<DefinitionsRemover.Definition> decls = definitionProvider.getDefinitionsReferencedAt(name);
            if (decls == null) {
                return null;
            }
            for (DefinitionsRemover.Definition current : decls) {
                Node rValue = current.getRValue();
                if (rValue != null && rValue.isFunction()) {
                    result.add(current);
                    continue;
                }
                return null;
            }
            return result;
        }
        if (name.isOr() || name.isHook()) {
            Node firstVal = name.isHook() ? name.getFirstChild().getNext() : name.getFirstChild();
            Collection<DefinitionsRemover.Definition> defs1 = PureFunctionIdentifier.getCallableDefinitions(definitionProvider, firstVal);
            Collection<DefinitionsRemover.Definition> defs2 = PureFunctionIdentifier.getCallableDefinitions(definitionProvider, firstVal.getNext());
            if (defs1 != null && defs2 != null) {
                defs1.addAll(defs2);
                return defs1;
            }
            return null;
        }
        if (NodeUtil.isFunctionExpression(name)) {
            return Lists.newArrayList((Object[])new DefinitionsRemover.Definition[]{new DefinitionsRemover.FunctionExpressionDefinition(name, false)});
        }
        return null;
    }

    private void propagateSideEffects() {
        LinkedDirectedGraph<FunctionInformation, Node> sideEffectGraph = LinkedDirectedGraph.createWithoutAnnotations();
        for (FunctionInformation functionInfo : this.functionSideEffectMap.values()) {
            ((Graph)sideEffectGraph).createNode(functionInfo);
        }
        block1: for (FunctionInformation functionInfo : this.functionSideEffectMap.values()) {
            if (!functionInfo.mayHaveSideEffects()) continue;
            for (Node callSite : functionInfo.getCallsInFunctionBody()) {
                Node callee = callSite.getFirstChild();
                Collection<DefinitionsRemover.Definition> defs = PureFunctionIdentifier.getCallableDefinitions(this.definitionProvider, callee);
                if (defs == null) {
                    functionInfo.setTaintsUnknown();
                    continue block1;
                }
                for (DefinitionsRemover.Definition def : defs) {
                    Node defValue = def.getRValue();
                    FunctionInformation dep = this.functionSideEffectMap.get(defValue);
                    Preconditions.checkNotNull((Object)dep);
                    ((Graph)sideEffectGraph).connect(dep, callSite, functionInfo);
                }
            }
        }
        FixedPointGraphTraversal.newTraversal(new SideEffectPropagationCallback()).computeFixedPoint(sideEffectGraph);
        for (FunctionInformation functionInfo : this.functionSideEffectMap.values()) {
            if (!functionInfo.mayBePure()) continue;
            functionInfo.setIsPure();
        }
    }

    private void markPureFunctionCalls() {
        for (Node callNode : this.allFunctionCalls) {
            Node name = callNode.getFirstChild();
            Collection<DefinitionsRemover.Definition> defs = PureFunctionIdentifier.getCallableDefinitions(this.definitionProvider, name);
            Node.SideEffectFlags flags = new Node.SideEffectFlags();
            if (defs == null) {
                flags.setMutatesGlobalState();
                flags.setThrows();
                flags.setReturnsTainted();
            } else {
                flags.clearAllFlags();
                for (DefinitionsRemover.Definition def : defs) {
                    FunctionInformation functionInfo = this.functionSideEffectMap.get(def.getRValue());
                    Preconditions.checkNotNull((Object)functionInfo);
                    if (functionInfo.mutatesGlobalState()) {
                        flags.setMutatesGlobalState();
                    }
                    if (functionInfo.functionThrows) {
                        flags.setThrows();
                    }
                    if (!callNode.isNew() && functionInfo.taintsThis) {
                        flags.setMutatesThis();
                    }
                    if (functionInfo.taintsReturn) {
                        flags.setReturnsTainted();
                    }
                    if (!flags.areAllFlagsSet()) continue;
                    break;
                }
            }
            if (callNode.isCall()) {
                Preconditions.checkState((this.compiler != null ? 1 : 0) != 0);
                if (!NodeUtil.functionCallHasSideEffects(callNode, this.compiler)) {
                    flags.clearSideEffectFlags();
                }
            } else if (callNode.isNew() && !NodeUtil.constructorCallHasSideEffects(callNode)) {
                flags.clearSideEffectFlags();
            }
            callNode.setSideEffectFlags(flags.valueOf());
        }
    }

    private static boolean isIncDec(Node n) {
        int type = n.getType();
        return type == 102 || type == 103;
    }

    private static boolean isKnownLocalValue(Node value) {
        Predicate<Node> taintingPredicate = new Predicate<Node>(){

            public boolean apply(Node value) {
                switch (value.getType()) {
                    case 86: {
                        return false;
                    }
                    case 42: {
                        return false;
                    }
                    case 38: {
                        return false;
                    }
                    case 33: 
                    case 35: {
                        return false;
                    }
                    case 37: {
                        return false;
                    }
                }
                return false;
            }
        };
        return NodeUtil.evaluatesToLocalValue(value, taintingPredicate);
    }

    private static Node getCallThisObject(Node callSite) {
        Node callTarget = callSite.getFirstChild();
        if (!NodeUtil.isGet(callTarget)) {
            return null;
        }
        String propString = callTarget.getLastChild().getString();
        if (propString.equals("call") || propString.equals("apply")) {
            return callTarget.getNext();
        }
        return callTarget.getFirstChild();
    }

    private static boolean isCallOrApply(Node callSite) {
        String propString;
        Node callTarget = callSite.getFirstChild();
        return NodeUtil.isGet(callTarget) && ((propString = callTarget.getLastChild().getString()).equals("call") || propString.equals("apply"));
    }

    static class Driver
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final String reportPath;
        private final boolean useNameReferenceGraph;

        Driver(AbstractCompiler compiler, String reportPath, boolean useNameReferenceGraph) {
            this.compiler = compiler;
            this.reportPath = reportPath;
            this.useNameReferenceGraph = useNameReferenceGraph;
        }

        @Override
        public void process(Node externs, Node root) {
            DefinitionProvider definitionProvider = null;
            if (this.useNameReferenceGraph) {
                NameReferenceGraphConstruction graphBuilder = new NameReferenceGraphConstruction(this.compiler);
                graphBuilder.process(externs, root);
                definitionProvider = graphBuilder.getNameReferenceGraph();
            } else {
                SimpleDefinitionFinder defFinder = new SimpleDefinitionFinder(this.compiler);
                defFinder.process(externs, root);
                definitionProvider = defFinder;
            }
            PureFunctionIdentifier pureFunctionIdentifier = new PureFunctionIdentifier(this.compiler, definitionProvider);
            pureFunctionIdentifier.process(externs, root);
            if (this.reportPath != null) {
                try {
                    Files.write((CharSequence)pureFunctionIdentifier.getDebugReport(), (File)new File(this.reportPath), (Charset)Charsets.UTF_8);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class FunctionInformation {
        private final boolean extern;
        private final List<Node> callsInFunctionBody = Lists.newArrayList();
        private Set<Scope.Var> blacklisted = Sets.newHashSet();
        private Set<Scope.Var> taintedLocals = Sets.newHashSet();
        private Set<String> knownLocals = Sets.newHashSet();
        private boolean pureFunction = false;
        private boolean functionThrows = false;
        private boolean taintsGlobalState = false;
        private boolean taintsThis = false;
        private boolean taintsArguments = false;
        private boolean taintsUnknown = false;
        private boolean taintsReturn = false;

        FunctionInformation(boolean extern) {
            this.extern = extern;
            this.checkInvariant();
        }

        void addTaintedLocalObject(Scope.Var var) {
            this.taintedLocals.add(var);
        }

        void resetLocalVars() {
            this.blacklisted = null;
            this.taintedLocals = null;
            this.knownLocals = Collections.emptySet();
        }

        public void blacklistLocal(Scope.Var var) {
            this.blacklisted.add(var);
        }

        boolean mayBePure() {
            return !this.functionThrows && !this.taintsGlobalState && !this.taintsThis && !this.taintsArguments && !this.taintsUnknown;
        }

        boolean mayHaveSideEffects() {
            return !this.pureFunction;
        }

        void setIsPure() {
            this.pureFunction = true;
            this.checkInvariant();
        }

        void setTaintsGlobalState() {
            this.taintsGlobalState = true;
            this.checkInvariant();
        }

        void setTaintsThis() {
            this.taintsThis = true;
            this.checkInvariant();
        }

        void setTaintsArguments() {
            this.taintsArguments = true;
            this.checkInvariant();
        }

        void setFunctionThrows() {
            this.functionThrows = true;
            this.checkInvariant();
        }

        void setTaintsUnknown() {
            this.taintsUnknown = true;
            this.checkInvariant();
        }

        void setTaintsReturn() {
            this.taintsReturn = true;
            this.checkInvariant();
        }

        boolean mutatesGlobalState() {
            return this.taintsGlobalState || this.taintsArguments || this.taintsUnknown;
        }

        boolean mutatesThis() {
            return this.taintsThis;
        }

        boolean functionThrows() {
            return this.functionThrows;
        }

        private void checkInvariant() {
            boolean invariant;
            boolean bl = invariant = this.mayBePure() || this.mayHaveSideEffects();
            if (!invariant) {
                throw new IllegalStateException("Invariant failed.  " + this.toString());
            }
        }

        void appendCall(Node callNode) {
            this.callsInFunctionBody.add(callNode);
        }

        List<Node> getCallsInFunctionBody() {
            return this.callsInFunctionBody;
        }

        public String toString() {
            ArrayList status = Lists.newArrayList();
            if (this.extern) {
                status.add("extern");
            }
            if (this.pureFunction) {
                status.add("pure");
            }
            if (this.taintsThis) {
                status.add("this");
            }
            if (this.taintsGlobalState) {
                status.add("global");
            }
            if (this.functionThrows) {
                status.add("throw");
            }
            if (this.taintsUnknown) {
                status.add("complex");
            }
            return "Side effects: " + ((Object)status).toString();
        }
    }

    private static class SideEffectPropagationCallback
    implements FixedPointGraphTraversal.EdgeCallback<FunctionInformation, Node> {
        private SideEffectPropagationCallback() {
        }

        @Override
        public boolean traverseEdge(FunctionInformation callee, Node callSite, FunctionInformation caller) {
            Preconditions.checkArgument((callSite.isCall() || callSite.isNew() ? 1 : 0) != 0);
            boolean changed = false;
            if (!caller.mutatesGlobalState() && callee.mutatesGlobalState()) {
                caller.setTaintsGlobalState();
                changed = true;
            }
            if (!caller.functionThrows() && callee.functionThrows()) {
                caller.setFunctionThrows();
                changed = true;
            }
            if (callee.mutatesThis() && !callSite.isNew()) {
                Node objectNode = PureFunctionIdentifier.getCallThisObject(callSite);
                if (objectNode != null && objectNode.isName() && !PureFunctionIdentifier.isCallOrApply(callSite)) {
                    String name = objectNode.getString();
                    if (!caller.mutatesGlobalState()) {
                        caller.setTaintsGlobalState();
                        changed = true;
                    }
                } else if (objectNode != null && objectNode.isThis()) {
                    if (!caller.mutatesThis()) {
                        caller.setTaintsThis();
                        changed = true;
                    }
                } else if (!(objectNode != null && NodeUtil.evaluatesToLocalValue(objectNode) && !PureFunctionIdentifier.isCallOrApply(callSite) || caller.mutatesGlobalState())) {
                    caller.setTaintsGlobalState();
                    changed = true;
                }
            }
            return changed;
        }
    }

    private class FunctionAnalyzer
    implements NodeTraversal.ScopedCallback {
        private final boolean inExterns;

        FunctionAnalyzer(boolean inExterns) {
            this.inExterns = inExterns;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal traversal, Node node, Node parent) {
            if (node.isFunction()) {
                Node gramp = parent.getParent();
                this.visitFunction(traversal, node, parent, gramp);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            Node enclosingFunction;
            if (this.inExterns) {
                return;
            }
            if (!NodeUtil.nodeTypeMayHaveSideEffects(node) && !node.isReturn()) {
                return;
            }
            if (node.isCall() || node.isNew()) {
                PureFunctionIdentifier.this.allFunctionCalls.add(node);
            }
            if ((enclosingFunction = traversal.getEnclosingFunction()) != null) {
                FunctionInformation sideEffectInfo = (FunctionInformation)PureFunctionIdentifier.this.functionSideEffectMap.get(enclosingFunction);
                Preconditions.checkNotNull((Object)sideEffectInfo);
                if (NodeUtil.isAssignmentOp(node)) {
                    this.visitAssignmentOrUnaryOperator(sideEffectInfo, traversal.getScope(), node, node.getFirstChild(), node.getLastChild());
                } else {
                    switch (node.getType()) {
                        case 30: 
                        case 37: {
                            this.visitCall(sideEffectInfo, node);
                            break;
                        }
                        case 31: 
                        case 102: 
                        case 103: {
                            this.visitAssignmentOrUnaryOperator(sideEffectInfo, traversal.getScope(), node, node.getFirstChild(), null);
                            break;
                        }
                        case 38: {
                            Preconditions.checkArgument((boolean)NodeUtil.isVarDeclaration(node));
                            Node value = node.getFirstChild();
                            if (value == null || NodeUtil.evaluatesToLocalValue(value)) break;
                            Scope scope = traversal.getScope();
                            Scope.Var var = scope.getVar(node.getString());
                            sideEffectInfo.blacklistLocal(var);
                            break;
                        }
                        case 49: {
                            this.visitThrow(sideEffectInfo);
                            break;
                        }
                        case 4: {
                            if (!node.hasChildren() || NodeUtil.evaluatesToLocalValue(node.getFirstChild())) break;
                            sideEffectInfo.setTaintsReturn();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unhandled side effect node type " + Token.name(node.getType()));
                        }
                    }
                }
            }
        }

        @Override
        public void enterScope(NodeTraversal t) {
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            FunctionInformation sideEffectInfo = (FunctionInformation)PureFunctionIdentifier.this.functionSideEffectMap.get(t.getScopeRoot());
            if (sideEffectInfo.mutatesGlobalState()) {
                sideEffectInfo.resetLocalVars();
                return;
            }
            Iterator<Scope.Var> i = t.getScope().getVars();
            while (i.hasNext()) {
                Scope.Var v = i.next();
                boolean localVar = false;
                if (v.getParentNode().isVar()) {
                    sideEffectInfo.knownLocals.add(v.getName());
                    localVar = true;
                }
                if (localVar && !sideEffectInfo.blacklisted.contains(v) || !sideEffectInfo.taintedLocals.contains(v)) continue;
                sideEffectInfo.setTaintsUnknown();
                sideEffectInfo.resetLocalVars();
                break;
            }
            sideEffectInfo.taintedLocals = null;
            sideEffectInfo.blacklisted = null;
        }

        private void visitAssignmentOrUnaryOperator(FunctionInformation sideEffectInfo, Scope scope, Node op, Node lhs, Node rhs) {
            if (lhs.isName()) {
                Scope.Var var = scope.getVar(lhs.getString());
                if (var == null || var.scope != scope) {
                    sideEffectInfo.setTaintsGlobalState();
                } else {
                    Preconditions.checkState((NodeUtil.isAssignmentOp(op) || PureFunctionIdentifier.isIncDec(op) || op.isDelProp() ? 1 : 0) != 0);
                    if (rhs != null && op.isAssign() && !NodeUtil.evaluatesToLocalValue(rhs)) {
                        sideEffectInfo.blacklistLocal(var);
                    }
                }
            } else if (NodeUtil.isGet(lhs)) {
                if (lhs.getFirstChild().isThis()) {
                    sideEffectInfo.setTaintsThis();
                } else {
                    Scope.Var var = null;
                    Node objectNode = lhs.getFirstChild();
                    if (objectNode.isName()) {
                        var = scope.getVar(objectNode.getString());
                    }
                    if (var == null || var.scope != scope) {
                        sideEffectInfo.setTaintsUnknown();
                    } else {
                        sideEffectInfo.addTaintedLocalObject(var);
                    }
                }
            } else {
                sideEffectInfo.setTaintsUnknown();
            }
        }

        private void visitCall(FunctionInformation sideEffectInfo, Node node) {
            if (node.isCall() && !NodeUtil.functionCallHasSideEffects(node, PureFunctionIdentifier.this.compiler)) {
                return;
            }
            if (node.isNew() && !NodeUtil.constructorCallHasSideEffects(node)) {
                return;
            }
            sideEffectInfo.appendCall(node);
        }

        private void visitFunction(NodeTraversal traversal, Node node, Node parent, Node gramp) {
            JSDocInfo info;
            Preconditions.checkArgument((!PureFunctionIdentifier.this.functionSideEffectMap.containsKey(node) ? 1 : 0) != 0);
            FunctionInformation sideEffectInfo = new FunctionInformation(this.inExterns);
            PureFunctionIdentifier.this.functionSideEffectMap.put(node, sideEffectInfo);
            if (this.inExterns) {
                JSType jstypeReturn;
                JSType jstype = node.getJSType();
                boolean knownLocalResult = false;
                FunctionType functionType = JSType.toMaybeFunctionType(jstype);
                if (functionType != null && this.isLocalValueType(jstypeReturn = functionType.getReturnType(), true)) {
                    knownLocalResult = true;
                }
                if (!knownLocalResult) {
                    sideEffectInfo.setTaintsReturn();
                }
            }
            if ((info = this.getJSDocInfoForFunction(node, parent, gramp)) != null) {
                boolean hasSpecificSideEffects = false;
                if (this.hasSideEffectsThisAnnotation(info)) {
                    if (this.inExterns) {
                        hasSpecificSideEffects = true;
                        sideEffectInfo.setTaintsThis();
                    } else {
                        traversal.report(node, INVALID_MODIFIES_ANNOTATION, new String[0]);
                    }
                }
                if (this.hasSideEffectsArgumentsAnnotation(info)) {
                    if (this.inExterns) {
                        hasSpecificSideEffects = true;
                        sideEffectInfo.setTaintsArguments();
                    } else {
                        traversal.report(node, INVALID_MODIFIES_ANNOTATION, new String[0]);
                    }
                }
                if (!hasSpecificSideEffects) {
                    if (this.hasNoSideEffectsAnnotation(info)) {
                        if (this.inExterns) {
                            sideEffectInfo.setIsPure();
                        } else {
                            traversal.report(node, INVALID_NO_SIDE_EFFECT_ANNOTATION, new String[0]);
                        }
                    } else if (this.inExterns) {
                        sideEffectInfo.setTaintsGlobalState();
                    }
                }
            } else if (this.inExterns) {
                sideEffectInfo.setTaintsGlobalState();
            }
        }

        private boolean isLocalValueType(JSType jstype, boolean recurse) {
            Preconditions.checkNotNull((Object)jstype);
            JSType subtype = jstype.getGreatestSubtype(PureFunctionIdentifier.this.compiler.getTypeRegistry().getNativeType(JSTypeNative.OBJECT_TYPE));
            return subtype.isNoType();
        }

        private void visitThrow(FunctionInformation sideEffectInfo) {
            sideEffectInfo.setFunctionThrows();
        }

        private JSDocInfo getJSDocInfoForFunction(Node node, Node parent, Node gramp) {
            JSDocInfo info = node.getJSDocInfo();
            if (info != null) {
                return info;
            }
            if (parent.isName()) {
                return gramp.hasOneChild() ? gramp.getJSDocInfo() : null;
            }
            if (parent.isAssign()) {
                return parent.getJSDocInfo();
            }
            return null;
        }

        private boolean hasNoSideEffectsAnnotation(JSDocInfo docInfo) {
            Preconditions.checkNotNull((Object)docInfo);
            return docInfo.isNoSideEffects();
        }

        private boolean hasSideEffectsThisAnnotation(JSDocInfo docInfo) {
            Preconditions.checkNotNull((Object)docInfo);
            return docInfo.getModifies().contains("this");
        }

        private boolean hasSideEffectsArgumentsAnnotation(JSDocInfo docInfo) {
            Preconditions.checkNotNull((Object)docInfo);
            Set<String> modifies = docInfo.getModifies();
            return modifies.size() > 1 || modifies.size() == 1 && !modifies.contains("this");
        }
    }
}

