/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.CompilerEnvirons;
import com.google.javascript.rhino.Context;
import com.google.javascript.rhino.Decompiler;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.EvaluatorException;
import com.google.javascript.rhino.FunctionNode;
import com.google.javascript.rhino.IRFactory;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JavaScriptException;
import com.google.javascript.rhino.Kit;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjArray;
import com.google.javascript.rhino.RhinoException;
import com.google.javascript.rhino.ScriptOrFnNode;
import com.google.javascript.rhino.ScriptRuntime;
import com.google.javascript.rhino.SimpleErrorReporter;
import com.google.javascript.rhino.TokenStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.List;

public class Parser {
    static final int CLEAR_TI_MASK = 65535;
    static final int TI_AFTER_EOL = 65536;
    static final int TI_CHECK_LABEL = 131072;
    CompilerEnvirons compilerEnv;
    private ErrorReporter errorReporter;
    private String sourceURI;
    boolean calledByCompileFunction;
    private TokenStream ts;
    private int currentFlaggedToken;
    private int syntaxErrorCount;
    private IRFactory nf;
    private int nestingOfFunction;
    private Decompiler decompiler;
    ScriptOrFnNode currentScriptOrFn;
    private int nestingOfWith;
    private Hashtable<String, Node> labelSet;
    private ObjArray loopSet;
    private ObjArray loopAndSwitchSet;
    private boolean hasReturnValue;
    private int functionEndFlags;

    public static ScriptOrFnNode parse(String sourceString, String sourceURI) {
        return Parser.parse(sourceString, sourceURI, false);
    }

    public static ScriptOrFnNode parseWithJSDoc(String sourceString, String sourceURI) {
        return Parser.parse(sourceString, sourceURI, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptOrFnNode parse(String sourceString, String sourceURI, boolean parseJSDoc) {
        Context cx = Context.enter();
        SimpleErrorReporter errorReporter = new SimpleErrorReporter();
        cx.setErrorReporter(errorReporter);
        CompilerEnvirons compilerEnv = new CompilerEnvirons();
        compilerEnv.initFromContext(cx);
        if (parseJSDoc) {
            compilerEnv.setParseJSDoc(true);
        }
        Parser p = new Parser(compilerEnv, errorReporter);
        ScriptOrFnNode root = null;
        try {
            root = p.parse(sourceString, sourceURI, 1);
        }
        catch (EvaluatorException e) {
            errorReporter.error(e.details(), e.sourceName(), e.lineNumber(), e.lineSource(), e.lineNumber());
        }
        finally {
            Context.exit();
        }
        List<String> errors = errorReporter.errors();
        if (errors != null) {
            StringBuilder message = new StringBuilder();
            for (String error : errors) {
                if (message.length() > 0) {
                    message.append('\n');
                }
                message.append(error);
            }
            throw new RhinoException(message.toString());
        }
        return root;
    }

    public Parser(CompilerEnvirons compilerEnv, ErrorReporter errorReporter) {
        this.compilerEnv = compilerEnv;
        this.errorReporter = errorReporter;
    }

    Decompiler createDecompiler(CompilerEnvirons compilerEnv) {
        return new Decompiler();
    }

    void addStrictWarning(String messageId, String messageArg) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(messageId, messageArg);
        }
    }

    void addWarning(String messageId) {
        this.reportWarning(ScriptRuntime.getMessage0(messageId), this.ts.getLineno(), this.ts.getOffset(), this.ts.getLine());
    }

    void addWarning(String messageId, String messageArg) {
        this.reportWarning(ScriptRuntime.getMessage1(messageId, messageArg), this.ts.getLineno(), this.ts.getOffset(), this.ts.getLine());
    }

    void addWarning(String messageId, int lineno, int charno) {
        this.reportWarning(ScriptRuntime.getMessage0(messageId), lineno, charno, null);
    }

    void addWarning(String messageId, String messageArg, int lineno, int charno) {
        this.reportWarning(ScriptRuntime.getMessage1(messageId, messageArg), lineno, charno, null);
    }

    private void reportWarning(String message, int lineno, int charno, String code) {
        if (this.compilerEnv.reportWarningAsError()) {
            ++this.syntaxErrorCount;
            this.errorReporter.error(message, this.sourceURI, lineno, code, charno);
        } else {
            this.errorReporter.warning(message, this.sourceURI, lineno, code, charno);
        }
    }

    void addError(String messageId) {
        ++this.syntaxErrorCount;
        String message = ScriptRuntime.getMessage0(messageId);
        this.errorReporter.error(message, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
    }

    void addError(String messageId, String messageArg) {
        ++this.syntaxErrorCount;
        String message = ScriptRuntime.getMessage1(messageId, messageArg);
        this.errorReporter.error(message, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
    }

    RuntimeException reportError(String messageId) {
        this.addError(messageId);
        throw new ParserException();
    }

    private int peekToken() throws IOException {
        int tt = this.currentFlaggedToken;
        if (tt == 0) {
            tt = this.ts.getToken();
            if (tt == 1) {
                while ((tt = this.ts.getToken()) == 1) {
                }
                tt |= 0x10000;
            }
            this.currentFlaggedToken = tt;
        }
        return tt & 0xFFFF;
    }

    private int peekFlaggedToken() throws IOException {
        this.peekToken();
        return this.currentFlaggedToken;
    }

    private void consumeToken() {
        this.currentFlaggedToken = 0;
    }

    private int nextToken() throws IOException {
        int tt = this.peekToken();
        this.consumeToken();
        return tt;
    }

    private int nextFlaggedToken() throws IOException {
        this.peekToken();
        int ttFlagged = this.currentFlaggedToken;
        this.consumeToken();
        return ttFlagged;
    }

    private boolean matchToken(int toMatch) throws IOException {
        int tt = this.peekToken();
        if (tt != toMatch) {
            return false;
        }
        this.consumeToken();
        return true;
    }

    private int peekTokenOrEOL() throws IOException {
        int tt = this.peekToken();
        if ((this.currentFlaggedToken & 0x10000) != 0) {
            tt = 1;
        }
        return tt;
    }

    private void setCheckForLabel() {
        if ((this.currentFlaggedToken & 0xFFFF) != 38) {
            throw Kit.codeBug();
        }
        this.currentFlaggedToken |= 0x20000;
    }

    private void mustMatchToken(int toMatch, String messageId) throws IOException, ParserException {
        if (!this.matchToken(toMatch)) {
            this.reportError(messageId);
        }
    }

    private void mustHaveXML() {
        if (!this.compilerEnv.isXmlAvailable()) {
            this.reportError("msg.XML.not.available");
        }
    }

    boolean insideFunction() {
        return this.nestingOfFunction != 0;
    }

    private Node enterSwitch(Node switchSelector, int lineno, int charno) {
        Node switchNode = this.nf.createSwitch(lineno, charno);
        switchNode.addChildToBack(switchSelector);
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ObjArray();
        }
        this.loopAndSwitchSet.push(switchNode);
        return switchNode;
    }

    private void exitSwitch() {
        this.loopAndSwitchSet.pop();
    }

    public TokenStream initForUnitTest(Reader sourceReader, String sourceURI, int lineno, boolean parseJSDoc) {
        this.sourceURI = sourceURI;
        this.ts = new TokenStream(this, sourceReader, null, lineno);
        return this.ts;
    }

    public ScriptOrFnNode parse(String sourceString, String sourceURI, int lineno) {
        this.sourceURI = sourceURI;
        this.ts = new TokenStream(this, null, sourceString, lineno);
        try {
            return this.parse();
        }
        catch (IOException ex) {
            throw new IllegalStateException();
        }
    }

    public ScriptOrFnNode parse(Reader sourceReader, String sourceURI, int lineno) throws IOException {
        this.sourceURI = sourceURI;
        this.ts = new TokenStream(this, sourceReader, null, lineno);
        return this.parse();
    }

    private ScriptOrFnNode parse() throws IOException {
        this.decompiler = this.createDecompiler(this.compilerEnv);
        this.nf = new IRFactory(this);
        this.currentScriptOrFn = this.nf.createScript();
        int sourceStartOffset = this.decompiler.getCurrentOffset();
        this.decompiler.addToken(132);
        this.currentFlaggedToken = 0;
        this.syntaxErrorCount = 0;
        this.ts.setFileLevelJsDocBuilder(this.currentScriptOrFn.getJsDocBuilderForNode());
        int baseLineno = this.ts.getLineno();
        int baseCharno = this.ts.getCharno();
        Node pn = this.nf.createLeaf(125, baseLineno, baseCharno);
        try {
            int tt;
            while ((tt = this.peekToken()) > 0) {
                Node n;
                block8: {
                    if (tt == 105) {
                        this.consumeToken();
                        try {
                            n = this.function(this.calledByCompileFunction ? 2 : 1);
                            break block8;
                        }
                        catch (ParserException e) {
                            break;
                        }
                    }
                    n = this.statement();
                }
                this.nf.addChildToBack(pn, n);
            }
        }
        catch (StackOverflowError ex) {
            String msg = ScriptRuntime.getMessage0("msg.too.deep.parser.recursion");
            throw Context.reportRuntimeError(msg, this.sourceURI, this.ts.getLineno(), null, 0);
        }
        if (this.syntaxErrorCount != 0) {
            String msg = String.valueOf(this.syntaxErrorCount);
            msg = ScriptRuntime.getMessage1("msg.got.syntax.errors", msg);
            throw this.errorReporter.runtimeError(msg, this.sourceURI, baseLineno, null, 0);
        }
        this.currentScriptOrFn.setSourceName(this.sourceURI);
        this.currentScriptOrFn.setBaseLineno(baseLineno);
        this.currentScriptOrFn.setEndLineno(this.ts.getLineno());
        if (this.currentScriptOrFn.getJSDocInfo() == null) {
            this.currentScriptOrFn.setJSDocInfo(this.ts.getFileOverviewJSDocInfo());
        }
        int sourceEndOffset = this.decompiler.getCurrentOffset();
        this.currentScriptOrFn.setEncodedSourceBounds(sourceStartOffset, sourceEndOffset);
        this.nf.initScript(this.currentScriptOrFn, pn);
        this.currentScriptOrFn.setIsSyntheticBlock(true);
        this.decompiler = null;
        return this.currentScriptOrFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node parseFunctionBody() throws IOException {
        Node pn;
        block10: {
            ++this.nestingOfFunction;
            pn = this.nf.createBlock(this.ts.getLineno(), this.ts.getCharno());
            try {
                while (true) {
                    Node n;
                    int tt = this.peekToken();
                    switch (tt) {
                        case -1: 
                        case 0: 
                        case 82: {
                            break block10;
                        }
                        case 105: {
                            this.consumeToken();
                            n = this.function(1);
                            break;
                        }
                        default: {
                            n = this.statement();
                        }
                    }
                    this.nf.addChildToBack(pn, n);
                }
            }
            catch (ParserException parserException) {
            }
            finally {
                --this.nestingOfFunction;
            }
        }
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node function(int functionType) throws IOException, ParserException {
        int functionSourceEnd;
        Node body;
        Node args;
        int nameCharno;
        int nameLineno;
        String name;
        int syntheticType = functionType;
        int baseLineno = this.ts.getLineno();
        int baseCharno = this.ts.getCharno();
        int functionSourceStart = this.decompiler.markFunctionStart(functionType);
        Node memberExprNode = null;
        if (this.matchToken(38)) {
            name = this.ts.getString();
            nameLineno = this.ts.getLineno();
            nameCharno = this.ts.getCharno();
            this.decompiler.addName(name);
            if (!this.matchToken(83)) {
                if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                    Node memberExprHead = this.nf.createName(name, nameLineno, nameCharno);
                    name = "";
                    memberExprNode = this.memberExprTail(false, memberExprHead);
                }
                this.mustMatchToken(83, "msg.no.paren.parms");
            }
        } else {
            name = "";
            nameLineno = this.ts.getLineno();
            nameCharno = this.ts.getCharno();
            if (!this.matchToken(83)) {
                if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                    memberExprNode = this.memberExpr(false);
                }
                this.mustMatchToken(83, "msg.no.paren.parms");
            }
        }
        if (memberExprNode != null) {
            syntheticType = 2;
        }
        boolean nested = this.insideFunction();
        FunctionNode fnNode = this.nf.createFunction(name, nameLineno, nameCharno);
        if (nested || this.nestingOfWith > 0) {
            fnNode.itsIgnoreDynamicScope = true;
        }
        int functionIndex = this.currentScriptOrFn.addFunction(fnNode);
        ScriptOrFnNode savedScriptOrFn = this.currentScriptOrFn;
        this.currentScriptOrFn = fnNode;
        int savedNestingOfWith = this.nestingOfWith;
        this.nestingOfWith = 0;
        Hashtable<String, Node> savedLabelSet = this.labelSet;
        this.labelSet = null;
        ObjArray savedLoopSet = this.loopSet;
        this.loopSet = null;
        ObjArray savedLoopAndSwitchSet = this.loopAndSwitchSet;
        this.loopAndSwitchSet = null;
        boolean savedHasReturnValue = this.hasReturnValue;
        int savedFunctionEndFlags = this.functionEndFlags;
        JSDocInfo info = this.ts.getAndResetJSDocInfo();
        try {
            this.decompiler.addToken(83);
            args = this.nf.createLeaf(83, this.ts.getLineno(), this.ts.getCharno());
            if (!this.matchToken(84)) {
                boolean first = true;
                do {
                    if (!first) {
                        this.decompiler.addToken(85);
                    }
                    first = false;
                    this.mustMatchToken(38, "msg.no.parm");
                    String s = this.ts.getString();
                    this.nf.addChildToBack(args, this.nf.createName(s, this.ts.getLineno(), this.ts.getCharno()));
                    this.decompiler.addName(s);
                } while (this.matchToken(85));
                this.mustMatchToken(84, "msg.no.paren.after.parms");
            }
            this.decompiler.addToken(84);
            this.mustMatchToken(81, "msg.no.brace.body");
            this.decompiler.addEOL(81);
            body = this.parseFunctionBody();
            this.mustMatchToken(82, "msg.no.brace.after.body");
            this.decompiler.addToken(82);
            functionSourceEnd = this.decompiler.markFunctionEnd(functionSourceStart);
            if (functionType != 2) {
                int tt;
                if (this.compilerEnv.getLanguageVersion() >= 120 && (tt = this.peekTokenOrEOL()) == 105) {
                    this.reportError("msg.no.semi.stmt");
                }
                this.decompiler.addToken(1);
            }
        }
        finally {
            this.hasReturnValue = savedHasReturnValue;
            this.functionEndFlags = savedFunctionEndFlags;
            this.loopAndSwitchSet = savedLoopAndSwitchSet;
            this.loopSet = savedLoopSet;
            this.labelSet = savedLabelSet;
            this.nestingOfWith = savedNestingOfWith;
            this.currentScriptOrFn = savedScriptOrFn;
        }
        fnNode.setEncodedSourceBounds(functionSourceStart, functionSourceEnd);
        fnNode.setSourceName(this.sourceURI);
        fnNode.setBaseLineno(baseLineno);
        fnNode.setEndLineno(this.ts.getLineno());
        Node pn = this.nf.initFunction(fnNode, functionIndex, args, info, body, syntheticType);
        if (memberExprNode != null) {
            pn = this.nf.createAssignment(86, memberExprNode, pn, baseLineno, baseCharno);
            if (functionType != 2) {
                pn = this.nf.createExprStatementNoReturn(pn, baseLineno, baseCharno);
            }
        }
        return pn;
    }

    private Node statements() throws IOException {
        int tt;
        Node pn = this.nf.createBlock(this.ts.getLineno(), this.ts.getCharno());
        while ((tt = this.peekToken()) > 0 && tt != 82) {
            this.nf.addChildToBack(pn, this.statement());
        }
        return pn;
    }

    private Node condition() throws IOException, ParserException {
        this.mustMatchToken(83, "msg.no.paren.cond");
        this.decompiler.addToken(83);
        Node pn = this.expr(false);
        this.mustMatchToken(84, "msg.no.paren.after.cond");
        this.decompiler.addToken(84);
        if (pn.getProp(35) == null && (pn.getType() == 8 || pn.getType() == 34 || pn.getType() == 36)) {
            this.addStrictWarning("msg.equal.as.assign", "");
        }
        return pn;
    }

    private String matchLabel() throws IOException, JavaScriptException {
        int lineno = this.ts.getLineno();
        String label = null;
        int tt = this.peekTokenOrEOL();
        if (tt == 38) {
            this.consumeToken();
            label = this.ts.getString();
            this.decompiler.addName(label);
            Node n = null;
            if (this.labelSet != null) {
                n = this.labelSet.get(label);
            }
            if (n == null) {
                this.reportError("msg.undef.label");
            }
        }
        return label;
    }

    private Node statement() throws IOException {
        try {
            Node pn = this.statementHelper(null);
            if (pn != null) {
                if (this.compilerEnv.isStrictMode() && !pn.hasSideEffects()) {
                    this.addStrictWarning("msg.no.side.effects", "");
                }
                return pn;
            }
        }
        catch (ParserException e) {
            // empty catch block
        }
        int lineno = this.ts.getLineno();
        int charno = this.ts.getCharno();
        block5: while (true) {
            int tt = this.peekTokenOrEOL();
            this.consumeToken();
            switch (tt) {
                case -1: 
                case 0: 
                case 1: 
                case 78: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        return this.nf.createExprStatement(this.nf.createErrorName(), lineno, charno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node statementHelper(Node statementLabel) throws IOException, ParserException {
        Node pn = null;
        int tt = this.peekToken();
        switch (tt) {
            case 108: {
                this.consumeToken();
                this.decompiler.addToken(108);
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                Node cond = this.condition();
                this.decompiler.addEOL(81);
                Node ifTrue = this.statement();
                Node ifFalse = null;
                if (this.matchToken(109)) {
                    this.decompiler.addToken(82);
                    this.decompiler.addToken(109);
                    this.decompiler.addEOL(81);
                    ifFalse = this.statement();
                }
                this.decompiler.addEOL(82);
                pn = this.nf.createIf(cond, ifTrue, ifFalse, lineno, charno);
                return pn;
            }
            case 110: {
                this.consumeToken();
                this.decompiler.addToken(110);
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                this.mustMatchToken(83, "msg.no.paren.switch");
                this.decompiler.addToken(83);
                pn = this.enterSwitch(this.expr(false), lineno, charno);
                try {
                    this.mustMatchToken(84, "msg.no.paren.after.switch");
                    this.decompiler.addToken(84);
                    this.mustMatchToken(81, "msg.no.brace.switch");
                    this.decompiler.addEOL(81);
                    boolean hasDefault = false;
                    block41: while (true) {
                        Node caseExpression;
                        tt = this.nextToken();
                        lineno = this.ts.getLineno();
                        charno = this.ts.getCharno();
                        switch (tt) {
                            case 82: {
                                break block41;
                            }
                            case 111: {
                                this.decompiler.addToken(111);
                                caseExpression = this.expr(false);
                                this.mustMatchToken(99, "msg.no.colon.case");
                                this.decompiler.addEOL(99);
                                break;
                            }
                            case 112: {
                                if (hasDefault) {
                                    this.reportError("msg.double.switch.default");
                                }
                                this.decompiler.addToken(112);
                                hasDefault = true;
                                caseExpression = null;
                                this.mustMatchToken(99, "msg.no.colon.case");
                                this.decompiler.addEOL(99);
                                break;
                            }
                            default: {
                                this.reportError("msg.bad.switch");
                                break block41;
                            }
                        }
                        Node block = this.nf.createLeaf(125, lineno, charno);
                        block.setIsSyntheticBlock(true);
                        while ((tt = this.peekToken()) != 82 && tt != 111 && tt != 112 && tt != 0) {
                            this.nf.addChildToBack(block, this.statement());
                        }
                        this.nf.addSwitchCase(pn, caseExpression, block, lineno, charno);
                    }
                    this.decompiler.addEOL(82);
                    this.nf.closeSwitch(pn);
                }
                finally {
                    this.exitSwitch();
                }
                return pn;
            }
            case 113: {
                this.consumeToken();
                this.decompiler.addToken(113);
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                Node cond = this.condition();
                this.decompiler.addEOL(81);
                Node body = this.statement();
                this.decompiler.addEOL(82);
                pn = this.nf.createWhile(cond, body, lineno, charno);
                return pn;
            }
            case 114: {
                this.consumeToken();
                this.decompiler.addToken(114);
                this.decompiler.addEOL(81);
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                Node body = this.statement();
                this.decompiler.addToken(82);
                this.mustMatchToken(113, "msg.no.while.do");
                this.decompiler.addToken(113);
                Node cond = this.condition();
                pn = this.nf.createDoWhile(body, cond, lineno, charno);
                this.matchToken(78);
                this.decompiler.addEOL(78);
                return pn;
            }
            case 115: {
                Node cond;
                Node init;
                this.consumeToken();
                boolean isForEach = false;
                this.decompiler.addToken(115);
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                Node incr = null;
                if (this.matchToken(38)) {
                    this.decompiler.addName(this.ts.getString());
                    if (this.ts.getString().equals("each")) {
                        isForEach = true;
                    } else {
                        this.reportError("msg.no.paren.for");
                    }
                }
                this.mustMatchToken(83, "msg.no.paren.for");
                this.decompiler.addToken(83);
                tt = this.peekToken();
                if (tt == 78) {
                    init = this.nf.createLeaf(124, this.ts.getLineno(), this.ts.getCharno());
                } else if (tt == 118) {
                    this.consumeToken();
                    init = this.variables(115);
                } else {
                    init = this.expr(true);
                }
                if (this.matchToken(51)) {
                    this.decompiler.addToken(51);
                    cond = this.expr(false);
                } else {
                    this.mustMatchToken(78, "msg.no.semi.for");
                    this.decompiler.addToken(78);
                    cond = this.peekToken() == 78 ? this.nf.createLeaf(124, this.ts.getLineno(), this.ts.getCharno()) : this.expr(false);
                    this.mustMatchToken(78, "msg.no.semi.for.cond");
                    this.decompiler.addToken(78);
                    incr = this.peekToken() == 84 ? this.nf.createLeaf(124, this.ts.getLineno(), this.ts.getCharno()) : this.expr(false);
                }
                this.mustMatchToken(84, "msg.no.paren.for.ctrl");
                this.decompiler.addToken(84);
                this.decompiler.addEOL(81);
                Node body = this.statement();
                this.decompiler.addEOL(82);
                pn = incr == null ? this.nf.createForIn(init, cond, body, lineno, charno) : this.nf.createFor(init, cond, incr, body, lineno, charno);
                return pn;
            }
            case 77: {
                this.consumeToken();
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                Node catchblocks = null;
                Node finallyblock = null;
                JSDocInfo info = this.ts.getAndResetJSDocInfo();
                this.decompiler.addToken(77);
                this.decompiler.addEOL(81);
                Node tryblock = this.statement();
                this.decompiler.addEOL(82);
                catchblocks = this.nf.createLeaf(125, this.ts.getLineno(), this.ts.getCharno());
                boolean sawDefaultCatch = false;
                int peek = this.peekToken();
                if (peek == 120) {
                    while (this.matchToken(120)) {
                        int catchLineno = this.ts.getLineno();
                        int catchCharno = this.ts.getCharno();
                        if (sawDefaultCatch) {
                            this.reportError("msg.catch.unreachable");
                        }
                        this.decompiler.addToken(120);
                        this.mustMatchToken(83, "msg.no.paren.catch");
                        this.decompiler.addToken(83);
                        this.mustMatchToken(38, "msg.bad.catchcond");
                        String varName = this.ts.getString();
                        int nameLineno = this.ts.getLineno();
                        int nameCharno = this.ts.getCharno();
                        this.decompiler.addName(varName);
                        Node catchCond = null;
                        if (this.matchToken(108)) {
                            this.decompiler.addToken(108);
                            catchCond = this.expr(false);
                        } else {
                            sawDefaultCatch = true;
                        }
                        this.mustMatchToken(84, "msg.bad.catchcond");
                        this.decompiler.addToken(84);
                        this.mustMatchToken(81, "msg.no.brace.catchblock");
                        this.decompiler.addEOL(81);
                        this.nf.addChildToBack(catchblocks, this.nf.createCatch(varName, nameLineno, nameCharno, catchCond, this.statements(), catchLineno, catchCharno));
                        this.mustMatchToken(82, "msg.no.brace.after.body");
                        this.decompiler.addEOL(82);
                    }
                } else if (peek != 121) {
                    this.mustMatchToken(121, "msg.try.no.catchfinally");
                }
                if (this.matchToken(121)) {
                    this.decompiler.addToken(121);
                    this.decompiler.addEOL(81);
                    finallyblock = this.statement();
                    this.decompiler.addEOL(82);
                }
                pn = this.nf.createTryCatchFinally(tryblock, catchblocks, finallyblock, lineno, charno);
                if (info != null) {
                    pn.setJSDocInfo(info);
                }
                return pn;
            }
            case 49: {
                this.consumeToken();
                if (this.peekTokenOrEOL() == 1) {
                    this.reportError("msg.bad.throw.eol");
                }
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                this.decompiler.addToken(49);
                pn = this.nf.createThrow(this.expr(false), lineno, charno);
                break;
            }
            case 116: {
                this.consumeToken();
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                this.decompiler.addToken(116);
                String label = this.matchLabel();
                if (label != null) {
                    this.decompiler.addToken(38);
                    this.decompiler.addName(label);
                }
                pn = this.nf.createBreak(label, lineno, charno);
                break;
            }
            case 117: {
                this.consumeToken();
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                this.decompiler.addToken(117);
                String label = this.matchLabel();
                if (label != null) {
                    this.decompiler.addToken(38);
                    this.decompiler.addName(label);
                }
                pn = this.nf.createContinue(label, lineno, charno);
                break;
            }
            case 152: {
                this.consumeToken();
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                this.decompiler.addToken(152);
                pn = this.nf.createDebugger(lineno, charno);
                break;
            }
            case 119: {
                Node body;
                this.consumeToken();
                this.decompiler.addToken(119);
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                this.mustMatchToken(83, "msg.no.paren.with");
                this.decompiler.addToken(83);
                Node obj = this.expr(false);
                this.mustMatchToken(84, "msg.no.paren.after.with");
                this.decompiler.addToken(84);
                this.decompiler.addEOL(81);
                ++this.nestingOfWith;
                try {
                    body = this.statement();
                }
                finally {
                    --this.nestingOfWith;
                }
                this.decompiler.addEOL(82);
                pn = this.nf.createWith(obj, body, lineno, charno);
                return pn;
            }
            case 118: 
            case 149: {
                this.consumeToken();
                pn = this.variables(tt);
                break;
            }
            case 4: {
                Node retExpr;
                if (!this.insideFunction()) {
                    this.reportError("msg.bad.return");
                }
                this.consumeToken();
                this.decompiler.addToken(4);
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                tt = this.peekTokenOrEOL();
                switch (tt) {
                    case -1: 
                    case 0: 
                    case 1: 
                    case 78: 
                    case 82: {
                        retExpr = null;
                        break;
                    }
                    default: {
                        retExpr = this.expr(false);
                        this.hasReturnValue = true;
                    }
                }
                pn = this.nf.createReturn(retExpr, lineno, charno);
                break;
            }
            case 81: {
                this.consumeToken();
                if (statementLabel != null) {
                    this.decompiler.addToken(81);
                }
                pn = this.statements();
                this.mustMatchToken(82, "msg.no.brace.block");
                if (statementLabel != null) {
                    this.decompiler.addEOL(82);
                }
                return pn;
            }
            case -1: 
            case 78: {
                this.consumeToken();
                pn = this.nf.createLeaf(124, this.ts.getLineno(), this.ts.getCharno());
                return pn;
            }
            case 105: {
                this.consumeToken();
                pn = this.function(3);
                return pn;
            }
            case 112: {
                this.consumeToken();
                this.mustHaveXML();
                this.decompiler.addToken(112);
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                if (!this.matchToken(38) || !this.ts.getString().equals("xml")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(" xml");
                if (!this.matchToken(38) || !this.ts.getString().equals("namespace")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(" namespace");
                if (!this.matchToken(86)) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addToken(86);
                Node expr = this.expr(false);
                pn = this.nf.createDefaultNamespace(expr, lineno, charno);
                break;
            }
            case 38: {
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                String name = this.ts.getString();
                this.setCheckForLabel();
                pn = this.expr(false);
                if (pn.getType() != 126) {
                    pn = this.nf.createExprStatement(pn, lineno, charno);
                    break;
                }
                if (this.peekToken() != 99) {
                    Kit.codeBug();
                }
                this.consumeToken();
                this.decompiler.addName(name);
                this.decompiler.addEOL(99);
                if (this.labelSet == null) {
                    this.labelSet = new Hashtable();
                } else if (this.labelSet.containsKey(name)) {
                    this.reportError("msg.dup.label");
                }
                this.labelSet.put(name, pn);
                pn = this.nf.createLabel(name, lineno, charno);
                try {
                    this.nf.addChildToBack(pn, this.statementHelper(pn));
                }
                finally {
                    this.labelSet.remove(name);
                }
                return pn;
            }
            default: {
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                pn = this.expr(false);
                pn = this.nf.createExprStatement(pn, lineno, charno);
                break;
            }
        }
        int ttFlagged = this.peekFlaggedToken();
        switch (ttFlagged & 0xFFFF) {
            case 78: {
                this.consumeToken();
                break;
            }
            case -1: 
            case 0: 
            case 82: {
                break;
            }
            default: {
                if ((ttFlagged & 0x10000) != 0) break;
                this.reportError("msg.no.semi.stmt");
            }
        }
        this.decompiler.addEOL(78);
        return pn;
    }

    private Node variables(int context) throws IOException, ParserException {
        Node pn;
        boolean first = true;
        JSDocInfo varInfo = null;
        if (context == 149) {
            pn = this.nf.createVariables(149, this.ts.getLineno(), this.ts.getCharno());
            this.decompiler.addToken(149);
        } else {
            pn = this.nf.createVariables(118, this.ts.getLineno(), this.ts.getCharno());
            varInfo = this.ts.getAndResetJSDocInfo();
            if (varInfo != null) {
                pn.setJSDocInfo(varInfo);
            }
            this.decompiler.addToken(118);
        }
        do {
            this.mustMatchToken(38, "msg.bad.var");
            String s = this.ts.getString();
            int lineno = this.ts.getLineno();
            int charno = this.ts.getCharno();
            JSDocInfo info = this.ts.getAndResetJSDocInfo();
            if (!first) {
                this.decompiler.addToken(85);
            }
            first = false;
            this.decompiler.addName(s);
            if (context == 149) {
                if (!this.currentScriptOrFn.addConst(s)) {
                    if (this.currentScriptOrFn.addVar(s) != -2) {
                        this.addError("msg.var.redecl", s);
                    } else {
                        this.addError("msg.const.redecl", s);
                    }
                }
            } else {
                int dupState = this.currentScriptOrFn.addVar(s);
                if (dupState == -2) {
                    this.addError("msg.const.redecl", s);
                } else if (dupState == -1) {
                    this.addStrictWarning("msg.var.hides.arg", s);
                } else if (dupState == 0) {
                    this.addStrictWarning("msg.var.redecl", s);
                }
            }
            Node name = this.nf.createTaggedName(s, info, lineno, charno);
            if (this.matchToken(86)) {
                this.decompiler.addToken(86);
                Node init = this.assignExpr(context == 115);
                this.nf.addChildToBack(name, init);
            }
            this.nf.addChildToBack(pn, name);
        } while (this.matchToken(85));
        return pn;
    }

    private Node expr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.assignExpr(inForInit);
        int lineno = this.ts.getLineno();
        int charno = this.ts.getCharno();
        while (this.matchToken(85)) {
            this.decompiler.addToken(85);
            if (this.compilerEnv.isStrictMode() && !pn.hasSideEffects()) {
                this.addStrictWarning("msg.no.side.effects", "");
            }
            pn = this.nf.createBinary(85, pn, this.assignExpr(inForInit), lineno, charno);
        }
        return pn;
    }

    private Node assignExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.condExpr(inForInit);
        int tt = this.peekToken();
        int lineno = this.ts.getLineno();
        int charno = this.ts.getCharno();
        if (86 <= tt && tt <= 97) {
            this.consumeToken();
            JSDocInfo info = this.ts.getAndResetJSDocInfo();
            this.decompiler.addToken(tt);
            Node right = this.assignExpr(inForInit);
            pn = this.nf.createBinary(tt, pn, right, lineno, charno);
            if (info != null) {
                pn.setJSDocInfo(info);
            }
        } else if (tt == 78 && pn.getType() == 33 && this.ts.isPopulated()) {
            pn.setJSDocInfo(this.ts.getAndResetJSDocInfo());
        }
        return pn;
    }

    private Node condExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.orExpr(inForInit);
        if (this.matchToken(98)) {
            int lineno = this.ts.getLineno();
            int charno = this.ts.getCharno();
            this.decompiler.addToken(98);
            Node ifTrue = this.assignExpr(false);
            this.mustMatchToken(99, "msg.no.colon.cond");
            this.decompiler.addToken(99);
            Node ifFalse = this.assignExpr(inForInit);
            return this.nf.createCondExpr(pn, ifTrue, ifFalse, lineno, charno);
        }
        return pn;
    }

    private Node orExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.andExpr(inForInit);
        if (this.matchToken(100)) {
            int lineno = this.ts.getLineno();
            int charno = this.ts.getCharno();
            this.decompiler.addToken(100);
            pn = this.nf.createBinary(100, pn, this.orExpr(inForInit), lineno, charno);
        }
        return pn;
    }

    private Node andExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.bitOrExpr(inForInit);
        if (this.matchToken(101)) {
            int lineno = this.ts.getLineno();
            int charno = this.ts.getCharno();
            this.decompiler.addToken(101);
            pn = this.nf.createBinary(101, pn, this.andExpr(inForInit), lineno, charno);
        }
        return pn;
    }

    private Node bitOrExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.bitXorExpr(inForInit);
        while (this.matchToken(9)) {
            int lineno = this.ts.getLineno();
            int charno = this.ts.getCharno();
            this.decompiler.addToken(9);
            pn = this.nf.createBinary(9, pn, this.bitXorExpr(inForInit), lineno, charno);
        }
        return pn;
    }

    private Node bitXorExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.bitAndExpr(inForInit);
        while (this.matchToken(10)) {
            int lineno = this.ts.getLineno();
            int charno = this.ts.getCharno();
            this.decompiler.addToken(10);
            pn = this.nf.createBinary(10, pn, this.bitAndExpr(inForInit), lineno, charno);
        }
        return pn;
    }

    private Node bitAndExpr(boolean inForInit) throws IOException, JavaScriptException {
        Node pn = this.eqExpr(inForInit);
        while (this.matchToken(11)) {
            int lineno = this.ts.getLineno();
            int charno = this.ts.getCharno();
            this.decompiler.addToken(11);
            pn = this.nf.createBinary(11, pn, this.eqExpr(inForInit), lineno, charno);
        }
        return pn;
    }

    private Node eqExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.relExpr(inForInit);
        block9: while (true) {
            int tt = this.peekToken();
            int lineno = this.ts.getLineno();
            int charno = this.ts.getCharno();
            switch (tt) {
                case 12: 
                case 13: 
                case 45: 
                case 46: {
                    this.consumeToken();
                    int decompilerToken = tt;
                    int parseToken = tt;
                    if (this.compilerEnv.getLanguageVersion() == 120) {
                        switch (tt) {
                            case 12: {
                                parseToken = 45;
                                break;
                            }
                            case 13: {
                                parseToken = 46;
                                break;
                            }
                            case 45: {
                                decompilerToken = 12;
                                break;
                            }
                            case 46: {
                                decompilerToken = 13;
                            }
                        }
                    }
                    this.decompiler.addToken(decompilerToken);
                    pn = this.nf.createBinary(parseToken, pn, this.relExpr(inForInit), lineno, charno);
                    continue block9;
                }
            }
            break;
        }
        return pn;
    }

    private Node relExpr(boolean inForInit) throws IOException, ParserException {
        Node pn = this.shiftExpr();
        block4: while (true) {
            int tt = this.peekToken();
            int lineno = this.ts.getLineno();
            int charno = this.ts.getCharno();
            switch (tt) {
                case 51: {
                    if (inForInit) break block4;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 52: {
                    this.consumeToken();
                    this.decompiler.addToken(tt);
                    pn = this.nf.createBinary(tt, pn, this.shiftExpr(), lineno, charno);
                    continue block4;
                }
            }
            break;
        }
        return pn;
    }

    private Node shiftExpr() throws IOException, ParserException {
        Node pn = this.addExpr();
        block3: while (true) {
            int tt = this.peekToken();
            int lineno = this.ts.getLineno();
            int charno = this.ts.getCharno();
            switch (tt) {
                case 18: 
                case 19: 
                case 20: {
                    this.consumeToken();
                    this.decompiler.addToken(tt);
                    pn = this.nf.createBinary(tt, pn, this.addExpr(), lineno, charno);
                    continue block3;
                }
            }
            break;
        }
        return pn;
    }

    private Node addExpr() throws IOException, ParserException {
        Node pn = this.mulExpr();
        while (true) {
            int tt = this.peekToken();
            int lineno = this.ts.getLineno();
            int charno = this.ts.getCharno();
            if (tt != 21 && tt != 22) break;
            this.consumeToken();
            this.decompiler.addToken(tt);
            pn = this.nf.createBinary(tt, pn, this.mulExpr(), lineno, charno);
        }
        return pn;
    }

    private Node mulExpr() throws IOException, ParserException {
        Node pn = this.unaryExpr();
        block3: while (true) {
            int tt = this.peekToken();
            int lineno = this.ts.getLineno();
            int charno = this.ts.getCharno();
            switch (tt) {
                case 23: 
                case 24: 
                case 25: {
                    this.consumeToken();
                    this.decompiler.addToken(tt);
                    pn = this.nf.createBinary(tt, pn, this.unaryExpr(), lineno, charno);
                    continue block3;
                }
            }
            break;
        }
        return pn;
    }

    private Node unaryExpr() throws IOException, ParserException {
        int tt = this.peekToken();
        int lineno = this.ts.getLineno();
        int charno = this.ts.getCharno();
        switch (tt) {
            case 26: 
            case 27: 
            case 32: 
            case 122: {
                this.consumeToken();
                this.decompiler.addToken(tt);
                return this.nf.createUnary(tt, this.unaryExpr(), lineno, charno);
            }
            case 21: {
                this.consumeToken();
                this.decompiler.addToken(28);
                return this.nf.createUnary(28, this.unaryExpr(), lineno, charno);
            }
            case 22: {
                this.consumeToken();
                this.decompiler.addToken(29);
                return this.nf.createUnary(29, this.unaryExpr(), lineno, charno);
            }
            case 102: 
            case 103: {
                this.consumeToken();
                this.decompiler.addToken(tt);
                return this.nf.createIncDec(tt, false, this.memberExpr(true), lineno, charno);
            }
            case 31: {
                this.consumeToken();
                this.decompiler.addToken(31);
                return this.nf.createUnary(31, this.unaryExpr(), lineno, charno);
            }
            case -1: {
                this.consumeToken();
                break;
            }
            case 14: {
                if (this.compilerEnv.isXmlAvailable()) {
                    this.consumeToken();
                    Node pn = this.xmlInitializer();
                    return this.memberExprTail(true, pn);
                }
            }
            default: {
                Node pn = this.memberExpr(true);
                tt = this.peekTokenOrEOL();
                if (tt == 102 || tt == 103) {
                    this.consumeToken();
                    this.decompiler.addToken(tt);
                    return this.nf.createIncDec(tt, true, pn, lineno, charno);
                }
                return pn;
            }
        }
        return this.nf.createErrorName();
    }

    private Node xmlInitializer() throws IOException {
        int tt = this.ts.getFirstXMLToken();
        int lineno = this.ts.getLineno();
        int charno = this.ts.getCharno();
        if (tt != 141 && tt != 144) {
            this.reportError("msg.syntax");
            return null;
        }
        Node pnXML = this.nf.createLeaf(30, lineno, charno);
        String xml = this.ts.getString();
        lineno = this.ts.getLineno();
        charno = this.ts.getCharno();
        boolean fAnonymous = xml.trim().startsWith("<>");
        Node pn = this.nf.createName(fAnonymous ? "XMLList" : "XML", lineno, charno);
        this.nf.addChildToBack(pnXML, pn);
        pn = null;
        while (true) {
            switch (tt) {
                case 141: {
                    xml = this.ts.getString();
                    lineno = this.ts.getLineno();
                    charno = this.ts.getCharno();
                    this.decompiler.addName(xml);
                    this.mustMatchToken(81, "msg.syntax");
                    this.decompiler.addToken(81);
                    Node expr = this.peekToken() == 82 ? this.nf.createString("", lineno, charno) : this.expr(false);
                    this.mustMatchToken(82, "msg.syntax");
                    this.decompiler.addToken(82);
                    pn = pn == null ? this.nf.createString(xml, lineno, charno) : this.nf.createBinary(21, pn, this.nf.createString(xml, lineno, charno), lineno, charno);
                    int nodeType = this.ts.isXMLAttribute() ? 71 : 72;
                    expr = this.nf.createUnary(nodeType, expr, lineno, charno);
                    pn = this.nf.createBinary(21, pn, expr, lineno, charno);
                    break;
                }
                case 144: {
                    xml = this.ts.getString();
                    lineno = this.ts.getLineno();
                    charno = this.ts.getCharno();
                    this.decompiler.addName(xml);
                    pn = pn == null ? this.nf.createString(xml, lineno, charno) : this.nf.createBinary(21, pn, this.nf.createString(xml, lineno, charno), lineno, charno);
                    this.nf.addChildToBack(pnXML, pn);
                    return pnXML;
                }
                default: {
                    this.reportError("msg.syntax");
                    return null;
                }
            }
            tt = this.ts.getNextXMLToken();
        }
    }

    private void argumentList(Node listNode) throws IOException, ParserException {
        boolean matched = this.matchToken(84);
        if (!matched) {
            boolean first = true;
            do {
                if (!first) {
                    this.decompiler.addToken(85);
                }
                first = false;
                this.nf.addChildToBack(listNode, this.assignExpr(false));
            } while (this.matchToken(85));
            this.mustMatchToken(84, "msg.no.paren.arg");
        }
        this.decompiler.addToken(84);
    }

    private Node memberExpr(boolean allowCallSyntax) throws IOException, ParserException {
        Node pn;
        int tt = this.peekToken();
        int lineno = this.ts.getLineno();
        int charno = this.ts.getCharno();
        if (tt == 30) {
            this.consumeToken();
            this.decompiler.addToken(30);
            pn = this.nf.createLeaf(30, lineno, charno);
            this.nf.addChildToBack(pn, this.memberExpr(false));
            if (this.matchToken(83)) {
                this.decompiler.addToken(83);
                this.argumentList(pn);
            }
            if ((tt = this.peekToken()) == 81) {
                this.nf.addChildToBack(pn, this.primaryExpr());
            }
        } else {
            pn = this.primaryExpr();
        }
        return this.memberExprTail(allowCallSyntax, pn);
    }

    private Node memberExprTail(boolean allowCallSyntax, Node pn) throws IOException, ParserException {
        block11: while (true) {
            int tt = this.peekToken();
            int lineno = this.ts.getLineno();
            int charno = this.ts.getCharno();
            block0 : switch (tt) {
                case 104: 
                case 139: {
                    String s;
                    this.consumeToken();
                    this.decompiler.addToken(tt);
                    int memberTypeFlags = 0;
                    if (tt == 139) {
                        this.mustHaveXML();
                        memberTypeFlags = 4;
                    }
                    if (!this.compilerEnv.isXmlAvailable()) {
                        this.mustMatchToken(38, "msg.no.name.after.dot");
                        s = this.ts.getString();
                        this.decompiler.addName(s);
                        pn = this.nf.createPropertyGet(pn, null, s, memberTypeFlags, lineno, charno, this.ts.getLineno(), this.ts.getCharno());
                        break;
                    }
                    tt = this.nextToken();
                    switch (tt) {
                        case 38: {
                            s = this.ts.getString();
                            this.decompiler.addName(s);
                            pn = this.propertyName(pn, s, memberTypeFlags, lineno, charno, this.ts.getLineno(), this.ts.getCharno());
                            break block0;
                        }
                        case 23: {
                            this.decompiler.addName("*");
                            pn = this.propertyName(pn, "*", memberTypeFlags, this.ts.getLineno(), this.ts.getCharno());
                            break block0;
                        }
                        case 143: {
                            this.decompiler.addToken(143);
                            pn = this.attributeAccess(pn, memberTypeFlags);
                            break block0;
                        }
                    }
                    this.reportError("msg.no.name.after.dot");
                    break;
                }
                case 142: {
                    this.consumeToken();
                    this.mustHaveXML();
                    this.decompiler.addToken(142);
                    pn = this.nf.createDotQuery(pn, this.expr(false), this.ts.getLineno(), this.ts.getCharno());
                    this.mustMatchToken(84, "msg.no.paren");
                    this.decompiler.addToken(84);
                    break;
                }
                case 79: {
                    this.consumeToken();
                    this.decompiler.addToken(79);
                    pn = this.nf.createElementGet(pn, null, this.expr(false), 0, lineno, charno);
                    this.mustMatchToken(80, "msg.no.bracket.index");
                    this.decompiler.addToken(80);
                    break;
                }
                case 83: {
                    if (!allowCallSyntax) break block11;
                    this.consumeToken();
                    this.decompiler.addToken(83);
                    pn = this.nf.createCallOrNew(37, pn, this.ts.getLineno(), this.ts.getCharno());
                    this.argumentList(pn);
                    break;
                }
                default: {
                    break block11;
                }
            }
        }
        return pn;
    }

    private Node attributeAccess(Node pn, int memberTypeFlags) throws IOException {
        memberTypeFlags |= 2;
        int tt = this.nextToken();
        switch (tt) {
            case 38: {
                String s = this.ts.getString();
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                this.decompiler.addName(s);
                pn = this.propertyName(pn, s, memberTypeFlags, lineno, charno);
                break;
            }
            case 23: {
                this.decompiler.addName("*");
                pn = this.propertyName(pn, "*", memberTypeFlags, this.ts.getLineno(), this.ts.getCharno());
                break;
            }
            case 79: {
                this.decompiler.addToken(79);
                pn = this.nf.createElementGet(pn, null, this.expr(false), memberTypeFlags, this.ts.getLineno(), this.ts.getCharno());
                this.mustMatchToken(80, "msg.no.bracket.index");
                this.decompiler.addToken(80);
                break;
            }
            default: {
                this.reportError("msg.no.name.after.xmlAttr");
                pn = this.nf.createPropertyGet(pn, null, "?", memberTypeFlags, this.ts.getLineno(), this.ts.getCharno(), this.ts.getLineno(), this.ts.getCharno());
            }
        }
        return pn;
    }

    private Node propertyName(Node pn, String name, int memberTypeFlags, int dotLineno, int dotCharno, int nameLineno, int nameCharno) throws IOException, ParserException {
        String namespace = null;
        if (this.matchToken(140)) {
            this.decompiler.addToken(140);
            namespace = name;
            int tt = this.nextToken();
            switch (tt) {
                case 38: {
                    name = this.ts.getString();
                    this.decompiler.addName(name);
                    break;
                }
                case 23: {
                    this.decompiler.addName("*");
                    name = "*";
                    break;
                }
                case 79: {
                    this.decompiler.addToken(79);
                    pn = this.nf.createElementGet(pn, namespace, this.expr(false), memberTypeFlags, nameLineno, nameCharno);
                    this.mustMatchToken(80, "msg.no.bracket.index");
                    this.decompiler.addToken(80);
                    return pn;
                }
                default: {
                    this.reportError("msg.no.name.after.coloncolon");
                    name = "?";
                }
            }
        }
        pn = this.nf.createPropertyGet(pn, namespace, name, memberTypeFlags, dotLineno, dotCharno, nameLineno, nameCharno);
        return pn;
    }

    private Node propertyName(Node pn, String name, int memberTypeFlags, int lineno, int charno) throws IOException, ParserException {
        return this.propertyName(pn, name, memberTypeFlags, lineno, charno, lineno, charno);
    }

    private Node primaryExpr() throws IOException, ParserException {
        int ttFlagged = this.nextFlaggedToken();
        int tt = ttFlagged & 0xFFFF;
        switch (tt) {
            case 105: {
                return this.function(2);
            }
            case 79: {
                ObjArray elems = new ObjArray();
                int skipCount = 0;
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                this.decompiler.addToken(79);
                boolean after_lb_or_comma = true;
                while (true) {
                    if ((tt = this.peekToken()) == 85) {
                        this.consumeToken();
                        this.decompiler.addToken(85);
                        if (!after_lb_or_comma) {
                            after_lb_or_comma = true;
                            continue;
                        }
                        elems.add(null);
                        ++skipCount;
                        continue;
                    }
                    if (tt == 80) {
                        if (after_lb_or_comma && elems.size() > 0) {
                            this.addWarning("msg.trailing.comma");
                        }
                        break;
                    }
                    if (!after_lb_or_comma) {
                        this.reportError("msg.no.bracket.arg");
                    }
                    elems.add(this.assignExpr(false));
                    after_lb_or_comma = false;
                }
                this.consumeToken();
                this.decompiler.addToken(80);
                return this.nf.createArrayLiteral(elems, skipCount, lineno, charno);
            }
            case 81: {
                ObjArray elems = new ObjArray();
                this.decompiler.addToken(81);
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                if (!this.matchToken(82)) {
                    boolean first = true;
                    block22: do {
                        if (!first) {
                            this.decompiler.addToken(85);
                        } else {
                            first = false;
                        }
                        tt = this.peekToken();
                        switch (tt) {
                            case 38: 
                            case 40: {
                                Node property;
                                this.consumeToken();
                                String s = this.ts.getString();
                                int linenoName = this.ts.getLineno();
                                int charnoName = this.ts.getCharno();
                                if (tt == 38) {
                                    if (s.equals("get") && this.peekToken() == 38) {
                                        this.decompiler.addToken(147);
                                        this.consumeToken();
                                        s = this.ts.getString();
                                        this.decompiler.addName(s);
                                        if (this.getterSetterProperty(elems, s, true, linenoName, charnoName)) continue block22;
                                        break block22;
                                    }
                                    if (s.equals("set") && this.peekToken() == 38) {
                                        this.decompiler.addToken(148);
                                        this.consumeToken();
                                        s = this.ts.getString();
                                        this.decompiler.addName(s);
                                        if (this.getterSetterProperty(elems, s, false, linenoName, charnoName)) continue block22;
                                        break block22;
                                    }
                                    this.decompiler.addName(s);
                                    property = this.nf.createString(s, linenoName, charnoName);
                                } else {
                                    this.decompiler.addString(s);
                                    property = this.nf.createString(s, linenoName, charnoName);
                                    property.setQuotedString();
                                }
                                this.plainProperty(elems, property);
                                break;
                            }
                            case 39: {
                                this.consumeToken();
                                double n = this.ts.getNumber();
                                int linenoNumber = this.ts.getLineno();
                                int charnoNumber = this.ts.getCharno();
                                this.decompiler.addNumber(n);
                                Node property = this.nf.createNumber(n, linenoNumber, charnoNumber);
                                this.plainProperty(elems, property);
                                break;
                            }
                            case 85: {
                                this.consumeToken();
                            }
                            case 82: {
                                this.addWarning("msg.trailing.comma");
                                break block22;
                            }
                            default: {
                                this.reportError("msg.bad.prop");
                                break block22;
                            }
                        }
                    } while (this.matchToken(85));
                    this.mustMatchToken(82, "msg.no.brace.prop");
                }
                this.decompiler.addToken(82);
                return this.nf.createObjectLiteral(elems, lineno, charno);
            }
            case 83: {
                JSDocInfo info = this.ts.getAndResetJSDocInfo();
                this.decompiler.addToken(83);
                Node pn = this.expr(false);
                pn.putProp(35, Boolean.TRUE);
                this.decompiler.addToken(84);
                if (info == null) {
                    info = this.ts.getAndResetJSDocInfo();
                }
                if (info != null && info.hasType()) {
                    pn.setJSDocInfo(info);
                }
                this.mustMatchToken(84, "msg.no.paren");
                return pn;
            }
            case 143: {
                this.mustHaveXML();
                this.decompiler.addToken(143);
                Node pn = this.attributeAccess(null, 0);
                return pn;
            }
            case 38: {
                String name = this.ts.getString();
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                if ((ttFlagged & 0x20000) != 0 && this.peekToken() == 99) {
                    return this.nf.createLabel(name, lineno, charno);
                }
                this.decompiler.addName(name);
                Node pn = this.compilerEnv.isXmlAvailable() ? this.propertyName(null, name, 0, lineno, charno) : this.nf.createName(name, lineno, charno);
                return pn;
            }
            case 39: {
                double n = this.ts.getNumber();
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                this.decompiler.addNumber(n);
                return this.nf.createNumber(n, lineno, charno);
            }
            case 40: {
                String s = this.ts.getString();
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                this.decompiler.addString(s);
                return this.nf.createString(s, lineno, charno);
            }
            case 24: 
            case 96: {
                this.ts.readRegExp(tt);
                String flags = this.ts.regExpFlags;
                this.ts.regExpFlags = null;
                String re = this.ts.getString();
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                this.decompiler.addRegexp(re, flags);
                return this.nf.createRegExp(re, flags, lineno, charno);
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                int lineno = this.ts.getLineno();
                int charno = this.ts.getCharno();
                this.decompiler.addToken(tt);
                return this.nf.createLeaf(tt, lineno, charno);
            }
            case 123: {
                this.reportError("msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                this.reportError("msg.unexpected.eof");
                break;
            }
            default: {
                this.reportError("msg.syntax");
            }
        }
        return null;
    }

    String getSourceName() {
        return this.sourceURI;
    }

    private void plainProperty(ObjArray elems, Object property) throws IOException {
        this.mustMatchToken(99, "msg.no.colon.prop");
        this.decompiler.addToken(64);
        elems.add(property);
        elems.add(this.assignExpr(false));
    }

    private boolean getterSetterProperty(ObjArray elems, String property, boolean isGetter, int lineno, int charno) throws IOException {
        Node f = this.function(2);
        if (f.getType() != 105) {
            this.reportError("msg.bad.prop");
            return false;
        }
        int fnIndex = f.getExistingIntProp(5);
        FunctionNode fn = this.currentScriptOrFn.getFunctionNode(fnIndex);
        if (fn.getFunctionName().length() != 0) {
            this.reportError("msg.bad.prop");
            return false;
        }
        elems.add(this.nf.createName(property, lineno, charno));
        if (isGetter) {
            elems.add(this.nf.createUnary(147, f, lineno, charno));
        } else {
            elems.add(this.nf.createUnary(148, f, lineno, charno));
        }
        return true;
    }

    private static class ParserException
    extends RuntimeException {
        static final long serialVersionUID = 5882582646773765630L;

        private ParserException() {
        }
    }
}

