/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.graph.UnionFind;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class StandardUnionFind<E>
implements Serializable,
UnionFind<E> {
    private static final long serialVersionUID = -1L;
    private final Map<E, Node<E>> elmap = Maps.newLinkedHashMap();

    public StandardUnionFind() {
    }

    public StandardUnionFind(UnionFind<E> other) {
        for (E elem : other.elements()) {
            this.union(elem, other.find(elem));
        }
    }

    @Override
    public void add(E e) {
        this.union(e, e);
    }

    @Override
    public E union(E a, E b) {
        Node<E> nodeB;
        Node<E> nodeA = this.findRootOrCreateNode(a);
        if (nodeA == (nodeB = this.findRootOrCreateNode(b))) {
            return nodeA.element;
        }
        if (nodeA.rank > nodeB.rank) {
            nodeB.parent = nodeA;
            nodeA.size += nodeB.size;
            return nodeA.element;
        }
        nodeA.parent = nodeB;
        if (nodeA.rank == nodeB.rank) {
            ++nodeB.rank;
        }
        nodeB.size += nodeA.size;
        return nodeB.element;
    }

    @Override
    public E find(E e) {
        Preconditions.checkArgument((boolean)this.elmap.containsKey(e), (String)"Element does not exist: %s", (Object[])new Object[]{e});
        return this.findRoot(this.elmap.get(e)).element;
    }

    @Override
    public boolean areEquivalent(E a, E b) {
        E bRep;
        E aRep = this.find(a);
        return aRep == (bRep = this.find(b));
    }

    @Override
    public Set<E> elements() {
        return Collections.unmodifiableSet(this.elmap.keySet());
    }

    @Override
    public Collection<Set<E>> allEquivalenceClasses() {
        HashMap groupsTmp = Maps.newHashMap();
        for (Node<E> elem : this.elmap.values()) {
            Node<E> root = this.findRoot(elem);
            ImmutableSet.Builder builder = (ImmutableSet.Builder)groupsTmp.get(root);
            if (builder == null) {
                builder = ImmutableSet.builder();
                groupsTmp.put(root, builder);
            }
            builder.add(elem.element);
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (ImmutableSet.Builder group : groupsTmp.values()) {
            result.add((Object)group.build());
        }
        return result.build();
    }

    private Node<E> findRootOrCreateNode(E e) {
        Node<E> node = this.elmap.get(e);
        if (node != null) {
            return this.findRoot(node);
        }
        node = new Node<E>(e);
        this.elmap.put(e, node);
        return node;
    }

    private Node<E> findRoot(Node<E> node) {
        if (node.parent != node) {
            node.parent = this.findRoot(node.parent);
        }
        return node.parent;
    }

    @Override
    public Set<E> findAll(final E value) {
        Preconditions.checkArgument((boolean)this.elmap.containsKey(value), (Object)("Element does not exist: " + value));
        Predicate<Object> isSameRoot = new Predicate<Object>(){
            Node<E> nodeForValue;
            {
                this.nodeForValue = (Node)StandardUnionFind.this.elmap.get(value);
            }

            public boolean apply(@Nullable Object b) {
                if (Objects.equal((Object)value, (Object)b)) {
                    return true;
                }
                Node nodeForB = (Node)StandardUnionFind.this.elmap.get(b);
                if (nodeForB == null) {
                    return false;
                }
                this.nodeForValue = StandardUnionFind.this.findRoot(this.nodeForValue);
                return StandardUnionFind.this.findRoot(nodeForB) == this.nodeForValue;
            }
        };
        return new AbstractSet<E>((Predicate)isSameRoot, value){
            final /* synthetic */ Predicate val$isSameRoot;
            final /* synthetic */ Object val$value;
            {
                this.val$isSameRoot = predicate;
                this.val$value = object;
            }

            @Override
            public boolean contains(Object o) {
                return this.val$isSameRoot.apply(o);
            }

            @Override
            public Iterator<E> iterator() {
                return Iterators.unmodifiableIterator((Iterator)Iterators.filter(StandardUnionFind.this.elmap.keySet().iterator(), (Predicate)this.val$isSameRoot));
            }

            @Override
            public int size() {
                return ((StandardUnionFind)StandardUnionFind.this).findRoot((Node)((Node)((StandardUnionFind)StandardUnionFind.this).elmap.get((Object)this.val$value))).size;
            }
        };
    }

    private static class Node<E> {
        Node<E> parent = this;
        final E element;
        int rank = 0;
        int size = 1;

        Node(E element) {
            this.element = element;
        }
    }
}

