/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.rhino.Node;
import java.util.Set;

class VarCheck
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final String SYNTHETIC_VARS_DECLAR = "{SyntheticVarsDeclar}";
    static final DiagnosticType UNDEFINED_VAR_ERROR = DiagnosticType.error("JSC_UNDEFINED_VARIABLE", "variable {0} is undeclared");
    static final DiagnosticType VIOLATED_MODULE_DEP_ERROR = DiagnosticType.error("JSC_VIOLATED_MODULE_DEPENDENCY", "module {0} cannot reference {2}, defined in module {1}, since {1} loads after {0}");
    static final DiagnosticType MISSING_MODULE_DEP_ERROR = DiagnosticType.warning("JSC_MISSING_MODULE_DEPENDENCY", "missing module dependency; module {0} should depend on module {1} because it references {2}");
    static final DiagnosticType STRICT_MODULE_DEP_ERROR = DiagnosticType.disabled("JSC_STRICT_MODULE_DEPENDENCY", "module {0} cannot reference {2}, defined in module {1}");
    static final DiagnosticType NAME_REFERENCE_IN_EXTERNS_ERROR = DiagnosticType.warning("JSC_NAME_REFERENCE_IN_EXTERNS", "accessing name {0} in externs has no effect");
    static final DiagnosticType UNDEFINED_EXTERN_VAR_ERROR = DiagnosticType.warning("JSC_UNDEFINED_EXTERN_VAR_ERROR", "name {0} is not undefined in the externs.");
    static final DiagnosticType INVALID_FUNCTION_DECL = DiagnosticType.error("JSC_INVALID_FUNCTION_DECL", "Syntax error: function declaration must have a name");
    private CompilerInput synthesizedExternsInput = null;
    private Node synthesizedExternsRoot = null;
    private final Set<String> varsToDeclareInExterns = Sets.newHashSet();
    private final AbstractCompiler compiler;
    private final boolean sanityCheck;
    private final boolean strictExternCheck;

    VarCheck(AbstractCompiler compiler) {
        this(compiler, false);
    }

    VarCheck(AbstractCompiler compiler, boolean sanityCheck) {
        this.compiler = compiler;
        this.strictExternCheck = compiler.getErrorLevel(JSError.make("", 0, 0, UNDEFINED_EXTERN_VAR_ERROR, new String[0])) == CheckLevel.ERROR;
        this.sanityCheck = sanityCheck;
    }

    @Override
    public void process(Node externs, Node root) {
        if (!this.sanityCheck) {
            NodeTraversal.traverse(this.compiler, externs, new NameRefInExternsCheck());
        }
        NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList((Object[])new Node[]{externs, root}), this);
        for (String varName : this.varsToDeclareInExterns) {
            this.createSynthesizedExternVar(varName);
        }
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        Preconditions.checkState((scriptRoot.getType() == 132 ? 1 : 0) != 0);
        NodeTraversal t = new NodeTraversal(this.compiler, this);
        t.traverseWithScope(scriptRoot, SyntacticScopeCreator.generateUntypedTopScope(this.compiler));
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        CompilerInput varInput;
        Scope scope;
        Scope.Var var;
        if (n.getType() != 38) {
            return;
        }
        String varName = n.getString();
        if (varName.isEmpty()) {
            Preconditions.checkState((boolean)NodeUtil.isFunction(parent));
            if (!NodeUtil.isFunctionExpression(parent)) {
                t.report(n, INVALID_FUNCTION_DECL, new String[0]);
            }
            return;
        }
        if ((parent.getType() == 118 || NodeUtil.isFunctionDeclaration(parent)) && this.varsToDeclareInExterns.contains(varName)) {
            this.createSynthesizedExternVar(varName);
            n.addSuppression("duplicate");
        }
        if ((var = (scope = t.getScope()).getVar(varName)) == null) {
            if (!NodeUtil.isFunctionExpression(parent)) {
                if (!this.strictExternCheck || !t.getInput().isExtern()) {
                    t.report(n, UNDEFINED_VAR_ERROR, varName);
                }
                if (this.sanityCheck) {
                    throw new IllegalStateException("Unexpected variable " + varName);
                }
                this.createSynthesizedExternVar(varName);
                scope.getGlobalScope().declare(varName, n, null, this.getSynthesizedExternsInput());
            }
            return;
        }
        CompilerInput currInput = t.getInput();
        if (currInput == (varInput = var.input) || currInput == null || varInput == null) {
            return;
        }
        JSModule currModule = currInput.getModule();
        JSModule varModule = varInput.getModule();
        JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
        if (varModule != currModule && varModule != null && currModule != null && !moduleGraph.dependsOn(currModule, varModule)) {
            if (!this.sanityCheck && scope.isGlobal()) {
                if (moduleGraph.dependsOn(varModule, currModule)) {
                    t.report(n, VIOLATED_MODULE_DEP_ERROR, currModule.getName(), varModule.getName(), varName);
                } else {
                    t.report(n, MISSING_MODULE_DEP_ERROR, currModule.getName(), varModule.getName(), varName);
                }
            } else {
                t.report(n, STRICT_MODULE_DEP_ERROR, currModule.getName(), varModule.getName(), varName);
            }
        }
    }

    private void createSynthesizedExternVar(String varName) {
        Node nameNode = Node.newString(38, varName);
        if (this.compiler.getCodingConvention().isConstant(varName)) {
            nameNode.putBooleanProp(43, true);
        }
        this.getSynthesizedExternsRoot().addChildToBack(new Node(118, nameNode));
        this.varsToDeclareInExterns.remove(varName);
        this.compiler.reportCodeChange();
    }

    private CompilerInput getSynthesizedExternsInput() {
        if (this.synthesizedExternsInput == null) {
            this.synthesizedExternsInput = this.compiler.newExternInput(SYNTHETIC_VARS_DECLAR);
        }
        return this.synthesizedExternsInput;
    }

    private Node getSynthesizedExternsRoot() {
        if (this.synthesizedExternsRoot == null) {
            CompilerInput synthesizedExterns = this.getSynthesizedExternsInput();
            this.synthesizedExternsRoot = synthesizedExterns.getAstRoot(this.compiler);
        }
        return this.synthesizedExternsRoot;
    }

    private class NameRefInExternsCheck
    extends NodeTraversal.AbstractPostOrderCallback {
        private NameRefInExternsCheck() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.getType() == 38) {
                switch (parent.getType()) {
                    case 83: 
                    case 105: 
                    case 118: {
                        break;
                    }
                    case 33: {
                        Scope scope;
                        Scope.Var var;
                        if (n != parent.getFirstChild() || (var = (scope = t.getScope()).getVar(n.getString())) != null) break;
                        t.report(n, UNDEFINED_EXTERN_VAR_ERROR, n.getString());
                        VarCheck.this.varsToDeclareInExterns.add(n.getString());
                        break;
                    }
                    default: {
                        t.report(n, NAME_REFERENCE_IN_EXTERNS_ERROR, n.getString());
                        Scope scope = t.getScope();
                        Scope.Var var = scope.getVar(n.getString());
                        if (var != null) break;
                        VarCheck.this.varsToDeclareInExterns.add(n.getString());
                    }
                }
            }
        }
    }
}

