/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import javax.annotation.Nullable;

class Strings {
    private Strings() {
    }

    static boolean isEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    static String makeSafe(@Nullable String string) {
        return string == null ? "" : string;
    }

    static String repeat(String string, int count) {
        StringBuilder builder = new StringBuilder(string.length() * count);
        for (int i = 0; i < count; ++i) {
            builder.append(string);
        }
        return builder.toString();
    }

    static String truncateAtMaxLength(String source, int maxLength, boolean addEllipsis) {
        if (source.length() <= maxLength) {
            return source;
        }
        if (addEllipsis && maxLength > 3) {
            return Strings.unicodePreservingSubstring(source, 0, maxLength - 3) + "...";
        }
        return Strings.unicodePreservingSubstring(source, 0, maxLength);
    }

    private static int unicodePreservingIndex(String str, int index) {
        if (index > 0 && index < str.length() && Character.isHighSurrogate(str.charAt(index - 1)) && Character.isLowSurrogate(str.charAt(index))) {
            return index - 1;
        }
        return index;
    }

    private static String unicodePreservingSubstring(String str, int begin, int end) {
        return str.substring(Strings.unicodePreservingIndex(str, begin), Strings.unicodePreservingIndex(str, end));
    }
}

