/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.appengine.http;

import com.google.api.client.extensions.appengine.http.UrlFetchRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;

public final class UrlFetchTransport
extends HttpTransport {
    private static final String[] SUPPORTED_METHODS = new String[]{"DELETE", "GET", "HEAD", "POST", "PUT"};
    private final CertificateValidationBehavior certificateValidationBehavior;

    public UrlFetchTransport() {
        this(CertificateValidationBehavior.DEFAULT);
    }

    UrlFetchTransport(CertificateValidationBehavior certificateValidationBehavior) {
        this.certificateValidationBehavior = (CertificateValidationBehavior)((Object)Preconditions.checkNotNull((Object)((Object)certificateValidationBehavior)));
    }

    public boolean supportsMethod(String method) {
        return Arrays.binarySearch(SUPPORTED_METHODS, method) >= 0;
    }

    protected UrlFetchRequest buildRequest(String method, String url) throws IOException {
        Preconditions.checkArgument((boolean)this.supportsMethod(method), (String)"HTTP method %s not supported", (Object[])new Object[]{method});
        HTTPMethod httpMethod = method.equals("DELETE") ? HTTPMethod.DELETE : (method.equals("GET") ? HTTPMethod.GET : (method.equals("HEAD") ? HTTPMethod.HEAD : (method.equals("POST") ? HTTPMethod.POST : HTTPMethod.PUT)));
        FetchOptions fetchOptions = FetchOptions.Builder.doNotFollowRedirects().disallowTruncate().validateCertificate();
        switch (this.certificateValidationBehavior) {
            case VALIDATE: {
                fetchOptions.validateCertificate();
                break;
            }
            case DO_NOT_VALIDATE: {
                fetchOptions.doNotValidateCertificate();
                break;
            }
        }
        return new UrlFetchRequest(fetchOptions, httpMethod, url);
    }

    @Deprecated
    public boolean supportsHead() {
        return true;
    }

    @Deprecated
    public LowLevelHttpRequest buildDeleteRequest(String url) throws IOException {
        return this.buildRequest("DELETE", url);
    }

    @Deprecated
    public LowLevelHttpRequest buildGetRequest(String url) throws IOException {
        return this.buildRequest("GET", url);
    }

    @Deprecated
    public LowLevelHttpRequest buildHeadRequest(String url) throws IOException {
        return this.buildRequest("HEAD", url);
    }

    @Deprecated
    public LowLevelHttpRequest buildPostRequest(String url) throws IOException {
        return this.buildRequest("POST", url);
    }

    @Deprecated
    public LowLevelHttpRequest buildPutRequest(String url) throws IOException {
        return this.buildRequest("PUT", url);
    }

    static {
        Arrays.sort(SUPPORTED_METHODS);
    }

    public static final class Builder {
        private CertificateValidationBehavior certificateValidationBehavior = CertificateValidationBehavior.DEFAULT;

        public Builder doNotValidateCertificate() {
            this.certificateValidationBehavior = CertificateValidationBehavior.DO_NOT_VALIDATE;
            return this;
        }

        public Builder validateCertificate() {
            this.certificateValidationBehavior = CertificateValidationBehavior.VALIDATE;
            return this;
        }

        public boolean getValidateCertificate() {
            return this.certificateValidationBehavior == CertificateValidationBehavior.VALIDATE;
        }

        public boolean getDoNotValidateCertificate() {
            return this.certificateValidationBehavior == CertificateValidationBehavior.DO_NOT_VALIDATE;
        }

        public UrlFetchTransport build() {
            return new UrlFetchTransport(this.certificateValidationBehavior);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CertificateValidationBehavior {
        DEFAULT,
        VALIDATE,
        DO_NOT_VALIDATE;

    }
}

