/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache.v5;

import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StreamingContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;

final class Apache5ContentEntity
extends AbstractHttpEntity {
    private final long contentLength;
    private final StreamingContent streamingContent;

    Apache5ContentEntity(long contentLength, StreamingContent streamingContent, String contentType, String contentEncoding) {
        super(contentType, contentEncoding, contentLength == -1L);
        this.contentLength = contentLength;
        this.streamingContent = (StreamingContent)Preconditions.checkNotNull((Object)streamingContent);
    }

    public InputStream getContent() {
        throw new UnsupportedOperationException();
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isStreaming() {
        return true;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.contentLength != 0L) {
            this.streamingContent.writeTo(out);
        }
    }

    public void close() throws IOException {
    }
}

