/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache.v2;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpRequest;
import com.google.api.client.http.apache.v2.HttpExtensionMethod;
import java.io.IOException;
import java.net.ProxySelector;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;

public final class ApacheHttpTransport
extends HttpTransport {
    private final HttpClient httpClient;

    public ApacheHttpTransport() {
        this(ApacheHttpTransport.newDefaultHttpClient());
    }

    public ApacheHttpTransport(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static HttpClient newDefaultHttpClient() {
        SocketConfig socketConfig = SocketConfig.custom().setRcvBufSize(8192).setSndBufSize(8192).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(-1L, TimeUnit.MILLISECONDS);
        connectionManager.setValidateAfterInactivity(-1);
        return HttpClientBuilder.create().useSystemProperties().setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactory.getSocketFactory()).setDefaultSocketConfig(socketConfig).setMaxConnTotal(200).setMaxConnPerRoute(20).setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).setConnectionManager((HttpClientConnectionManager)connectionManager).disableRedirectHandling().disableAutomaticRetries().build();
    }

    public boolean supportsMethod(String method) {
        return true;
    }

    protected ApacheHttpRequest buildRequest(String method, String url) {
        Object requestBase = method.equals("DELETE") ? new HttpDelete(url) : (method.equals("GET") ? new HttpGet(url) : (method.equals("HEAD") ? new HttpHead(url) : (method.equals("PATCH") ? new HttpPatch(url) : (method.equals("POST") ? new HttpPost(url) : (method.equals("PUT") ? new HttpPut(url) : (method.equals("TRACE") ? new HttpTrace(url) : (method.equals("OPTIONS") ? new HttpOptions(url) : new HttpExtensionMethod(method, url))))))));
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)requestBase);
    }

    public void shutdown() throws IOException {
        if (this.httpClient instanceof CloseableHttpClient) {
            ((CloseableHttpClient)this.httpClient).close();
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

