/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ff" locale.
 */
public class LocalizedNamesImpl_ff extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "ZA",
        "AZ",
        "DZ",
        "AL",
        "DE",
        "AD",
        "AI",
        "AO",
        "AG",
        "AN",
        "AQ",
        "SA",
        "AR",
        "AM",
        "AW",
        "AX",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BR",
        "BM",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BG",
        "BF",
        "BN",
        "BI",
        "BT",
        "BV",
        "TD",
        "CC",
        "CL",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DM",
        "US",
        "VA",
        "FK",
        "CV",
        "KY",
        "VI",
        "VG",
        "CK",
        "MP",
        "MH",
        "NF",
        "SB",
        "TC",
        "EA",
        "ET",
        "EH",
        "EG",
        "EC",
        "SV",
        "AE",
        "IN",
        "ID",
        "ER",
        "ES",
        "EE",
        "EU",
        "FR",
        "FI",
        "FJ",
        "PH",
        "FO",
        "GA",
        "GM",
        "GH",
        "GD",
        "GR",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "GF",
        "GL",
        "GS",
        "GU",
        "GP",
        "GT",
        "HT",
        "HK",
        "HM",
        "IC",
        "IM",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JE",
        "GE",
        "GI",
        "DJ",
        "JO",
        "KH",
        "CM",
        "CA",
        "KZ",
        "QA",
        "IO",
        "KE",
        "KG",
        "KI",
        "CI",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "HR",
        "CR",
        "CU",
        "KW",
        "GB",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LU",
        "LI",
        "LT",
        "ML",
        "MG",
        "MW",
        "MV",
        "MY",
        "MT",
        "MQ",
        "MA",
        "YT",
        "ME",
        "MK",
        "MX",
        "MF",
        "FM",
        "MM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MS",
        "MU",
        "MZ",
        "MR",
        "NA",
        "NR",
        "CZ",
        "CD",
        "CF",
        "DO",
        "NL",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "NC",
        "NZ",
        "OM",
        "HN",
        "HU",
        "AU",
        "AT",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PR",
        "PT",
        "QO",
        "RE",
        "RU",
        "RS",
        "RO",
        "RW",
        "ZM",
        "WS",
        "AS",
        "JP",
        "ST",
        "SM",
        "PM",
        "VC",
        "SN",
        "SH",
        "KN",
        "LC",
        "SL",
        "SC",
        "CN",
        "CY",
        "ZW",
        "SG",
        "SY",
        "LK",
        "SJ",
        "SK",
        "SI",
        "SO",
        "SS",
        "SD",
        "SR",
        "SE",
        "CH",
        "SZ",
        "SX",
        "TA",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TF",
        "TL",
        "TT",
        "TG",
        "TK",
        "TO",
        "TN",
        "TR",
        "TM",
        "TV",
        "UA",
        "UM",
        "UG",
        "UY",
        "UZ",
        "WF",
        "VU",
        "VE",
        "VN",
        "XK",
        "YE",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Anndoora");
    namesMap.put("AE", "Emiraat Araab Denntuɗe");
    namesMap.put("AF", "Afganistaan");
    namesMap.put("AG", "Antiguwaa e Barbudaa");
    namesMap.put("AI", "Anngiyaa");
    namesMap.put("AL", "Albanii");
    namesMap.put("AM", "Armenii");
    namesMap.put("AN", "Antiiye Nederlanndeeje");
    namesMap.put("AO", "Anngolaa");
    namesMap.put("AR", "Arjantiin");
    namesMap.put("AS", "Samowa Amerik");
    namesMap.put("AT", "Otiriis");
    namesMap.put("AU", "Ostaraalii");
    namesMap.put("AW", "Aruuba");
    namesMap.put("AZ", "Ajerbayjaan");
    namesMap.put("BA", "Bosnii Hersegowiin");
    namesMap.put("BB", "Barbadoos");
    namesMap.put("BD", "Banglaadees");
    namesMap.put("BE", "Beljik");
    namesMap.put("BF", "Burkibaa Faaso");
    namesMap.put("BG", "Bulgarii");
    namesMap.put("BH", "Bahreyn");
    namesMap.put("BI", "Burunndi");
    namesMap.put("BJ", "Benee");
    namesMap.put("BM", "Bermudaa");
    namesMap.put("BN", "Burnaay");
    namesMap.put("BO", "Boliwii");
    namesMap.put("BR", "Beresiil");
    namesMap.put("BS", "Bahamaas");
    namesMap.put("BT", "Butaan");
    namesMap.put("BW", "Botswaana");
    namesMap.put("BY", "Belaruus");
    namesMap.put("BZ", "Beliise");
    namesMap.put("CA", "Kanadaa");
    namesMap.put("CD", "Ndenndaandi Demokaraasiire Konngo");
    namesMap.put("CF", "Ndenndaandi Santarafrik");
    namesMap.put("CG", "Konngo");
    namesMap.put("CH", "Suwiis");
    namesMap.put("CI", "Kodduwaar");
    namesMap.put("CK", "Duuɗe Kuuk");
    namesMap.put("CL", "Cilii");
    namesMap.put("CM", "Kameruun");
    namesMap.put("CN", "Siin");
    namesMap.put("CO", "Kolombiya");
    namesMap.put("CR", "Kosta Rikaa");
    namesMap.put("CU", "Kubaa");
    namesMap.put("CV", "Duuɗe Kap Weer");
    namesMap.put("CY", "Siipar");
    namesMap.put("CZ", "Ndenndaandi Cek");
    namesMap.put("DE", "Almaañ");
    namesMap.put("DJ", "Jibutii");
    namesMap.put("DK", "Danmark");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Ndenndanndi Dominika");
    namesMap.put("DZ", "Alaseri");
    namesMap.put("EC", "Ekuwatoor");
    namesMap.put("EE", "Estoni");
    namesMap.put("EG", "Ejipt");
    namesMap.put("ER", "Eriteree");
    namesMap.put("ES", "Espaañ");
    namesMap.put("ET", "Ecoppi");
    namesMap.put("FI", "Fenland");
    namesMap.put("FJ", "Fijji");
    namesMap.put("FK", "Duuɗe Falkland");
    namesMap.put("FM", "Mikoronesii");
    namesMap.put("FR", "Farayse");
    namesMap.put("GA", "Gaboo");
    namesMap.put("GB", "Laamateeri Rentundi");
    namesMap.put("GD", "Garnaad");
    namesMap.put("GE", "Jeorgii");
    namesMap.put("GF", "Giyaan Farayse");
    namesMap.put("GH", "Ganaa");
    namesMap.put("GI", "Jibraltaar");
    namesMap.put("GL", "Gorwendland");
    namesMap.put("GM", "Gammbi");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Gwaadalup");
    namesMap.put("GQ", "Ginee Ekuwaatoriyaal");
    namesMap.put("GR", "Gerees");
    namesMap.put("GT", "Gwaatemalaa");
    namesMap.put("GU", "Guwam");
    namesMap.put("GW", "Gine-Bisaawo");
    namesMap.put("GY", "Giyaan");
    namesMap.put("HN", "Onnduraas");
    namesMap.put("HR", "Korwasii");
    namesMap.put("HT", "Haytii");
    namesMap.put("HU", "Onngiri");
    namesMap.put("ID", "Enndonesii");
    namesMap.put("IE", "Irlannda");
    namesMap.put("IL", "Israa'iila");
    namesMap.put("IN", "Enndo");
    namesMap.put("IO", "Keeriindi britaani to maayo enndo");
    namesMap.put("IQ", "Iraak");
    namesMap.put("IR", "Iraan");
    namesMap.put("IS", "Islannda");
    namesMap.put("IT", "Itali");
    namesMap.put("JM", "Jamayka");
    namesMap.put("JO", "Jordani");
    namesMap.put("JP", "Sapoo");
    namesMap.put("KE", "Keñaa");
    namesMap.put("KG", "Kirgistaan");
    namesMap.put("KH", "Kambodso");
    namesMap.put("KI", "Kiribari");
    namesMap.put("KM", "Komoor");
    namesMap.put("KN", "Sent Kits e Newis");
    namesMap.put("KP", "Koree Rewo");
    namesMap.put("KR", "Koree Worgo");
    namesMap.put("KW", "Kuweyti");
    namesMap.put("KY", "Duuɗe Kaymaa");
    namesMap.put("KZ", "Kasakstaan");
    namesMap.put("LA", "Lawoos");
    namesMap.put("LB", "Libaa");
    namesMap.put("LC", "Sent Lusiyaa");
    namesMap.put("LI", "Lincenstayn");
    namesMap.put("LK", "Siri Lanka");
    namesMap.put("LR", "Liberiyaa");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lituaanii");
    namesMap.put("LU", "Liksembuur");
    namesMap.put("LV", "Letonii");
    namesMap.put("LY", "Libi");
    namesMap.put("MA", "Maruk");
    namesMap.put("MC", "Monaakoo");
    namesMap.put("MD", "Moldawii");
    namesMap.put("MG", "Madagaskaar");
    namesMap.put("MH", "Duuɗe Marsaal");
    namesMap.put("MK", "Meceduwaan");
    namesMap.put("ML", "Maali");
    namesMap.put("MM", "Miyamaar");
    namesMap.put("MN", "Monngolii");
    namesMap.put("MP", "Duuɗe Mariyaana Rewo");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Muritani");
    namesMap.put("MS", "Monseraat");
    namesMap.put("MT", "Malte");
    namesMap.put("MU", "Moriis");
    namesMap.put("MV", "Maldiiwe");
    namesMap.put("MW", "Malaawi");
    namesMap.put("MX", "Meksik");
    namesMap.put("MY", "Malesii");
    namesMap.put("MZ", "Mosammbik");
    namesMap.put("NA", "Namibii");
    namesMap.put("NC", "Nuwel Kaledonii");
    namesMap.put("NE", "Nijeer");
    namesMap.put("NF", "Duuɗe Norfolk");
    namesMap.put("NG", "Nijeriyaa");
    namesMap.put("NI", "Nikaraguwaa");
    namesMap.put("NL", "Nederlannda");
    namesMap.put("NO", "Norwees");
    namesMap.put("NP", "Nepaal");
    namesMap.put("NR", "Nawuru");
    namesMap.put("NU", "Niuwe");
    namesMap.put("NZ", "Nuwel Selannda");
    namesMap.put("OM", "Omaan");
    namesMap.put("PA", "Panamaa");
    namesMap.put("PF", "Polinesii Farayse");
    namesMap.put("PG", "Papuwaa Nuwel Gine");
    namesMap.put("PH", "Filipiin");
    namesMap.put("PK", "Pakistaan");
    namesMap.put("PL", "Poloñ");
    namesMap.put("PM", "See Piyeer e Mikeloo");
    namesMap.put("PN", "Pitkern");
    namesMap.put("PR", "Porto Rikoo");
    namesMap.put("PS", "Palestiin Sisjordani e Gaasaa");
    namesMap.put("PT", "Purtugaal");
    namesMap.put("PW", "Palawu");
    namesMap.put("PY", "Paraguwaay");
    namesMap.put("QA", "Kataar");
    namesMap.put("RE", "Rewiñoo");
    namesMap.put("RO", "Rumanii");
    namesMap.put("RU", "Riisii");
    namesMap.put("RW", "Ruwanndaa");
    namesMap.put("SA", "Arabii Sawdit");
    namesMap.put("SB", "Duuɗe Solomon");
    namesMap.put("SC", "Seysel");
    namesMap.put("SD", "Sudaan");
    namesMap.put("SE", "Suweed");
    namesMap.put("SG", "Sinngapuur");
    namesMap.put("SH", "Sent Helen");
    namesMap.put("SI", "Slowenii");
    namesMap.put("SK", "Slowakii");
    namesMap.put("SL", "Seraa liyon");
    namesMap.put("SM", "See Maree");
    namesMap.put("SN", "Senegaal");
    namesMap.put("SO", "Somalii");
    namesMap.put("SR", "Surinaam");
    namesMap.put("ST", "Sawo Tome e Perensipe");
    namesMap.put("SV", "El Salwador");
    namesMap.put("SY", "Sirii");
    namesMap.put("SZ", "Swaasilannda");
    namesMap.put("TC", "Duuɗe Turke e Keikoos");
    namesMap.put("TD", "Caad");
    namesMap.put("TG", "Togoo");
    namesMap.put("TH", "Taylannda");
    namesMap.put("TJ", "Tajikistaan");
    namesMap.put("TK", "Tokelaaw");
    namesMap.put("TL", "Timoor Fuɗnaange");
    namesMap.put("TM", "Turkmenistaan");
    namesMap.put("TN", "Tunisii");
    namesMap.put("TO", "Tonngaa");
    namesMap.put("TR", "Turkii");
    namesMap.put("TT", "Tirnidaad e Tobaago");
    namesMap.put("TV", "Tuwaluu");
    namesMap.put("TW", "Taywaan");
    namesMap.put("TZ", "Tansanii");
    namesMap.put("UA", "Ukereen");
    namesMap.put("UG", "Unganndaa");
    namesMap.put("US", "Dowlaaji Dentuɗi Amerik");
    namesMap.put("UY", "Uruguwaay");
    namesMap.put("UZ", "Usbekistaan");
    namesMap.put("VA", "Dowla Waticaan");
    namesMap.put("VC", "See Weesaa e Garnadiin");
    namesMap.put("VE", "Wenesuwelaa");
    namesMap.put("VG", "duuɗe kecce britanii");
    namesMap.put("VI", "Duuɗe Kecce Amerik");
    namesMap.put("VN", "Wiyetnaam");
    namesMap.put("VU", "Wanuwaatuu");
    namesMap.put("WF", "Walis e Futuna");
    namesMap.put("WS", "Samowaa");
    namesMap.put("YT", "Mayoot");
    namesMap.put("ZA", "Afrik bŋ Worgo");
    namesMap.put("ZM", "Sammbi");
    namesMap.put("ZW", "Simbaabuwe");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Anndoora",
        "AE": "Emiraat Araab Denntuɗe",
        "AF": "Afganistaan",
        "AG": "Antiguwaa e Barbudaa",
        "AI": "Anngiyaa",
        "AL": "Albanii",
        "AM": "Armenii",
        "AN": "Antiiye Nederlanndeeje",
        "AO": "Anngolaa",
        "AR": "Arjantiin",
        "AS": "Samowa Amerik",
        "AT": "Otiriis",
        "AU": "Ostaraalii",
        "AW": "Aruuba",
        "AZ": "Ajerbayjaan",
        "BA": "Bosnii Hersegowiin",
        "BB": "Barbadoos",
        "BD": "Banglaadees",
        "BE": "Beljik",
        "BF": "Burkibaa Faaso",
        "BG": "Bulgarii",
        "BH": "Bahreyn",
        "BI": "Burunndi",
        "BJ": "Benee",
        "BM": "Bermudaa",
        "BN": "Burnaay",
        "BO": "Boliwii",
        "BR": "Beresiil",
        "BS": "Bahamaas",
        "BT": "Butaan",
        "BW": "Botswaana",
        "BY": "Belaruus",
        "BZ": "Beliise",
        "CA": "Kanadaa",
        "CD": "Ndenndaandi Demokaraasiire Konngo",
        "CF": "Ndenndaandi Santarafrik",
        "CG": "Konngo",
        "CH": "Suwiis",
        "CI": "Kodduwaar",
        "CK": "Duuɗe Kuuk",
        "CL": "Cilii",
        "CM": "Kameruun",
        "CN": "Siin",
        "CO": "Kolombiya",
        "CR": "Kosta Rikaa",
        "CU": "Kubaa",
        "CV": "Duuɗe Kap Weer",
        "CY": "Siipar",
        "CZ": "Ndenndaandi Cek",
        "DE": "Almaañ",
        "DJ": "Jibutii",
        "DK": "Danmark",
        "DM": "Dominika",
        "DO": "Ndenndanndi Dominika",
        "DZ": "Alaseri",
        "EC": "Ekuwatoor",
        "EE": "Estoni",
        "EG": "Ejipt",
        "ER": "Eriteree",
        "ES": "Espaañ",
        "ET": "Ecoppi",
        "FI": "Fenland",
        "FJ": "Fijji",
        "FK": "Duuɗe Falkland",
        "FM": "Mikoronesii",
        "FR": "Farayse",
        "GA": "Gaboo",
        "GB": "Laamateeri Rentundi",
        "GD": "Garnaad",
        "GE": "Jeorgii",
        "GF": "Giyaan Farayse",
        "GH": "Ganaa",
        "GI": "Jibraltaar",
        "GL": "Gorwendland",
        "GM": "Gammbi",
        "GN": "Gine",
        "GP": "Gwaadalup",
        "GQ": "Ginee Ekuwaatoriyaal",
        "GR": "Gerees",
        "GT": "Gwaatemalaa",
        "GU": "Guwam",
        "GW": "Gine-Bisaawo",
        "GY": "Giyaan",
        "HN": "Onnduraas",
        "HR": "Korwasii",
        "HT": "Haytii",
        "HU": "Onngiri",
        "ID": "Enndonesii",
        "IE": "Irlannda",
        "IL": "Israa'iila",
        "IN": "Enndo",
        "IO": "Keeriindi britaani to maayo enndo",
        "IQ": "Iraak",
        "IR": "Iraan",
        "IS": "Islannda",
        "IT": "Itali",
        "JM": "Jamayka",
        "JO": "Jordani",
        "JP": "Sapoo",
        "KE": "Keñaa",
        "KG": "Kirgistaan",
        "KH": "Kambodso",
        "KI": "Kiribari",
        "KM": "Komoor",
        "KN": "Sent Kits e Newis",
        "KP": "Koree Rewo",
        "KR": "Koree Worgo",
        "KW": "Kuweyti",
        "KY": "Duuɗe Kaymaa",
        "KZ": "Kasakstaan",
        "LA": "Lawoos",
        "LB": "Libaa",
        "LC": "Sent Lusiyaa",
        "LI": "Lincenstayn",
        "LK": "Siri Lanka",
        "LR": "Liberiyaa",
        "LS": "Lesoto",
        "LT": "Lituaanii",
        "LU": "Liksembuur",
        "LV": "Letonii",
        "LY": "Libi",
        "MA": "Maruk",
        "MC": "Monaakoo",
        "MD": "Moldawii",
        "MG": "Madagaskaar",
        "MH": "Duuɗe Marsaal",
        "MK": "Meceduwaan",
        "ML": "Maali",
        "MM": "Miyamaar",
        "MN": "Monngolii",
        "MP": "Duuɗe Mariyaana Rewo",
        "MQ": "Martinik",
        "MR": "Muritani",
        "MS": "Monseraat",
        "MT": "Malte",
        "MU": "Moriis",
        "MV": "Maldiiwe",
        "MW": "Malaawi",
        "MX": "Meksik",
        "MY": "Malesii",
        "MZ": "Mosammbik",
        "NA": "Namibii",
        "NC": "Nuwel Kaledonii",
        "NE": "Nijeer",
        "NF": "Duuɗe Norfolk",
        "NG": "Nijeriyaa",
        "NI": "Nikaraguwaa",
        "NL": "Nederlannda",
        "NO": "Norwees",
        "NP": "Nepaal",
        "NR": "Nawuru",
        "NU": "Niuwe",
        "NZ": "Nuwel Selannda",
        "OM": "Omaan",
        "PA": "Panamaa",
        "PF": "Polinesii Farayse",
        "PG": "Papuwaa Nuwel Gine",
        "PH": "Filipiin",
        "PK": "Pakistaan",
        "PL": "Poloñ",
        "PM": "See Piyeer e Mikeloo",
        "PN": "Pitkern",
        "PR": "Porto Rikoo",
        "PS": "Palestiin Sisjordani e Gaasaa",
        "PT": "Purtugaal",
        "PW": "Palawu",
        "PY": "Paraguwaay",
        "QA": "Kataar",
        "RE": "Rewiñoo",
        "RO": "Rumanii",
        "RU": "Riisii",
        "RW": "Ruwanndaa",
        "SA": "Arabii Sawdit",
        "SB": "Duuɗe Solomon",
        "SC": "Seysel",
        "SD": "Sudaan",
        "SE": "Suweed",
        "SG": "Sinngapuur",
        "SH": "Sent Helen",
        "SI": "Slowenii",
        "SK": "Slowakii",
        "SL": "Seraa liyon",
        "SM": "See Maree",
        "SN": "Senegaal",
        "SO": "Somalii",
        "SR": "Surinaam",
        "ST": "Sawo Tome e Perensipe",
        "SV": "El Salwador",
        "SY": "Sirii",
        "SZ": "Swaasilannda",
        "TC": "Duuɗe Turke e Keikoos",
        "TD": "Caad",
        "TG": "Togoo",
        "TH": "Taylannda",
        "TJ": "Tajikistaan",
        "TK": "Tokelaaw",
        "TL": "Timoor Fuɗnaange",
        "TM": "Turkmenistaan",
        "TN": "Tunisii",
        "TO": "Tonngaa",
        "TR": "Turkii",
        "TT": "Tirnidaad e Tobaago",
        "TV": "Tuwaluu",
        "TW": "Taywaan",
        "TZ": "Tansanii",
        "UA": "Ukereen",
        "UG": "Unganndaa",
        "US": "Dowlaaji Dentuɗi Amerik",
        "UY": "Uruguwaay",
        "UZ": "Usbekistaan",
        "VA": "Dowla Waticaan",
        "VC": "See Weesaa e Garnadiin",
        "VE": "Wenesuwelaa",
        "VG": "duuɗe kecce britanii",
        "VI": "Duuɗe Kecce Amerik",
        "VN": "Wiyetnaam",
        "VU": "Wanuwaatuu",
        "WF": "Walis e Futuna",
        "WS": "Samowaa",
        "YT": "Mayoot",
        "ZA": "Afrik bŋ Worgo",
        "ZM": "Sammbi",
        "ZW": "Simbaabuwe"
    };
  }-*/;
}
