/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.media.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.VideoElement;
import com.google.gwt.user.client.ui.FocusWidget;

public class Video
extends FocusWidget {
    private static VideoElementSupportDetector detector;

    public static Video createIfSupported() {
        if (detector == null) {
            detector = (VideoElementSupportDetector)GWT.create(VideoElementSupportDetector.class);
        }
        if (!detector.isSupportedCompileTime()) {
            return null;
        }
        VideoElement element = Document.get().createVideoElement();
        if (!VideoElementSupportDetector.isSupportedRunTime(element)) {
            return null;
        }
        return new Video(element);
    }

    public static boolean isSupported() {
        if (detector == null) {
            detector = (VideoElementSupportDetector)GWT.create(VideoElementSupportDetector.class);
        }
        if (!detector.isSupportedCompileTime()) {
            return false;
        }
        VideoElement element = Document.get().createVideoElement();
        return VideoElementSupportDetector.isSupportedRunTime(element);
    }

    private Video(VideoElement element) {
        this.setElement(element);
    }

    public Video(String src) {
        this.setElement(Document.get().createVideoElement());
        this.getVideoElement().setSrc(src);
    }

    public VideoElement getVideoElement() {
        return (VideoElement)this.getElement().cast();
    }

    private static class VideoElementSupportDetectedNo
    extends VideoElementSupportDetector {
        private VideoElementSupportDetectedNo() {
        }

        boolean isSupportedCompileTime() {
            return false;
        }
    }

    private static class VideoElementSupportDetectedMaybe
    extends VideoElementSupportDetector {
        private VideoElementSupportDetectedMaybe() {
        }

        boolean isSupportedCompileTime() {
            return true;
        }
    }

    private static class VideoElementSupportDetector {
        private VideoElementSupportDetector() {
        }

        static native boolean isSupportedRunTime(VideoElement var0);

        boolean isSupportedCompileTime() {
            return false;
        }
    }
}

