/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.event.shared;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.event.shared.SimpleEventBus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerManager
implements HasHandlers {
    private final SimpleEventBus eventBus;
    private final Object source;

    public HandlerManager(Object source) {
        this(source, false);
    }

    public HandlerManager(Object source, boolean fireInReverseOrder) {
        this.eventBus = new SimpleEventBus(fireInReverseOrder);
        this.source = source;
    }

    public <H extends EventHandler> HandlerRegistration addHandler(GwtEvent.Type<H> type, H handler) {
        return this.eventBus.addHandler(type, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireEvent(GwtEvent<?> event) {
        if (!event.isLive()) {
            event.revive();
        }
        Object oldSource = event.getSource();
        event.setSource(this.source);
        try {
            this.eventBus.fireEvent(event);
        }
        finally {
            if (oldSource == null) {
                event.kill();
            } else {
                event.setSource(oldSource);
            }
        }
    }

    public <H extends EventHandler> H getHandler(GwtEvent.Type<H> type, int index) {
        return this.eventBus.getHandler(type, index);
    }

    public int getHandlerCount(GwtEvent.Type<?> type) {
        return this.eventBus.getHandlerCount(type);
    }

    public boolean isEventHandled(GwtEvent.Type<?> e) {
        return this.eventBus.isEventHandled(e);
    }

    public <H extends EventHandler> void removeHandler(GwtEvent.Type<H> type, H handler) {
        this.eventBus.doRemove(type, null, handler);
    }
}

