/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.autobean.server;

import com.google.gwt.autobean.server.BeanMethod;
import com.google.gwt.autobean.server.ProxyAutoBean;
import com.google.gwt.autobean.server.impl.TypeUtils;
import com.google.gwt.autobean.shared.AutoBean;
import com.google.gwt.autobean.shared.AutoBeanUtils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShimHandler<T>
implements InvocationHandler {
    private final ProxyAutoBean<T> bean;
    private final Method interceptor;
    private final T toWrap;

    public ShimHandler(ProxyAutoBean<T> bean, T toWrap) {
        this.bean = bean;
        this.toWrap = toWrap;
        Method maybe = null;
        for (Class<?> clazz : bean.getConfiguration().getCategories()) {
            try {
                maybe = clazz.getMethod("__intercept", AutoBean.class, Object.class);
                break;
            }
            catch (SecurityException expected) {
            }
            catch (NoSuchMethodException expected) {
            }
        }
        this.interceptor = maybe;
    }

    public boolean equals(Object couldBeShim) {
        if (couldBeShim == null) {
            return false;
        }
        if (Proxy.isProxyClass(couldBeShim.getClass()) && this == Proxy.getInvocationHandler(couldBeShim)) {
            return true;
        }
        return this.bean.getWrapped().equals(couldBeShim);
    }

    public int hashCode() {
        return this.bean.getWrapped().hashCode();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object toReturn;
        method.setAccessible(true);
        String name = method.getName();
        this.bean.checkWrapped();
        method.setAccessible(true);
        if (BeanMethod.OBJECT.matches(method)) {
            return method.invoke((Object)this, args);
        }
        if (BeanMethod.GET.matches(method)) {
            toReturn = method.invoke(this.toWrap, args);
            toReturn = this.bean.get(name, toReturn);
        } else if (BeanMethod.SET.matches(method)) {
            this.bean.checkFrozen();
            toReturn = method.invoke(this.toWrap, args);
            this.bean.set(name, args[0]);
        } else {
            toReturn = method.invoke(this.toWrap, args);
            this.bean.call(name, toReturn, args);
        }
        Class<?> intf = method.getReturnType();
        if (!Object.class.equals(intf)) {
            toReturn = this.maybeWrap(intf, toReturn);
        }
        if (this.interceptor != null) {
            toReturn = this.interceptor.invoke(null, this.bean, toReturn);
        }
        return toReturn;
    }

    public String toString() {
        return this.bean.getWrapped().toString();
    }

    private Object maybeWrap(Class<?> intf, Object toReturn) {
        if (toReturn == null) {
            return null;
        }
        if (TypeUtils.isValueType(intf) || TypeUtils.isValueType(toReturn.getClass()) || AutoBeanUtils.getAutoBean(toReturn) != null || this.bean.getConfiguration().getNoWrap().contains(intf)) {
            return toReturn;
        }
        if (toReturn.getClass().isArray()) {
            int j = Array.getLength(toReturn);
            for (int i = 0; i < j; ++i) {
                Object value = Array.get(toReturn, i);
                if (value == null) continue;
                Array.set(toReturn, i, this.maybeWrap(value.getClass(), value));
            }
            return toReturn;
        }
        ProxyAutoBean<Object> newBean = new ProxyAutoBean<Object>(this.bean.getFactory(), intf, this.bean.getConfiguration(), toReturn);
        return newBean.as();
    }
}

