/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.JavaScriptObject;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FastStringMap<T>
extends AbstractMap<String, T> {
    private JavaScriptObject map;

    public FastStringMap() {
        this.init();
    }

    @Override
    public void clear() {
        this.init();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(this.keyMustBeString(key), this.map);
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.values().contains(arg0);
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return new AbstractSet<Map.Entry<String, T>>(){

            @Override
            public boolean contains(Object key) {
                Map.Entry s = (Map.Entry)key;
                Object value = FastStringMap.this.get(s.getKey());
                if (value == null) {
                    return value == s.getValue();
                }
                return value.equals(s.getValue());
            }

            @Override
            public Iterator<Map.Entry<String, T>> iterator() {
                Iterator custom = new Iterator<Map.Entry<String, T>>(){
                    Iterator<String> keys;
                    {
                        this.keys = FastStringMap.this.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keys.hasNext();
                    }

                    @Override
                    public Map.Entry<String, T> next() {
                        String key = this.keys.next();
                        return new ImplMapEntry(key, FastStringMap.this.get(key));
                    }

                    @Override
                    public void remove() {
                        this.keys.remove();
                    }
                };
                return custom;
            }

            @Override
            public int size() {
                return FastStringMap.this.size();
            }
        };
    }

    @Override
    public T get(Object key) {
        return this.get(this.keyMustBeString(key));
    }

    public native T get(String var1);

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<String> keySet() {
        return new AbstractSet<String>(){

            @Override
            public boolean contains(Object key) {
                return FastStringMap.this.containsKey(key);
            }

            @Override
            public Iterator<String> iterator() {
                ArrayList l = new ArrayList();
                FastStringMap.this.addAllKeysFromJavascriptObject(l, FastStringMap.this.map);
                return l.iterator();
            }

            @Override
            public int size() {
                return FastStringMap.this.size();
            }
        };
    }

    @Override
    public native T put(String var1, T var2);

    @Override
    public void putAll(Map<? extends String, ? extends T> arg0) {
        for (Map.Entry<String, T> entry : arg0.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public T remove(Object key) {
        return this.remove(this.keyMustBeString(key));
    }

    @Override
    public native int size();

    @Override
    public Collection<T> values() {
        ArrayList values = new ArrayList();
        this.addAllValuesFromJavascriptObject(values, this.map);
        return values;
    }

    private native void addAllKeysFromJavascriptObject(Collection<String> var1, JavaScriptObject var2);

    private native void addAllValuesFromJavascriptObject(Collection<T> var1, JavaScriptObject var2);

    private native boolean containsKey(String var1, JavaScriptObject var2);

    private native void init();

    private String keyMustBeString(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        throw new IllegalArgumentException(this.getClass().getName() + " can only have Strings as keys, not" + key);
    }

    private native T remove(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImplMapEntry<T>
    implements Map.Entry<String, T> {
        private String key;
        private T value;

        ImplMapEntry(String key, T value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean equals(Object a) {
            Map.Entry s;
            return a instanceof Map.Entry && this.equalsWithNullCheck(this.key, (s = (Map.Entry)a).getKey()) && this.equalsWithNullCheck(this.value, s.getValue());
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            int keyHash = 0;
            int valueHash = 0;
            if (this.key != null) {
                keyHash = this.key.hashCode();
            }
            if (this.value != null) {
                valueHash = this.value.hashCode();
            }
            return keyHash ^ valueHash;
        }

        @Override
        public T setValue(T object) {
            T old = this.value;
            this.value = object;
            return old;
        }

        private boolean equalsWithNullCheck(Object a, Object b) {
            if (a == b) {
                return true;
            }
            if (a == null) {
                return false;
            }
            return a.equals(b);
        }
    }
}

