/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.rpc.server;

import com.google.gwt.rpc.client.ast.ArrayValueCommand;
import com.google.gwt.rpc.client.ast.BooleanValueCommand;
import com.google.gwt.rpc.client.ast.ByteValueCommand;
import com.google.gwt.rpc.client.ast.CharValueCommand;
import com.google.gwt.rpc.client.ast.CommandSink;
import com.google.gwt.rpc.client.ast.DoubleValueCommand;
import com.google.gwt.rpc.client.ast.EnumValueCommand;
import com.google.gwt.rpc.client.ast.FloatValueCommand;
import com.google.gwt.rpc.client.ast.InstantiateCommand;
import com.google.gwt.rpc.client.ast.IntValueCommand;
import com.google.gwt.rpc.client.ast.InvokeCustomFieldSerializerCommand;
import com.google.gwt.rpc.client.ast.LongValueCommand;
import com.google.gwt.rpc.client.ast.NullValueCommand;
import com.google.gwt.rpc.client.ast.ReturnCommand;
import com.google.gwt.rpc.client.ast.RpcCommand;
import com.google.gwt.rpc.client.ast.RpcCommandVisitor;
import com.google.gwt.rpc.client.ast.SetCommand;
import com.google.gwt.rpc.client.ast.ShortValueCommand;
import com.google.gwt.rpc.client.ast.StringValueCommand;
import com.google.gwt.rpc.client.ast.ThrowCommand;
import com.google.gwt.rpc.client.ast.ValueCommand;
import com.google.gwt.rpc.client.impl.CommandClientSerializationStreamReader;
import com.google.gwt.rpc.client.impl.EscapeUtil;
import com.google.gwt.rpc.server.ClientOracle;
import com.google.gwt.rpc.server.WebModeClientOracle;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class WebModePayloadSink
extends CommandSink {
    static final byte[] COMMA_BYTES = WebModePayloadSink.getBytes(",");
    static final byte[] DOT_BYTES = WebModePayloadSink.getBytes(".");
    static final byte[] EQ_BYTES = WebModePayloadSink.getBytes("=");
    static final byte[] FUNCTION_BYTES = WebModePayloadSink.getBytes("function ");
    static final byte[] LBRACE_BYTES = WebModePayloadSink.getBytes("{");
    static final byte[] LBRACKET_BYTES = WebModePayloadSink.getBytes("[");
    static final byte[] LPAREN_BYTES = WebModePayloadSink.getBytes("(");
    static final byte[] NEW_BYTES = WebModePayloadSink.getBytes("new ");
    static final byte[] NEWLINE_BYTES = WebModePayloadSink.getBytes("\n");
    static final byte[] NULL_BYTES = WebModePayloadSink.getBytes("null");
    static final byte[] ONE_BYTES = WebModePayloadSink.getBytes("1");
    static final byte[] QUOTE_BYTES = WebModePayloadSink.getBytes("\"");
    static final byte[] RBRACE_BYTES = WebModePayloadSink.getBytes("}");
    static final byte[] RBRACKET_BYTES = WebModePayloadSink.getBytes("]");
    static final byte[] RETURN_BYTES = WebModePayloadSink.getBytes("return ");
    static final byte[] RPAREN_BYTES = WebModePayloadSink.getBytes(")");
    static final byte[] SPACE_BYTES = WebModePayloadSink.getBytes(" ");
    static final byte[] SEMI_BYTES = WebModePayloadSink.getBytes(";");
    static final byte[] THROW_BYTES = WebModePayloadSink.getBytes("throw ");
    static final byte[] ZERO_BYTES = WebModePayloadSink.getBytes("0");
    static final boolean PRETTY = Boolean.getBoolean("gwt.rpc.pretty");
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private final ClientOracle clientOracle;
    private boolean finished = false;
    private final OutputStream out;
    private final Map<ValueCommand, byte[]> valueBackRefs = new HashMap<ValueCommand, byte[]>();
    private final PayloadVisitor visitor = new PayloadVisitor();
    private Stack<byte[]> freeBackRefs = new Stack();

    static byte[] getBytes(String x) {
        try {
            return x.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 is unsupported", e);
        }
    }

    public WebModePayloadSink(ClientOracle clientOracle, OutputStream out) {
        this.clientOracle = clientOracle;
        this.out = out;
    }

    public void accept(RpcCommand command) throws SerializationException {
        if (this.finished) {
            throw new IllegalStateException("finish() has already been called");
        }
        new BackRefAssigner().accept(command);
        if (command instanceof ValueCommand) {
            this.makeBackRef((ValueCommand)command);
        }
        this.visitor.accept(command);
    }

    public void finish() throws SerializationException {
        if (this.finished) {
            return;
        }
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new SerializationException("Could not flush stream", e);
        }
        this.finished = true;
    }

    void forget(ValueCommand x) {
        assert (this.valueBackRefs.containsKey(x));
        this.freeBackRefs.push(this.valueBackRefs.remove(x));
    }

    boolean hasBackRef(ValueCommand x) {
        return this.valueBackRefs.containsKey(x);
    }

    byte[] makeBackRef(ValueCommand x) {
        byte[] toReturn = this.valueBackRefs.get(x);
        if (toReturn == null) {
            if (this.freeBackRefs.isEmpty()) {
                int idx = this.valueBackRefs.size();
                toReturn = WebModePayloadSink.getBytes("_._" + Integer.toString(idx, 36));
            } else {
                toReturn = this.freeBackRefs.pop();
            }
            this.valueBackRefs.put(x, toReturn);
        }
        return toReturn;
    }

    void send(ByteBuffer x) throws SerializationException {
        try {
            assert (x.hasArray());
            this.out.write(x.array(), x.position(), x.limit());
        }
        catch (IOException e) {
            throw new SerializationException("Could not send data", e);
        }
    }

    void send(String x) throws SerializationException {
        try {
            this.out.write(WebModePayloadSink.getBytes(x));
        }
        catch (IOException e) {
            throw new SerializationException("Could not send data", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PayloadVisitor
    extends RpcCommandVisitor {
        private final Map<Class<?>, byte[]> constructorFunctions = new IdentityHashMap();
        private final Map<RpcCommand, ByteBuffer> commandBuffers = new IdentityHashMap<RpcCommand, ByteBuffer>();
        private ByteBuffer currentBuffer;
        private final Stack<RpcCommand> stack = new Stack();
        private final Set<RpcCommand> started = new HashSet<RpcCommand>();

        private PayloadVisitor() {
        }

        @Override
        public void endVisit(BooleanValueCommand x, RpcCommandVisitor.Context ctx) {
            if (x.getValue().booleanValue()) {
                this.one();
            } else {
                this.zero();
            }
        }

        @Override
        public void endVisit(ByteValueCommand x, RpcCommandVisitor.Context ctx) {
            this.push(String.valueOf(x.getValue()));
        }

        @Override
        public void endVisit(CharValueCommand x, RpcCommandVisitor.Context ctx) {
            this.push(String.valueOf((int)x.getValue().charValue()));
        }

        @Override
        public void endVisit(DoubleValueCommand x, RpcCommandVisitor.Context ctx) {
            this.push(String.valueOf(x.getValue()));
        }

        @Override
        public void endVisit(EnumValueCommand x, RpcCommandVisitor.Context ctx) {
            String fieldName = WebModePayloadSink.this.clientOracle.getFieldId(x.getValue());
            if (fieldName == null) {
                throw new IncompatibleRemoteServiceException("The client cannot accept " + x.getValue().name());
            }
            String clinitName = WebModePayloadSink.this.clientOracle.getMethodId(x.getValue().getDeclaringClass(), "$clinit", new Class[0]);
            assert (clinitName != null);
            this.lparen();
            this.push(clinitName);
            this.lparen();
            this.rparen();
            this.comma();
            this.push(fieldName);
            this.rparen();
        }

        @Override
        public void endVisit(FloatValueCommand x, RpcCommandVisitor.Context ctx) {
            this.push(String.valueOf((double)x.getValue().floatValue()));
        }

        @Override
        public void endVisit(IntValueCommand x, RpcCommandVisitor.Context ctx) {
            this.push(String.valueOf(x.getValue()));
        }

        @Override
        public void endVisit(LongValueCommand x, RpcCommandVisitor.Context ctx) {
            long fieldValue = x.getValue();
            double[] parts = AbstractSerializationStreamWriter.makeLongComponents((int)(fieldValue >> 32), (int)fieldValue);
            assert (parts.length == 2);
            this.lbracket();
            this.push(String.valueOf(parts[0]));
            this.comma();
            this.push(String.valueOf(parts[1]));
            this.rbracket();
        }

        @Override
        public void endVisit(NullValueCommand x, RpcCommandVisitor.Context ctx) {
            this._null();
        }

        @Override
        public void endVisit(ShortValueCommand x, RpcCommandVisitor.Context ctx) {
            this.push(String.valueOf(x.getValue()));
        }

        @Override
        public void endVisit(StringValueCommand x, RpcCommandVisitor.Context ctx) {
            if (WebModePayloadSink.this.hasBackRef(x)) {
                if (!this.isStarted(x)) {
                    String escaped = EscapeUtil.escape(x.getValue());
                    this.push(this.begin(x));
                    this.eq();
                    this.quote();
                    this.push(escaped);
                    this.quote();
                    this.commit(x, false);
                } else {
                    this.push(WebModePayloadSink.this.makeBackRef(x));
                }
            } else {
                String escaped = EscapeUtil.escape(x.getValue());
                this.quote();
                this.push(escaped);
                this.quote();
            }
        }

        @Override
        public boolean visit(ArrayValueCommand x, RpcCommandVisitor.Context ctx) {
            boolean hasBackRef = WebModePayloadSink.this.hasBackRef(x);
            if (hasBackRef && this.isStarted(x)) {
                this.push(WebModePayloadSink.this.makeBackRef(x));
                return false;
            }
            byte[] currentBackRef = this.begin(x);
            this.push(this.constructorFunction(x));
            this.lparen();
            if (hasBackRef) {
                this.push(currentBackRef);
                this.eq();
            }
            this.lbracket();
            Iterator<ValueCommand> it = x.getComponentValues().iterator();
            while (it.hasNext()) {
                this.accept(it.next());
                if (!it.hasNext()) continue;
                this.comma();
            }
            this.rbracket();
            this.rparen();
            this.commit(x, false);
            if (!hasBackRef) {
                WebModePayloadSink.this.forget(x);
            }
            return false;
        }

        @Override
        public boolean visit(InstantiateCommand x, RpcCommandVisitor.Context ctx) {
            boolean hasBackRef = WebModePayloadSink.this.hasBackRef(x);
            if (hasBackRef && this.isStarted(x)) {
                this.push(WebModePayloadSink.this.makeBackRef(x));
                return false;
            }
            byte[] currentBackRef = this.begin(x);
            byte[] constructorFunction = this.constructorFunction(x);
            String seedName = WebModePayloadSink.this.clientOracle.getSeedName(x.getTargetClass());
            if (seedName == null) {
                throw new IncompatibleRemoteServiceException("The client cannot create type " + x.getTargetClass());
            }
            this.push(constructorFunction);
            this.lparen();
            if (hasBackRef) {
                this.push(currentBackRef);
                this.eq();
            }
            this._new();
            this.push(seedName);
            for (SetCommand setter : x.getSetters()) {
                this.comma();
                this.accept(setter.getValue());
            }
            this.rparen();
            this.commit(x, false);
            if (!hasBackRef) {
                WebModePayloadSink.this.forget(x);
            }
            return false;
        }

        @Override
        public boolean visit(InvokeCustomFieldSerializerCommand x, RpcCommandVisitor.Context ctx) {
            if (this.isStarted(x)) {
                this.push(WebModePayloadSink.this.makeBackRef(x));
                return false;
            }
            byte[] currentBackRef = this.begin(x);
            this.lparen();
            InstantiateCommand makeReader = new InstantiateCommand(CommandClientSerializationStreamReader.class);
            WebModePayloadSink.this.makeBackRef(makeReader);
            ArrayValueCommand payload = new ArrayValueCommand(Object.class);
            for (ValueCommand value : x.getValues()) {
                payload.add(value);
            }
            makeReader.set(CommandClientSerializationStreamReader.class, "payload", payload);
            String instantiateIdent = WebModePayloadSink.this.clientOracle.getMethodId(x.getSerializerClass(), "instantiate", SerializationStreamReader.class);
            this.push(currentBackRef);
            this.eq();
            if (instantiateIdent == null) {
                String constructorMethodName;
                instantiateIdent = WebModePayloadSink.this.clientOracle.getSeedName(x.getTargetClass());
                assert (instantiateIdent != null) : "instantiateIdent";
                if (x.getTargetClass().getEnclosingClass() == null) {
                    constructorMethodName = "$" + x.getTargetClass().getSimpleName();
                } else {
                    String name = x.getTargetClass().getName();
                    constructorMethodName = "$" + name.substring(name.lastIndexOf(46) + 1);
                }
                String constructorIdent = WebModePayloadSink.this.clientOracle.getMethodId(x.getTargetClass(), constructorMethodName, x.getTargetClass());
                assert (constructorIdent != null) : "constructorIdent " + constructorMethodName;
                this.push(constructorIdent);
                this.lparen();
                this._new();
                this.push(instantiateIdent);
                this.rparen();
                this.comma();
            } else {
                this.push(instantiateIdent);
                this.lparen();
                this.accept(makeReader);
                this.rparen();
                this.comma();
            }
            String deserializeIdent = WebModePayloadSink.this.clientOracle.getMethodId(x.getSerializerClass(), "deserialize", SerializationStreamReader.class, x.getManuallySerializedType());
            if (deserializeIdent != null) {
                this.push(deserializeIdent);
                this.lparen();
                this.accept(makeReader);
                this.comma();
                this.push(currentBackRef);
                this.rparen();
                this.comma();
            }
            for (SetCommand setter : x.getSetters()) {
                this.accept(setter);
                this.comma();
            }
            this.push(currentBackRef);
            this.rparen();
            this.commit(x, false);
            WebModePayloadSink.this.forget(makeReader);
            return false;
        }

        @Override
        public boolean visit(ReturnCommand x, RpcCommandVisitor.Context ctx) {
            int size = x.getValues().size();
            this.begin(x);
            this._return();
            this.lbracket();
            for (int i = 0; i < size; ++i) {
                this.accept(x.getValues().get(i));
                if (i >= size - 1) continue;
                this.comma();
            }
            this.rbracket();
            this.semi();
            this.commit(x);
            return false;
        }

        @Override
        public boolean visit(SetCommand x, RpcCommandVisitor.Context ctx) {
            String fieldName = WebModePayloadSink.this.clientOracle.getFieldId(x.getFieldDeclClass(), x.getField());
            if (fieldName == null) {
                throw new IncompatibleRemoteServiceException("The client does not have field " + x.getField() + " in type " + x.getFieldDeclClass().getName());
            }
            this.push(WebModePayloadSink.this.makeBackRef((ValueCommand)this.stack.peek()));
            this.dot();
            this.push(fieldName);
            this.eq();
            this.accept(x.getValue());
            return false;
        }

        @Override
        public boolean visit(ThrowCommand x, RpcCommandVisitor.Context ctx) {
            this.begin(x);
            this._throw();
            assert (x.getValues().size() == 1);
            this.accept(x.getValues());
            this.semi();
            this.commit(x);
            return false;
        }

        private void _new() {
            this.push(NEW_BYTES);
        }

        private void _null() {
            this.push(NULL_BYTES);
        }

        private void _return() {
            this.push(RETURN_BYTES);
        }

        private void _throw() {
            this.push(THROW_BYTES);
        }

        private void begin(RpcCommand x) {
            assert (!this.commandBuffers.containsKey(x)) : "ValueCommand already active";
            this.started.add(x);
            this.stack.push(x);
            this.currentBuffer = ByteBuffer.allocate(256);
            this.commandBuffers.put(x, this.currentBuffer);
        }

        private byte[] begin(ValueCommand x) {
            this.begin((RpcCommand)x);
            return WebModePayloadSink.this.makeBackRef(x);
        }

        private void comma() {
            this.push(COMMA_BYTES);
            this.spaceOpt();
        }

        private void commit(RpcCommand x) {
            this.commit(x, true);
        }

        private void commit(RpcCommand x, boolean send) {
            if (this.stack.pop() != x) {
                throw new IllegalStateException("Did not pop expected command");
            }
            x.clear();
            ByteBuffer sb = this.commandBuffers.remove(x);
            assert (sb != null) : "No ByteBuffer for " + x;
            if (!this.stack.isEmpty()) {
                this.currentBuffer = this.commandBuffers.get(this.stack.peek());
                assert (this.currentBuffer != null) : "Could not restore currentBuilder";
            } else {
                this.currentBuffer = null;
            }
            sb.limit(sb.position()).rewind();
            if (send) {
                try {
                    WebModePayloadSink.this.send(sb);
                }
                catch (SerializationException e) {
                    this.halt(e);
                }
            } else {
                this.push(sb);
            }
        }

        private byte[] constructorFunction(ArrayValueCommand x) {
            int queryId;
            Class<?> targetClass = Array.newInstance(x.getComponentType(), 0).getClass();
            byte[] functionName = this.constructorFunctions.get(targetClass);
            if (functionName != null) {
                return functionName;
            }
            String initValuesId = WebModePayloadSink.this.clientOracle.getMethodId("com.google.gwt.lang.Array", "initValues", "Ljava/lang/Class;", "I", "I", "Lcom/google/gwt/lang/Array;");
            assert (initValuesId != null) : "Could not find initValues";
            String classLitId = WebModePayloadSink.this.clientOracle.getFieldId("com.google.gwt.lang.ClassLiteralHolder", this.getJavahSignatureName(x.getComponentType()) + "_classLit");
            assert (classLitId != null) : "No class literal for " + x.getComponentType().getName();
            functionName = WebModePayloadSink.getBytes(WebModePayloadSink.this.clientOracle.createUnusedIdent(classLitId));
            this.constructorFunctions.put(targetClass, functionName);
            int typeId = WebModePayloadSink.this.clientOracle.getTypeId(targetClass);
            if (typeId == 0) {
                typeId = WebModePayloadSink.this.clientOracle.getTypeId(Object[].class);
            }
            if ((queryId = WebModePayloadSink.this.clientOracle.getTypeId(x.getComponentType())) == 0) {
                queryId = WebModePayloadSink.this.clientOracle.getTypeId(Object.class);
            }
            byte[] ident = WebModePayloadSink.getBytes("_0");
            this.function();
            this.push(functionName);
            this.lparen();
            this.push(ident);
            this.rparen();
            this.lbrace();
            this._return();
            this.push(initValuesId);
            this.lparen();
            this.push(classLitId);
            this.comma();
            this.push(String.valueOf(typeId));
            this.comma();
            this.push(String.valueOf(queryId));
            this.comma();
            this.push(ident);
            this.rparen();
            this.rbrace();
            this.flush(x);
            return functionName;
        }

        private byte[] constructorFunction(InstantiateCommand x) {
            int i;
            Class<?> targetClass = x.getTargetClass();
            byte[] functionName = this.constructorFunctions.get(targetClass);
            if (functionName != null) {
                return functionName;
            }
            String seedName = WebModePayloadSink.this.clientOracle.getSeedName(targetClass);
            assert (seedName != null) : "TypeOverride failed to rescue " + targetClass.getName();
            functionName = WebModePayloadSink.getBytes(WebModePayloadSink.this.clientOracle.createUnusedIdent(seedName));
            this.constructorFunctions.put(targetClass, functionName);
            byte[][] idents = new byte[x.getSetters().size() + 1][];
            int j = idents.length;
            for (i = 0; i < j; ++i) {
                idents[i] = WebModePayloadSink.getBytes("_" + i);
            }
            this.function();
            this.push(functionName);
            this.lparen();
            j = idents.length;
            for (i = 0; i < j; ++i) {
                this.push(idents[i]);
                if (i >= j - 1) continue;
                this.comma();
            }
            this.rparen();
            this.lbrace();
            this.newlineOpt();
            j = idents.length;
            for (i = 1; i < j; ++i) {
                SetCommand setter = x.getSetters().get(i - 1);
                String fieldIdent = WebModePayloadSink.this.clientOracle.getFieldId(setter.getFieldDeclClass(), setter.getField());
                this.spaceOpt();
                this.push(idents[0]);
                this.dot();
                this.push(fieldIdent);
                this.eq();
                this.push(idents[i]);
                this.semi();
            }
            this.spaceOpt();
            this._return();
            this.push(idents[0]);
            this.rbrace();
            this.newlineOpt();
            this.flush(x);
            return functionName;
        }

        private void dot() {
            this.push(DOT_BYTES);
        }

        private void eq() {
            this.spaceOpt();
            this.push(EQ_BYTES);
            this.spaceOpt();
        }

        private void flush(RpcCommand x) {
            ByteBuffer sb = this.commandBuffers.get(x);
            if (sb == null || sb.position() == 0) {
                return;
            }
            sb.limit(sb.position()).rewind();
            try {
                WebModePayloadSink.this.send(sb);
            }
            catch (SerializationException e) {
                this.halt(e);
            }
            sb.clear();
        }

        private void function() {
            this.newlineOpt();
            this.push(FUNCTION_BYTES);
        }

        private String getJavahSignatureName(Class<?> clazz) {
            if (clazz.isArray()) {
                Class<?> leafType = clazz;
                int dims = 0;
                do {
                    ++dims;
                } while ((leafType = leafType.getComponentType()).getComponentType() != null);
                assert (dims > 0);
                String s = this.getJavahSignatureName(leafType);
                for (int i = 0; i < dims; ++i) {
                    s = "_3" + s;
                }
                return s;
            }
            if (clazz.isPrimitive()) {
                return WebModeClientOracle.jsniName(clazz);
            }
            String name = clazz.getName();
            return "L" + name.replaceAll("_", "_1").replace('.', '_') + "_2";
        }

        private boolean isStarted(RpcCommand x) {
            return this.started.contains(x);
        }

        private void lbrace() {
            this.push(LBRACE_BYTES);
        }

        private void lbracket() {
            this.push(LBRACKET_BYTES);
        }

        private void lparen() {
            this.push(LPAREN_BYTES);
        }

        private void newlineOpt() {
            this.pushOpt(NEWLINE_BYTES);
        }

        private void one() {
            this.push(ONE_BYTES);
        }

        private void push(byte[] bytes) {
            assert (this.currentBuffer != null) : "Must call begin(RpcCommand) first";
            try {
                this.currentBuffer.put(bytes);
            }
            catch (BufferOverflowException e) {
                this.reallocateCurrentBuffer(bytes.length);
                this.currentBuffer.put(bytes);
            }
        }

        private void push(ByteBuffer buffer) {
            assert (this.currentBuffer != null) : "Must call begin(RpcCommand) first";
            try {
                this.currentBuffer.put(buffer);
            }
            catch (BufferOverflowException e) {
                this.reallocateCurrentBuffer(buffer.remaining());
                this.currentBuffer.put(buffer);
            }
        }

        private void push(String s) {
            this.push(WebModePayloadSink.getBytes(s));
        }

        private void pushOpt(byte[] x) {
            if (PRETTY) {
                this.push(x);
            }
        }

        private void quote() {
            this.push(QUOTE_BYTES);
        }

        private void rbrace() {
            this.push(RBRACE_BYTES);
        }

        private void rbracket() {
            this.push(RBRACKET_BYTES);
        }

        private void reallocateCurrentBuffer(int bytesNeeded) {
            int newSize = this.currentBuffer.capacity() + Math.max(2 * bytesNeeded, this.currentBuffer.capacity());
            ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
            this.currentBuffer.limit(this.currentBuffer.position()).rewind();
            newBuffer.put(this.currentBuffer);
            assert (this.commandBuffers.get(this.stack.peek()) == this.currentBuffer);
            this.commandBuffers.put(this.stack.peek(), newBuffer);
            this.currentBuffer = newBuffer;
        }

        private void rparen() {
            this.push(RPAREN_BYTES);
        }

        private void semi() {
            this.push(SEMI_BYTES);
            this.newlineOpt();
        }

        private void spaceOpt() {
            this.pushOpt(SPACE_BYTES);
        }

        private void zero() {
            this.push(ZERO_BYTES);
        }
    }

    private class BackRefAssigner
    extends RpcCommandVisitor {
        private final Set<ValueCommand> seenOnce = new HashSet<ValueCommand>();

        private BackRefAssigner() {
        }

        public void endVisit(InvokeCustomFieldSerializerCommand x, RpcCommandVisitor.Context ctx) {
            WebModePayloadSink.this.makeBackRef(x);
        }

        public void endVisit(LongValueCommand x, RpcCommandVisitor.Context ctx) {
            this.process(x);
        }

        public void endVisit(StringValueCommand x, RpcCommandVisitor.Context ctx) {
            this.process(x);
        }

        public boolean visit(ArrayValueCommand x, RpcCommandVisitor.Context ctx) {
            return this.process(x);
        }

        public boolean visit(InstantiateCommand x, RpcCommandVisitor.Context ctx) {
            return this.process(x);
        }

        private boolean process(ValueCommand x) {
            if (!this.seenOnce.add(x)) {
                WebModePayloadSink.this.makeBackRef(x);
                return false;
            }
            return true;
        }
    }
}

