/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.IgnoreJRERequirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
@IgnoreJRERequirement
public class MapForEachTester<K, V>
extends AbstractMapTester<K, V> {
    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testForEachKnownOrder() {
        ArrayList entries = new ArrayList();
        this.getMap().forEach((k, v) -> entries.add(this.entry(k, v)));
        MapForEachTester.assertEquals(this.getOrderedElements(), entries);
    }

    @CollectionFeature.Require(absent={CollectionFeature.KNOWN_ORDER})
    public void testForEachUnknownOrder() {
        ArrayList entries = new ArrayList();
        this.getMap().forEach((k, v) -> entries.add(this.entry(k, v)));
        Helpers.assertEqualIgnoringOrder(this.getSampleEntries(), entries);
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testForEach_nullKeys() {
        this.initMapWithNullKey();
        List expectedEntries = Arrays.asList(this.createArrayWithNullKey());
        ArrayList entries = new ArrayList();
        this.getMap().forEach((k, v) -> entries.add(this.entry(k, v)));
        Helpers.assertEqualIgnoringOrder(expectedEntries, entries);
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testForEach_nullValues() {
        this.initMapWithNullValue();
        List expectedEntries = Arrays.asList(this.createArrayWithNullValue());
        ArrayList entries = new ArrayList();
        this.getMap().forEach((k, v) -> entries.add(this.entry(k, v)));
        Helpers.assertEqualIgnoringOrder(expectedEntries, entries);
    }
}

