/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class MapCreationTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNullKeySupported() {
        this.initMapWithNullKey();
        this.expectContents(this.createArrayWithNullKey());
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNullKeyUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.initMapWithNullKey());
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNullValueSupported() {
        this.initMapWithNullValue();
        this.expectContents(this.createArrayWithNullValue());
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNullValueUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.initMapWithNullValue());
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNullKeyAndValueSupported() {
        Map.Entry[] entries = (Map.Entry[])this.createSamplesArray();
        entries[this.getNullLocation()] = this.entry(null, null);
        this.resetMap(entries);
        this.expectContents(entries);
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS}, absent={MapFeature.REJECTS_DUPLICATES_AT_CREATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testCreateWithDuplicates_nullDuplicatesNotRejected() {
        this.expectFirstRemoved(this.getEntriesMultipleNullKeys());
    }

    @MapFeature.Require(absent={MapFeature.REJECTS_DUPLICATES_AT_CREATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testCreateWithDuplicates_nonNullDuplicatesNotRejected() {
        this.expectFirstRemoved(this.getEntriesMultipleNonNullKeys());
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS, MapFeature.REJECTS_DUPLICATES_AT_CREATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testCreateWithDuplicates_nullDuplicatesRejected() {
        Map.Entry[] entries = this.getEntriesMultipleNullKeys();
        ReflectionFreeAssertThrows.assertThrows(IllegalArgumentException.class, () -> this.resetMap(entries));
    }

    @MapFeature.Require(value={MapFeature.REJECTS_DUPLICATES_AT_CREATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testCreateWithDuplicates_nonNullDuplicatesRejected() {
        Map.Entry[] entries = this.getEntriesMultipleNonNullKeys();
        ReflectionFreeAssertThrows.assertThrows(IllegalArgumentException.class, () -> this.resetMap(entries));
    }

    private Map.Entry<K, V>[] getEntriesMultipleNullKeys() {
        Map.Entry<K, V>[] entries = this.createArrayWithNullKey();
        entries[0] = this.entry(null, entries[0].getValue());
        return entries;
    }

    private Map.Entry<K, V>[] getEntriesMultipleNonNullKeys() {
        Map.Entry[] entries = (Map.Entry[])this.createSamplesArray();
        entries[0] = this.entry(this.k1(), this.v0());
        return entries;
    }

    private void expectFirstRemoved(Map.Entry<K, V>[] entries) {
        this.resetMap(entries);
        List<Map.Entry<K, V>> expectedWithDuplicateRemoved = Arrays.asList(entries).subList(1, this.getNumElements());
        this.expectContents(expectedWithDuplicateRemoved);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getCreateWithNullKeyUnsupportedMethod() {
        return Helpers.getMethod(MapCreationTester.class, "testCreateWithNullKeyUnsupported");
    }
}

