/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class CollectionRemoveAllTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveAll_emptyCollection() {
        CollectionRemoveAllTester.assertFalse((String)"removeAll(emptyCollection) should return false", (boolean)this.collection.removeAll(MinimalCollection.of(new Object[0])));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveAll_nonePresent() {
        CollectionRemoveAllTester.assertFalse((String)"removeAll(disjointCollection) should return false", (boolean)this.collection.removeAll(MinimalCollection.of(this.e3())));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAll_allPresent() {
        CollectionRemoveAllTester.assertTrue((String)"removeAll(intersectingCollection) should return true", (boolean)this.collection.removeAll(MinimalCollection.of(this.e0())));
        this.expectMissing(this.e0());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAll_somePresent() {
        CollectionRemoveAllTester.assertTrue((String)"removeAll(intersectingCollection) should return true", (boolean)this.collection.removeAll(MinimalCollection.of(this.e0(), this.e3())));
        this.expectMissing(this.e0());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemoveAllSomePresentConcurrentWithIteration() {
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, () -> {
            Iterator iterator = this.collection.iterator();
            CollectionRemoveAllTester.assertTrue((boolean)this.collection.removeAll(MinimalCollection.of(this.e0(), this.e3())));
            iterator.next();
        });
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAll_somePresentLargeCollectionToRemove() {
        CollectionRemoveAllTester.assertTrue((String)"removeAll(largeIntersectingCollection) should return true", (boolean)this.collection.removeAll(MinimalCollection.of(this.e0(), this.e0(), this.e0(), this.e3(), this.e3(), this.e3())));
        this.expectMissing(this.e0());
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveAll_unsupportedEmptyCollection() {
        try {
            CollectionRemoveAllTester.assertFalse((String)"removeAll(emptyCollection) should return false or throw UnsupportedOperationException", (boolean)this.collection.removeAll(MinimalCollection.of(new Object[0])));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveAll_unsupportedNonePresent() {
        try {
            CollectionRemoveAllTester.assertFalse((String)"removeAll(disjointCollection) should return false or throw UnsupportedOperationException", (boolean)this.collection.removeAll(MinimalCollection.of(this.e3())));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAll_unsupportedPresent() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.collection.removeAll(MinimalCollection.of(this.e0())));
        this.expectUnchanged();
        CollectionRemoveAllTester.assertTrue((boolean)this.collection.contains(this.e0()));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testRemoveAll_nullCollectionReferenceEmptySubject() {
        try {
            this.collection.removeAll(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAll_nullCollectionReferenceNonEmptySubject() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.collection.removeAll(null));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE}, absent={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testRemoveAll_containsNullNo() {
        MinimalCollection<Object> containsNull = MinimalCollection.of(new Object[]{null});
        try {
            CollectionRemoveAllTester.assertFalse((String)"removeAll(containsNull) should return false or throw", (boolean)this.collection.removeAll(containsNull));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testRemoveAll_containsNullNoButAllowed() {
        MinimalCollection<Object> containsNull = MinimalCollection.of(new Object[]{null});
        CollectionRemoveAllTester.assertFalse((String)"removeAll(containsNull) should return false", (boolean)this.collection.removeAll(containsNull));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAll_containsNullYes() {
        this.initCollectionWithNullElement();
        CollectionRemoveAllTester.assertTrue((String)"removeAll(containsNull) should return true", (boolean)this.collection.removeAll(Collections.singleton(null)));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveAll_containsWrongType() {
        try {
            CollectionRemoveAllTester.assertFalse((String)"removeAll(containsWrongType) should return false or throw", (boolean)this.collection.removeAll(MinimalCollection.of(WrongType.VALUE)));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

