/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class CollectionClearTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testClear() {
        this.collection.clear();
        CollectionClearTester.assertTrue((String)"After clear(), a collection should be empty.", (boolean)this.collection.isEmpty());
        CollectionClearTester.assertEquals((int)0, (int)this.collection.size());
        CollectionClearTester.assertFalse((boolean)this.collection.iterator().hasNext());
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testClear_unsupported() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.collection.clear());
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testClear_unsupportedByEmptyCollection() {
        try {
            this.collection.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testClearConcurrentWithIteration() {
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, () -> {
            Iterator iterator = this.collection.iterator();
            this.collection.clear();
            iterator.next();
        });
    }
}

