/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import com.google.common.testing.EqualsTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@NullMarked
@GwtCompatible
public class SetMultimapAsMapTester<K, V>
extends AbstractMultimapTester<K, V, SetMultimap<K, V>> {
    public void testAsMapValuesImplementSet() {
        for (Collection valueCollection : ((SetMultimap)this.multimap()).asMap().values()) {
            SetMultimapAsMapTester.assertTrue((boolean)(valueCollection instanceof Set));
        }
    }

    public void testAsMapGetImplementsSet() {
        for (Object key : ((SetMultimap)this.multimap()).keySet()) {
            SetMultimapAsMapTester.assertTrue((boolean)(((SetMultimap)this.multimap()).asMap().get(key) instanceof Set));
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testAsMapRemoveImplementsSet() {
        ArrayList keys = new ArrayList(((SetMultimap)this.multimap()).keySet());
        for (Object key : keys) {
            this.resetCollection();
            SetMultimapAsMapTester.assertTrue((boolean)(((SetMultimap)this.multimap()).asMap().remove(key) instanceof Set));
        }
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testEquals() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k1(), this.v0()), Helpers.mapEntry(this.k0(), this.v3()));
        HashMap expected = new HashMap();
        expected.put(this.k0(), Sets.newHashSet((Object[])new Object[]{this.v0(), this.v3()}));
        expected.put(this.k1(), Sets.newHashSet((Object[])new Object[]{this.v0()}));
        new EqualsTester().addEqualityGroup(expected, ((SetMultimap)this.multimap()).asMap()).testEquals();
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testEntrySetEquals() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k1(), this.v0()), Helpers.mapEntry(this.k0(), this.v3()));
        HashSet expected = new HashSet();
        expected.add(Helpers.mapEntry(this.k0(), Sets.newHashSet((Object[])new Object[]{this.v0(), this.v3()})));
        expected.add(Helpers.mapEntry(this.k1(), Sets.newHashSet((Object[])new Object[]{this.v0()})));
        new EqualsTester().addEqualityGroup(expected, ((SetMultimap)this.multimap()).asMap().entrySet()).testEquals();
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testValuesRemove() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k1(), this.v0()), Helpers.mapEntry(this.k0(), this.v3()));
        SetMultimapAsMapTester.assertTrue((boolean)((SetMultimap)this.multimap()).asMap().values().remove(Collections.singleton(this.v0())));
        SetMultimapAsMapTester.assertEquals((int)2, (int)((SetMultimap)this.multimap()).size());
        SetMultimapAsMapTester.assertEquals(Collections.singletonMap(this.k0(), Sets.newHashSet((Object[])new Object[]{this.v0(), this.v3()})), (Object)((SetMultimap)this.multimap()).asMap());
    }
}

