/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractBiMapTester;
import java.util.Iterator;
import java.util.Map;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class BiMapRemoveTester<K, V>
extends AbstractBiMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveKeyRemovesFromInverse() {
        this.getMap().remove(this.k0());
        this.expectMissing((Map.Entry)this.e0());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveKeyFromKeySetRemovesFromInverse() {
        this.getMap().keySet().remove(this.k0());
        this.expectMissing((Map.Entry)this.e0());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveFromValuesRemovesFromInverse() {
        this.getMap().values().remove(this.v0());
        this.expectMissing((Map.Entry)this.e0());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveFromInverseRemovesFromForward() {
        this.getMap().inverse().remove(this.v0());
        this.expectMissing((Map.Entry)this.e0());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveFromInverseKeySetRemovesFromForward() {
        this.getMap().inverse().keySet().remove(this.v0());
        this.expectMissing((Map.Entry)this.e0());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveFromInverseValuesRemovesFromInverse() {
        this.getMap().inverse().values().remove(this.k0());
        this.expectMissing((Map.Entry)this.e0());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testKeySetIteratorRemove() {
        int initialSize = this.getNumElements();
        Iterator iterator = this.getMap().keySet().iterator();
        iterator.next();
        iterator.remove();
        BiMapRemoveTester.assertEquals((int)(initialSize - 1), (int)this.getMap().size());
        BiMapRemoveTester.assertEquals((int)(initialSize - 1), (int)this.getMap().inverse().size());
    }
}

