/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.testers.AbstractListTester;
import com.google.common.collect.testing.testers.Platform;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class ListRemoveAtIndexTester<E>
extends AbstractListTester<E> {
    @ListFeature.Require(absent={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAtIndex_unsupported() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.getList().remove(0));
        this.expectUnchanged();
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    public void testRemoveAtIndex_negative() {
        ReflectionFreeAssertThrows.assertThrows(IndexOutOfBoundsException.class, () -> this.getList().remove(-1));
        this.expectUnchanged();
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    public void testRemoveAtIndex_tooLarge() {
        ReflectionFreeAssertThrows.assertThrows(IndexOutOfBoundsException.class, () -> this.getList().remove(this.getNumElements()));
        this.expectUnchanged();
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAtIndex_first() {
        this.runRemoveTest(0);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testRemoveAtIndex_middle() {
        this.runRemoveTest(this.getNumElements() / 2);
    }

    @CollectionFeature.Require(value={CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAtIndexConcurrentWithIteration() {
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, () -> {
            Iterator iterator = this.collection.iterator();
            this.getList().remove(this.getNumElements() / 2);
            iterator.next();
        });
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAtIndex_last() {
        this.runRemoveTest(this.getNumElements() - 1);
    }

    private void runRemoveTest(int index) {
        ListRemoveAtIndexTester.assertEquals((String)Platform.format("remove(%d) should return the element at index %d", index, index), this.getList().get(index), this.getList().remove(index));
        List expected = Helpers.copyToList(this.createSamplesArray());
        expected.remove(index);
        this.expectContents(expected);
    }
}

