/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.java.CommandLineOptions;
import com.google.googlejavaformat.java.CommandLineOptionsParser;
import com.google.googlejavaformat.java.FormatFileCallable;
import com.google.googlejavaformat.java.GoogleJavaFormatVersion;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.UsageException;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class Main {
    private static final int MAX_THREADS = 20;
    private static final String STDIN_FILENAME = "<stdin>";
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;
    private final InputStream inStream;

    static String versionString() {
        return "google-java-format: Version " + GoogleJavaFormatVersion.version();
    }

    public Main(PrintWriter outWriter, PrintWriter errWriter, InputStream inStream) {
        this.outWriter = outWriter;
        this.errWriter = errWriter;
        this.inStream = inStream;
    }

    public static void main(String ... args) {
        int result = Main.main(System.in, System.out, System.err, args);
        System.exit(result);
    }

    static int main(InputStream in, PrintStream out, PrintStream err, String ... args) {
        PrintWriter outWriter = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
        PrintWriter errWriter = new PrintWriter(new OutputStreamWriter((OutputStream)err, StandardCharsets.UTF_8));
        return Main.main(in, outWriter, errWriter, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int main(InputStream in, PrintWriter out, PrintWriter err, String ... args) {
        try {
            Main formatter = new Main(out, err, in);
            int n = formatter.format(args);
            return n;
        }
        catch (UsageException e) {
            err.print(e.getMessage());
            int n = 2;
            return n;
        }
        finally {
            err.flush();
            out.flush();
        }
    }

    public int format(String ... args) throws UsageException {
        CommandLineOptions parameters = Main.processArgs(args);
        if (parameters.version()) {
            this.errWriter.println(Main.versionString());
            return 0;
        }
        if (parameters.help()) {
            throw new UsageException();
        }
        JavaFormatterOptions options = JavaFormatterOptions.builder().style(parameters.aosp() ? JavaFormatterOptions.Style.AOSP : JavaFormatterOptions.Style.GOOGLE).formatJavadoc(parameters.formatJavadoc()).build();
        if (parameters.stdin()) {
            return this.formatStdin(parameters, options);
        }
        return this.formatFiles(parameters, options);
    }

    private int formatFiles(CommandLineOptions parameters, JavaFormatterOptions options) {
        int numThreads = Math.min(20, parameters.files().size());
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        ExecutorCompletionService<FormatFileCallable.Result> cs = new ExecutorCompletionService<FormatFileCallable.Result>(executorService);
        boolean allOk = true;
        int files = 0;
        for (String fileName : parameters.files()) {
            if (!fileName.endsWith(".java")) {
                this.errWriter.println("Skipping non-Java file: " + fileName);
                continue;
            }
            Path path = Paths.get(fileName, new String[0]);
            try {
                String input = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                cs.submit(new FormatFileCallable(parameters, path, input, options));
                ++files;
            }
            catch (IOException e) {
                this.errWriter.println(fileName + ": could not read file: " + e.getMessage());
                allOk = false;
            }
        }
        ArrayList<FormatFileCallable.Result> results = new ArrayList<FormatFileCallable.Result>();
        while (files > 0) {
            try {
                --files;
                results.add((FormatFileCallable.Result)cs.take().get());
            }
            catch (InterruptedException e) {
                this.errWriter.println(e.getMessage());
                allOk = false;
            }
            catch (ExecutionException e) {
                this.errWriter.println("error: " + e.getCause().getMessage());
                e.getCause().printStackTrace(this.errWriter);
                allOk = false;
            }
        }
        Collections.sort(results, Comparator.comparing(FormatFileCallable.Result::path));
        for (FormatFileCallable.Result result : results) {
            Path path = result.path();
            if (result.exception() != null) {
                for (FormatterDiagnostic diagnostic : result.exception().diagnostics()) {
                    this.errWriter.println(path + ":" + diagnostic);
                }
                allOk = false;
                continue;
            }
            String formatted = result.output();
            boolean changed = result.changed();
            if (changed && parameters.setExitIfChanged()) {
                allOk = false;
            }
            if (parameters.inPlace()) {
                if (!changed) continue;
                try {
                    Files.write(path, formatted.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException e) {
                    this.errWriter.println(path + ": could not write file: " + e.getMessage());
                    allOk = false;
                }
                continue;
            }
            if (parameters.dryRun()) {
                if (!changed) continue;
                this.outWriter.println(path);
                continue;
            }
            this.outWriter.write(formatted);
        }
        if (!MoreExecutors.shutdownAndAwaitTermination((ExecutorService)executorService, (Duration)Duration.ofSeconds(5L))) {
            this.errWriter.println("Failed to shut down ExecutorService");
            allOk = false;
        }
        return allOk ? 0 : 1;
    }

    private int formatStdin(CommandLineOptions parameters, JavaFormatterOptions options) {
        String input;
        try {
            input = new String(ByteStreams.toByteArray((InputStream)this.inStream), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        String stdinFilename = parameters.assumeFilename().orElse(STDIN_FILENAME);
        boolean ok = true;
        FormatFileCallable.Result result = new FormatFileCallable(parameters, null, input, options).call();
        if (result.exception() != null) {
            for (FormatterDiagnostic diagnostic : result.exception().diagnostics()) {
                this.errWriter.println(stdinFilename + ":" + diagnostic);
            }
            ok = false;
        } else {
            String output = result.output();
            boolean changed = result.changed();
            if (changed && parameters.setExitIfChanged()) {
                ok = false;
            }
            if (parameters.dryRun()) {
                if (changed) {
                    this.outWriter.println(stdinFilename);
                }
            } else {
                this.outWriter.write(output);
            }
        }
        return ok ? 0 : 1;
    }

    public static CommandLineOptions processArgs(String ... args) throws UsageException {
        CommandLineOptions parameters;
        try {
            parameters = CommandLineOptionsParser.parse(Arrays.asList(args));
        }
        catch (IllegalArgumentException e) {
            throw new UsageException(e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new UsageException(t.getMessage());
        }
        int filesToFormat = parameters.files().size();
        if (parameters.stdin()) {
            ++filesToFormat;
        }
        if (parameters.inPlace() && parameters.files().isEmpty()) {
            throw new UsageException("in-place formatting was requested but no files were provided");
        }
        if (parameters.isSelection() && filesToFormat != 1) {
            throw new UsageException("partial formatting is only support for a single file");
        }
        if (parameters.offsets().size() != parameters.lengths().size()) {
            throw new UsageException("-offsets and -lengths flags must be provided in matching pairs");
        }
        if (filesToFormat <= 0 && !parameters.version() && !parameters.help()) {
            throw new UsageException("no files were provided");
        }
        if (parameters.stdin() && !parameters.files().isEmpty()) {
            throw new UsageException("cannot format from standard input and files simultaneously");
        }
        if (parameters.assumeFilename().isPresent() && !parameters.stdin()) {
            throw new UsageException("--assume-filename is only supported when formatting standard input");
        }
        if (parameters.dryRun() && parameters.inPlace()) {
            throw new UsageException("cannot use --dry-run and --in-place at the same time");
        }
        return parameters;
    }
}

