/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2ShapeIndex;
import com.google.common.primitives.UnsignedLongs;
import java.util.List;

@GwtCompatible
public final class S2Iterator<T extends Entry> {
    private final List<T> entries;
    private final Function<S2CellId, Integer> seekFunction;
    protected int pos;

    static <T extends Entry> S2Iterator<T> create(List<T> entries) {
        return new S2Iterator<T>(entries);
    }

    static <T extends Entry> S2Iterator<T> create(List<T> entries, Function<S2CellId, Integer> seekFunction) {
        return new S2Iterator<T>(entries, seekFunction);
    }

    static <T extends Entry> S2Iterator<T> copy(S2Iterator<T> it) {
        S2Iterator<T> copy = new S2Iterator<T>(it.entries, it.seekFunction);
        copy.pos = it.pos;
        return copy;
    }

    protected S2Iterator(List<T> entries) {
        this.entries = entries;
        this.seekFunction = target -> {
            int start = 0;
            int end = entries.size() - 1;
            while (start <= end) {
                int mid = (start + end) / 2;
                long id = ((Entry)entries.get(mid)).id();
                int result = UnsignedLongs.compare((long)id, (long)target.id());
                if (result > 0) {
                    end = mid - 1;
                    continue;
                }
                if (result < 0) {
                    start = mid + 1;
                    continue;
                }
                if (start != mid) {
                    end = mid;
                    continue;
                }
                return mid;
            }
            return start;
        };
    }

    protected S2Iterator(List<T> entries, Function<S2CellId, Integer> seekFunction) {
        this.entries = entries;
        this.seekFunction = seekFunction;
    }

    public S2Iterator<T> copy() {
        S2Iterator<T> it = new S2Iterator<T>(this.entries, this.seekFunction);
        it.pos = this.pos;
        return it;
    }

    public void restart() {
        this.pos = 0;
    }

    public int compareTo(S2CellId cellId) {
        return UnsignedLongs.compare((long)this.entry().id(), (long)cellId.id());
    }

    public boolean equals(Object o) {
        return o instanceof S2Iterator && this.equalIterators((S2Iterator)o);
    }

    public int hashCode() {
        return 31 * this.pos + this.entries.hashCode();
    }

    public <T extends Entry> boolean equalIterators(S2Iterator<T> it) {
        return this.entries == it.entries && this.pos == it.pos;
    }

    public S2CellId id() {
        return new S2CellId(this.entry().id());
    }

    public T entry() {
        return (T)((Entry)this.entries.get(this.pos));
    }

    public S2Point center() {
        return this.id().toPoint();
    }

    public void next() {
        if (this.pos < this.entries.size()) {
            ++this.pos;
        }
    }

    public void prev() {
        if (this.pos > 0) {
            --this.pos;
        }
    }

    public boolean done() {
        return this.pos == this.entries.size();
    }

    public boolean atBegin() {
        return this.pos == 0;
    }

    public void seek(S2CellId target) {
        this.pos = (Integer)this.seekFunction.apply((Object)target);
    }

    public void seekForward(S2CellId target) {
        if (!this.done() && this.compareTo(target) < 0) {
            int tmpPos = this.pos;
            this.seek(target);
            this.pos = Math.max(this.pos, tmpPos + 1);
        }
    }

    public void finish() {
        this.pos = this.entries.size();
    }

    public boolean locate(S2Point targetPoint) {
        S2CellId target = S2CellId.fromPoint(targetPoint);
        this.seek(target);
        if (!this.done() && this.id().rangeMin().lessOrEquals(target)) {
            return true;
        }
        if (!this.atBegin()) {
            this.prev();
            if (this.id().rangeMax().greaterOrEquals(target)) {
                return true;
            }
        }
        return false;
    }

    public S2ShapeIndex.CellRelation locate(S2CellId target) {
        this.seek(target.rangeMin());
        if (!this.done()) {
            if (this.id().greaterOrEquals(target) && this.id().rangeMin().lessOrEquals(target)) {
                return S2ShapeIndex.CellRelation.INDEXED;
            }
            if (this.id().lessOrEquals(target.rangeMax())) {
                return S2ShapeIndex.CellRelation.SUBDIVIDED;
            }
        }
        if (!this.atBegin()) {
            this.prev();
            if (this.id().rangeMax().greaterOrEquals(target)) {
                return S2ShapeIndex.CellRelation.INDEXED;
            }
        }
        return S2ShapeIndex.CellRelation.DISJOINT;
    }

    public void position(S2Iterator<T> it) {
        this.pos = it.pos;
    }

    public static interface Entry {
        public long id();
    }
}

