/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.GwtCompatible;
import com.google.common.geometry.EncodedInts;
import java.io.IOException;
import java.io.OutputStream;

@GwtCompatible
public final class LittleEndianOutput {
    private final OutputStream output;

    public LittleEndianOutput(OutputStream output) {
        this.output = output;
    }

    public void writeByte(byte value) throws IOException {
        this.output.write(value);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.output.write(bytes);
    }

    public void writeInt(int value) throws IOException {
        this.output.write(value & 0xFF);
        this.output.write(value >> 8 & 0xFF);
        this.output.write(value >> 16 & 0xFF);
        this.output.write(value >> 24 & 0xFF);
    }

    public void writeLong(long value) throws IOException {
        this.output.write((int)(value & 0xFFL));
        this.output.write((int)(value >> 8) & 0xFF);
        this.output.write((int)(value >> 16) & 0xFF);
        this.output.write((int)(value >> 24) & 0xFF);
        this.output.write((int)(value >> 32) & 0xFF);
        this.output.write((int)(value >> 40) & 0xFF);
        this.output.write((int)(value >> 48) & 0xFF);
        this.output.write((int)(value >> 56) & 0xFF);
    }

    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeVarint32(int value) throws IOException {
        this.writeVarint64(value);
    }

    public void writeVarint64(long value) throws IOException {
        EncodedInts.writeVarint64(this.output, value);
    }

    public void close() throws IOException {
        this.output.close();
    }
}

