/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.maps;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.OutOfLineContent;
import com.google.gdata.data.extensions.CustomProperty;
import com.google.gdata.data.extensions.Deleted;
import com.google.gdata.data.extensions.FeedLink;
import com.google.gdata.data.extensions.ResourceId;
import com.google.gdata.util.common.xml.XmlNamespace;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/maps/2008#map")
public class MapEntry
extends BaseEntry<MapEntry> {
    public static final String KIND = "http://schemas.google.com/maps/2008#map";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/maps/2008#map");

    public MapEntry() {
        this.getCategories().add(CATEGORY);
    }

    public MapEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(MapEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(MapEntry.class, CustomProperty.getDefaultDescription(false, true));
        extProfile.declare(MapEntry.class, new ExtensionDescription(Deleted.class, new XmlNamespace("gd", "http://schemas.google.com/g/2005"), "deleted", false, false, false));
        extProfile.declare(MapEntry.class, new ExtensionDescription(FeedLink.class, new XmlNamespace("gd", "http://schemas.google.com/g/2005"), "feedLink", false, false, false));
        new FeedLink().declareExtensions(extProfile);
        extProfile.declare(MapEntry.class, ResourceId.class);
    }

    public List<CustomProperty> getCustomProperties() {
        return this.getRepeatingExtension(CustomProperty.class);
    }

    public void addCustomProperty(CustomProperty customProperty) {
        this.getCustomProperties().add(customProperty);
    }

    public boolean hasCustomProperties() {
        return this.hasRepeatingExtension(CustomProperty.class);
    }

    public Deleted getDeleted() {
        return this.getExtension(Deleted.class);
    }

    public void setDeleted(Deleted deleted) {
        if (deleted == null) {
            this.removeExtension(Deleted.class);
        } else {
            this.setExtension(deleted);
        }
    }

    public boolean hasDeleted() {
        return this.hasExtension(Deleted.class);
    }

    public FeedLink getFeedLink() {
        return this.getExtension(FeedLink.class);
    }

    public void setFeedLink(FeedLink feedLink) {
        if (feedLink == null) {
            this.removeExtension(FeedLink.class);
        } else {
            this.setExtension(feedLink);
        }
    }

    public boolean hasFeedLink() {
        return this.hasExtension(FeedLink.class);
    }

    public ResourceId getResourceId() {
        return this.getExtension(ResourceId.class);
    }

    public void setResourceId(ResourceId resourceId) {
        if (resourceId == null) {
            this.removeExtension(ResourceId.class);
        } else {
            this.setExtension(resourceId);
        }
    }

    public boolean hasResourceId() {
        return this.hasExtension(ResourceId.class);
    }

    public Link getAtomAlternateLink() {
        return this.getLink("alternate", ILink.Type.ATOM);
    }

    public Link getAtomFeedLink() {
        return this.getLink("http://schemas.google.com/g/2005#feed", ILink.Type.ATOM);
    }

    @Override
    protected void validate() {
    }

    public String toString() {
        return "{MapEntry " + super.toString() + "}";
    }

    public URL getFeatureFeedUrl() {
        if (this.getContent() instanceof OutOfLineContent) {
            try {
                return new URL(((OutOfLineContent)this.getContent()).getUri());
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }
}

