/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.webmastertools;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.data.webmastertools.CrawlIssuesFeed;
import com.google.gdata.data.webmastertools.KeywordsFeed;
import com.google.gdata.data.webmastertools.MessagesFeed;
import com.google.gdata.data.webmastertools.SitemapsFeed;
import com.google.gdata.data.webmastertools.SitesFeed;
import com.google.gdata.util.Version;
import com.google.gdata.util.VersionRegistry;

public class WebmasterToolsService
extends GoogleService {
    public static final String WEBMASTERTOOLS_SERVICE = "sitemaps";
    public static final String WEBMASTERTOOLS_SERVICE_VERSION = "GWebmasterTools-Java/" + WebmasterToolsService.class.getPackage().getImplementationVersion();
    public static final Version DEFAULT_VERSION = Service.initServiceVersion(WebmasterToolsService.class, Versions.V2);

    public WebmasterToolsService(String applicationName) {
        super(WEBMASTERTOOLS_SERVICE, applicationName);
        this.declareExtensions();
    }

    public WebmasterToolsService(String applicationName, Service.GDataRequestFactory requestFactory, AuthTokenFactory authTokenFactory) {
        super(applicationName, requestFactory, authTokenFactory);
        this.declareExtensions();
    }

    public WebmasterToolsService(String applicationName, String protocol, String domainName) {
        super(WEBMASTERTOOLS_SERVICE, applicationName, protocol, domainName);
        this.declareExtensions();
    }

    public String getServiceVersion() {
        return WEBMASTERTOOLS_SERVICE_VERSION + " " + super.getServiceVersion();
    }

    public static Version getVersion() {
        return VersionRegistry.get().getVersion(WebmasterToolsService.class);
    }

    private void declareExtensions() {
        new CrawlIssuesFeed().declareExtensions(this.extProfile);
        new KeywordsFeed().declareExtensions(this.extProfile);
        new MessagesFeed().declareExtensions(this.extProfile);
        new SitemapsFeed().declareExtensions(this.extProfile);
        new SitesFeed().declareExtensions(this.extProfile);
    }

    public static final class Versions {
        public static final Version V1 = new Version(WebmasterToolsService.class, "1.0", Service.Versions.V1);
        public static final Version V2 = new Version(WebmasterToolsService.class, "2.0", Service.Versions.V2);
    }
}

