/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.sites;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.Service;
import com.google.gdata.client.media.MediaService;
import com.google.gdata.data.batch.BatchUtils;
import com.google.gdata.data.sites.ActivityFeed;
import com.google.gdata.data.sites.AnnouncementEntry;
import com.google.gdata.data.sites.AnnouncementsPageEntry;
import com.google.gdata.data.sites.AttachmentEntry;
import com.google.gdata.data.sites.CommentEntry;
import com.google.gdata.data.sites.ContentFeed;
import com.google.gdata.data.sites.CreationActivityEntry;
import com.google.gdata.data.sites.DeletionActivityEntry;
import com.google.gdata.data.sites.EditActivityEntry;
import com.google.gdata.data.sites.FileCabinetPageEntry;
import com.google.gdata.data.sites.ListItemEntry;
import com.google.gdata.data.sites.ListPageEntry;
import com.google.gdata.data.sites.MoveActivityEntry;
import com.google.gdata.data.sites.RecoveryActivityEntry;
import com.google.gdata.data.sites.RevisionFeed;
import com.google.gdata.data.sites.WebAttachmentEntry;
import com.google.gdata.data.sites.WebPageEntry;
import com.google.gdata.util.Version;
import com.google.gdata.util.VersionRegistry;

public class SitesService
extends MediaService {
    public static final String SITES_SERVICE = "jotspot";
    public static final String SITES_SERVICE_VERSION = "GSites-Java/" + SitesService.class.getPackage().getImplementationVersion();
    public static final Version DEFAULT_VERSION = Service.initServiceVersion(SitesService.class, Versions.V1);

    public SitesService(String applicationName) {
        super(SITES_SERVICE, applicationName);
        this.declareExtensions();
    }

    public SitesService(String applicationName, Service.GDataRequestFactory requestFactory, AuthTokenFactory authTokenFactory) {
        super(applicationName, requestFactory, authTokenFactory);
        this.declareExtensions();
    }

    public SitesService(String applicationName, String protocol, String domainName) {
        super(SITES_SERVICE, applicationName, protocol, domainName);
        this.declareExtensions();
    }

    public String getServiceVersion() {
        return SITES_SERVICE_VERSION + " " + super.getServiceVersion();
    }

    public static Version getVersion() {
        return VersionRegistry.get().getVersion(SitesService.class);
    }

    private void declareExtensions() {
        this.extProfile.setAutoExtending(true);
        new ActivityFeed().declareExtensions(this.extProfile);
        new AnnouncementEntry().declareExtensions(this.extProfile);
        new AnnouncementsPageEntry().declareExtensions(this.extProfile);
        new AttachmentEntry().declareExtensions(this.extProfile);
        new CommentEntry().declareExtensions(this.extProfile);
        new ContentFeed().declareExtensions(this.extProfile);
        new CreationActivityEntry().declareExtensions(this.extProfile);
        new DeletionActivityEntry().declareExtensions(this.extProfile);
        new EditActivityEntry().declareExtensions(this.extProfile);
        new FileCabinetPageEntry().declareExtensions(this.extProfile);
        new ListItemEntry().declareExtensions(this.extProfile);
        new ListPageEntry().declareExtensions(this.extProfile);
        new MoveActivityEntry().declareExtensions(this.extProfile);
        new RecoveryActivityEntry().declareExtensions(this.extProfile);
        new RevisionFeed().declareExtensions(this.extProfile);
        new WebAttachmentEntry().declareExtensions(this.extProfile);
        new WebPageEntry().declareExtensions(this.extProfile);
        BatchUtils.declareExtensions(this.extProfile);
    }

    public static final class Versions {
        public static final Version V1 = new Version(SitesService.class, "1.0", Service.Versions.V2);

        private Versions() {
        }
    }
}

