/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.api.Status;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.StorageTaskScheduler;
import com.google.firebase.storage.internal.ExponentialBackoffSender;
import com.google.firebase.storage.network.GetNetworkRequest;
import com.google.firebase.storage.network.NetworkRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    static final int PREFERRED_CHUNK_SIZE = 262144;
    private static final String TAG = "FileDownloadTask";
    private final Uri mDestinationFile;
    private long mBytesDownloaded;
    private StorageReference mStorageRef;
    private ExponentialBackoffSender mSender;
    private long mTotalBytes = -1L;
    private String mETagVerification = null;
    private volatile Exception mException = null;
    private long mResumeOffset = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageRef, @NonNull Uri destinationFile) {
        this.mStorageRef = storageRef;
        this.mDestinationFile = destinationFile;
        FirebaseStorage storage = this.mStorageRef.getStorage();
        this.mSender = new ExponentialBackoffSender(storage.getApp().getApplicationContext(), storage.getAuthProvider(), storage.getAppCheckProvider(), storage.getMaxDownloadRetryTimeMillis());
    }

    long getDownloadedSizeInBytes() {
        return this.mBytesDownloaded;
    }

    long getTotalBytes() {
        return this.mTotalBytes;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.mStorageRef;
    }

    @Override
    protected void schedule() {
        StorageTaskScheduler.getInstance().scheduleDownload(this.getRunnable());
    }

    @Override
    @NonNull
    TaskSnapshot snapStateImpl() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.mException, this.mResultCode)), this.mBytesDownloaded + this.mResumeOffset);
    }

    private int fillBuffer(InputStream stream, byte[] data) {
        int offset;
        boolean readData = false;
        try {
            int count;
            for (offset = 0; offset != data.length && (count = stream.read(data, offset, data.length - offset)) != -1; offset += count) {
                readData = true;
            }
        }
        catch (IOException e) {
            this.mException = e;
        }
        return readData ? offset : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processResponse(NetworkRequest request) throws IOException {
        boolean success = true;
        InputStream stream = request.getStream();
        if (stream != null) {
            FileOutputStream output;
            File outputFile = new File(this.mDestinationFile.getPath());
            if (!outputFile.exists()) {
                if (this.mResumeOffset > 0L) {
                    throw new IOException("The file to download to has been deleted.");
                }
                boolean created = outputFile.createNewFile();
                if (!created) {
                    Log.w((String)TAG, (String)("unable to create file:" + outputFile.getAbsolutePath()));
                }
            }
            if (this.mResumeOffset > 0L) {
                Log.d((String)TAG, (String)("Resuming download file " + outputFile.getAbsolutePath() + " at " + this.mResumeOffset));
                output = new FileOutputStream(outputFile, true);
            } else {
                output = new FileOutputStream(outputFile);
            }
            try {
                int count;
                byte[] data = new byte[262144];
                while (success && (count = this.fillBuffer(stream, data)) != -1) {
                    ((OutputStream)output).write(data, 0, count);
                    this.mBytesDownloaded += (long)count;
                    if (this.mException != null) {
                        Log.d((String)TAG, (String)"Exception occurred during file download. Retrying.", (Throwable)this.mException);
                        this.mException = null;
                        success = false;
                    }
                    if (this.tryChangeState(4, false)) continue;
                    success = false;
                }
            }
            finally {
                output.flush();
                ((OutputStream)output).close();
                stream.close();
            }
        } else {
            this.mException = new IllegalStateException("Unable to open Firebase Storage stream.");
            success = false;
        }
        return success;
    }

    @Override
    void run() {
        if (this.mException != null) {
            this.tryChangeState(64, false);
            return;
        }
        if (!this.tryChangeState(4, false)) {
            return;
        }
        do {
            boolean success;
            this.mBytesDownloaded = 0L;
            this.mException = null;
            this.mSender.reset();
            GetNetworkRequest request = new GetNetworkRequest(this.mStorageRef.getStorageReferenceUri(), this.mStorageRef.getApp(), this.mResumeOffset);
            this.mSender.sendWithExponentialBackoff(request, false);
            this.mResultCode = request.getResultCode();
            this.mException = request.getException() != null ? request.getException() : this.mException;
            boolean bl = success = this.isValidHttpResponseCode(this.mResultCode) && this.mException == null && this.getInternalState() == 4;
            if (success) {
                this.mTotalBytes = (long)request.getResultingContentLength() + this.mResumeOffset;
                String newEtag = request.getResultString("ETag");
                if (!TextUtils.isEmpty((CharSequence)newEtag) && this.mETagVerification != null && !this.mETagVerification.equals(newEtag)) {
                    Log.w((String)TAG, (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.mResumeOffset = 0L;
                    this.mETagVerification = null;
                    request.performRequestEnd();
                    this.schedule();
                    return;
                }
                this.mETagVerification = newEtag;
                try {
                    success = this.processResponse(request);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Exception occurred during file write.  Aborting.", (Throwable)e);
                    this.mException = e;
                }
            }
            request.performRequestEnd();
            boolean bl2 = success = success && this.mException == null && this.getInternalState() == 4;
            if (success) {
                this.tryChangeState(128, false);
                return;
            }
            File outputFile = new File(this.mDestinationFile.getPath());
            this.mResumeOffset = outputFile.exists() ? outputFile.length() : 0L;
            if (this.getInternalState() == 8) {
                this.tryChangeState(16, false);
                return;
            }
            if (this.getInternalState() != 32) continue;
            if (!this.tryChangeState(256, false)) {
                Log.w((String)TAG, (String)("Unable to change download task to final state from " + this.getInternalState()));
            }
            return;
        } while (this.mBytesDownloaded > 0L);
        this.tryChangeState(64, false);
    }

    @Override
    protected void onCanceled() {
        this.mSender.cancel();
        this.mException = StorageException.fromErrorStatus(Status.RESULT_CANCELED);
    }

    private boolean isValidHttpResponseCode(int code) {
        return code == 308 || code >= 200 && code < 300;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long mBytesDownloaded;

        TaskSnapshot(Exception error, long bytesDownloaded) {
            super(FileDownloadTask.this, error);
            this.mBytesDownloaded = bytesDownloaded;
        }

        public long getBytesTransferred() {
            return this.mBytesDownloaded;
        }

        public long getTotalByteCount() {
            return FileDownloadTask.this.getTotalBytes();
        }
    }
}

