/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.storage.DeleteStorageTask;
import com.google.firebase.storage.FileDownloadTask;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.GetDownloadUrlTask;
import com.google.firebase.storage.GetMetadataTask;
import com.google.firebase.storage.ListResult;
import com.google.firebase.storage.ListTask;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageTaskManager;
import com.google.firebase.storage.StorageTaskScheduler;
import com.google.firebase.storage.StreamDownloadTask;
import com.google.firebase.storage.UpdateMetadataTask;
import com.google.firebase.storage.UploadTask;
import com.google.firebase.storage.internal.Slashes;
import com.google.firebase.storage.internal.StorageReferenceUri;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class StorageReference
implements Comparable<StorageReference> {
    private static final String TAG = "StorageReference";
    private final Uri mStorageUri;
    private final FirebaseStorage mFirebaseStorage;

    StorageReference(@NonNull Uri storageUri, @NonNull FirebaseStorage firebaseStorage) {
        Preconditions.checkArgument((storageUri != null ? 1 : 0) != 0, (Object)"storageUri cannot be null");
        Preconditions.checkArgument((firebaseStorage != null ? 1 : 0) != 0, (Object)"FirebaseApp cannot be null");
        this.mStorageUri = storageUri;
        this.mFirebaseStorage = firebaseStorage;
    }

    @NonNull
    public StorageReference child(@NonNull String pathString) {
        Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)pathString) ? 1 : 0) != 0, (Object)"childName cannot be null or empty");
        pathString = Slashes.normalizeSlashes(pathString);
        Uri child = this.mStorageUri.buildUpon().appendEncodedPath(Slashes.preserveSlashEncode(pathString)).build();
        return new StorageReference(child, this.mFirebaseStorage);
    }

    @Nullable
    public StorageReference getParent() {
        String path = this.mStorageUri.getPath();
        if (TextUtils.isEmpty((CharSequence)path) || path.equals("/")) {
            return null;
        }
        int childIndex = path.lastIndexOf(47);
        path = childIndex == -1 ? "/" : path.substring(0, childIndex);
        Uri child = this.mStorageUri.buildUpon().path(path).build();
        return new StorageReference(child, this.mFirebaseStorage);
    }

    @NonNull
    public StorageReference getRoot() {
        Uri child = this.mStorageUri.buildUpon().path("").build();
        return new StorageReference(child, this.mFirebaseStorage);
    }

    @NonNull
    public String getName() {
        String path = this.mStorageUri.getPath();
        assert (path != null);
        int lastIndex = path.lastIndexOf(47);
        if (lastIndex != -1) {
            return path.substring(lastIndex + 1);
        }
        return path;
    }

    @NonNull
    public String getPath() {
        String path = this.mStorageUri.getPath();
        assert (path != null);
        return path;
    }

    @NonNull
    public String getBucket() {
        return this.mStorageUri.getAuthority();
    }

    @NonNull
    public FirebaseStorage getStorage() {
        return this.mFirebaseStorage;
    }

    @NonNull
    FirebaseApp getApp() {
        return this.getStorage().getApp();
    }

    @NonNull
    public UploadTask putBytes(@NonNull byte[] bytes) {
        Preconditions.checkArgument((bytes != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        UploadTask task = new UploadTask(this, null, bytes);
        task.queue();
        return task;
    }

    @NonNull
    public UploadTask putBytes(@NonNull byte[] bytes, @NonNull StorageMetadata metadata) {
        Preconditions.checkArgument((bytes != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask task = new UploadTask(this, metadata, bytes);
        task.queue();
        return task;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        UploadTask task = new UploadTask(this, null, uri, null);
        task.queue();
        return task;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri, @NonNull StorageMetadata metadata) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask task = new UploadTask(this, metadata, uri, null);
        task.queue();
        return task;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri, @Nullable StorageMetadata metadata, @Nullable Uri existingUploadUri) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask task = new UploadTask(this, metadata, uri, existingUploadUri);
        task.queue();
        return task;
    }

    @NonNull
    public UploadTask putStream(@NonNull InputStream stream) {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        UploadTask task = new UploadTask(this, null, stream);
        task.queue();
        return task;
    }

    @NonNull
    public UploadTask putStream(@NonNull InputStream stream, @NonNull StorageMetadata metadata) {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask task = new UploadTask(this, metadata, stream);
        task.queue();
        return task;
    }

    @NonNull
    public List<UploadTask> getActiveUploadTasks() {
        return StorageTaskManager.getInstance().getUploadTasksUnder(this);
    }

    @NonNull
    public List<FileDownloadTask> getActiveDownloadTasks() {
        return StorageTaskManager.getInstance().getDownloadTasksUnder(this);
    }

    @NonNull
    public Task<StorageMetadata> getMetadata() {
        TaskCompletionSource pendingResult = new TaskCompletionSource();
        StorageTaskScheduler.getInstance().scheduleCommand(new GetMetadataTask(this, (TaskCompletionSource<StorageMetadata>)pendingResult));
        return pendingResult.getTask();
    }

    @NonNull
    public Task<Uri> getDownloadUrl() {
        TaskCompletionSource pendingResult = new TaskCompletionSource();
        StorageTaskScheduler.getInstance().scheduleCommand(new GetDownloadUrlTask(this, (TaskCompletionSource<Uri>)pendingResult));
        return pendingResult.getTask();
    }

    @NonNull
    public Task<StorageMetadata> updateMetadata(@NonNull StorageMetadata metadata) {
        Preconditions.checkNotNull((Object)metadata);
        TaskCompletionSource pendingResult = new TaskCompletionSource();
        StorageTaskScheduler.getInstance().scheduleCommand(new UpdateMetadataTask(this, (TaskCompletionSource<StorageMetadata>)pendingResult, metadata));
        return pendingResult.getTask();
    }

    @NonNull
    public Task<byte[]> getBytes(final long maxDownloadSizeBytes) {
        final TaskCompletionSource pendingResult = new TaskCompletionSource();
        StreamDownloadTask task = new StreamDownloadTask(this);
        task.setStreamProcessor(new StreamDownloadTask.StreamProcessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doInBackground(StreamDownloadTask.TaskSnapshot state, InputStream stream) throws IOException {
                try {
                    int nRead;
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    int totalRead = 0;
                    byte[] data = new byte[16384];
                    while ((nRead = stream.read(data, 0, data.length)) != -1) {
                        if ((long)(totalRead += nRead) > maxDownloadSizeBytes) {
                            Log.e((String)StorageReference.TAG, (String)"the maximum allowed buffer size was exceeded.");
                            throw new IndexOutOfBoundsException("the maximum allowed buffer size was exceeded.");
                        }
                        buffer.write(data, 0, nRead);
                    }
                    buffer.flush();
                    pendingResult.setResult((Object)buffer.toByteArray());
                }
                finally {
                    stream.close();
                }
            }
        }).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<StreamDownloadTask.TaskSnapshot>(){

            public void onSuccess(StreamDownloadTask.TaskSnapshot state) {
                if (!pendingResult.getTask().isComplete()) {
                    Log.e((String)StorageReference.TAG, (String)"getBytes 'succeeded', but failed to set a Result.");
                    pendingResult.setException((Exception)((Object)StorageException.fromErrorStatus(Status.RESULT_INTERNAL_ERROR)));
                }
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                StorageException se = StorageException.fromExceptionAndHttpCode(e, 0);
                assert (se != null);
                pendingResult.setException((Exception)((Object)se));
            }
        });
        task.queue();
        return pendingResult.getTask();
    }

    @NonNull
    public FileDownloadTask getFile(@NonNull Uri destinationUri) {
        FileDownloadTask task = new FileDownloadTask(this, destinationUri);
        task.queue();
        return task;
    }

    @NonNull
    public FileDownloadTask getFile(@NonNull File destinationFile) {
        return this.getFile(Uri.fromFile((File)destinationFile));
    }

    @NonNull
    public StreamDownloadTask getStream() {
        StreamDownloadTask task = new StreamDownloadTask(this);
        task.queue();
        return task;
    }

    @NonNull
    public StreamDownloadTask getStream(@NonNull StreamDownloadTask.StreamProcessor processor) {
        StreamDownloadTask task = new StreamDownloadTask(this);
        task.setStreamProcessor(processor);
        task.queue();
        return task;
    }

    @NonNull
    public Task<Void> delete() {
        TaskCompletionSource pendingResult = new TaskCompletionSource();
        StorageTaskScheduler.getInstance().scheduleCommand(new DeleteStorageTask(this, (TaskCompletionSource<Void>)pendingResult));
        return pendingResult.getTask();
    }

    @NonNull
    public Task<ListResult> list(int maxResults) {
        Preconditions.checkArgument((maxResults > 0 ? 1 : 0) != 0, (Object)"maxResults must be greater than zero");
        Preconditions.checkArgument((maxResults <= 1000 ? 1 : 0) != 0, (Object)"maxResults must be at most 1000");
        return this.listHelper(maxResults, null);
    }

    @NonNull
    public Task<ListResult> list(int maxResults, @NonNull String pageToken) {
        Preconditions.checkArgument((maxResults > 0 ? 1 : 0) != 0, (Object)"maxResults must be greater than zero");
        Preconditions.checkArgument((maxResults <= 1000 ? 1 : 0) != 0, (Object)"maxResults must be at most 1000");
        Preconditions.checkArgument((pageToken != null ? 1 : 0) != 0, (Object)"pageToken must be non-null to resume a previous list() operation");
        return this.listHelper(maxResults, pageToken);
    }

    @NonNull
    public Task<ListResult> listAll() {
        final TaskCompletionSource pendingResult = new TaskCompletionSource();
        final ArrayList prefixes = new ArrayList();
        final ArrayList items = new ArrayList();
        final Executor executor = StorageTaskScheduler.getInstance().getCommandPoolExecutor();
        Task<ListResult> list = this.listHelper(null, null);
        Continuation<ListResult, Task<Void>> continuation = new Continuation<ListResult, Task<Void>>(){

            public Task<Void> then(@NonNull Task<ListResult> currentPage) {
                if (currentPage.isSuccessful()) {
                    ListResult result = (ListResult)currentPage.getResult();
                    prefixes.addAll(result.getPrefixes());
                    items.addAll(result.getItems());
                    if (result.getPageToken() != null) {
                        Task nextPage = StorageReference.this.listHelper(null, result.getPageToken());
                        nextPage.continueWithTask(executor, (Continuation)this);
                    } else {
                        pendingResult.setResult((Object)new ListResult(prefixes, items, null));
                    }
                } else {
                    pendingResult.setException(currentPage.getException());
                }
                return Tasks.forResult(null);
            }
        };
        list.continueWithTask(executor, (Continuation)continuation);
        return pendingResult.getTask();
    }

    private Task<ListResult> listHelper(@Nullable Integer maxResults, @Nullable String pageToken) {
        TaskCompletionSource pendingResult = new TaskCompletionSource();
        StorageTaskScheduler.getInstance().scheduleCommand(new ListTask(this, maxResults, pageToken, (TaskCompletionSource<ListResult>)pendingResult));
        return pendingResult.getTask();
    }

    @NonNull
    Uri getStorageUri() {
        return this.mStorageUri;
    }

    public String toString() {
        return "gs://" + this.mStorageUri.getAuthority() + this.mStorageUri.getEncodedPath();
    }

    public boolean equals(Object other) {
        if (!(other instanceof StorageReference)) {
            return false;
        }
        StorageReference otherStorage = (StorageReference)other;
        return otherStorage.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(@NonNull StorageReference other) {
        return this.mStorageUri.compareTo(other.mStorageUri);
    }

    @NonNull
    StorageReferenceUri getStorageReferenceUri() {
        return new StorageReferenceUri(this.mStorageUri, this.mFirebaseStorage.getEmulatorSettings());
    }
}

