/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.internal.ExponentialBackoffSender;
import com.google.firebase.storage.network.DeleteNetworkRequest;

class DeleteStorageTask
implements Runnable {
    private static final String TAG = "DeleteStorageTask";
    private StorageReference mStorageRef;
    private TaskCompletionSource<Void> mPendingResult;
    private ExponentialBackoffSender mSender;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public DeleteStorageTask(@NonNull StorageReference storageRef, @NonNull TaskCompletionSource<Void> pendingResult) {
        Preconditions.checkNotNull((Object)storageRef);
        Preconditions.checkNotNull(pendingResult);
        this.mStorageRef = storageRef;
        this.mPendingResult = pendingResult;
        FirebaseStorage storage = this.mStorageRef.getStorage();
        this.mSender = new ExponentialBackoffSender(storage.getApp().getApplicationContext(), storage.getAuthProvider(), storage.getAppCheckProvider(), storage.getMaxDownloadRetryTimeMillis());
    }

    @Override
    public void run() {
        DeleteNetworkRequest request = new DeleteNetworkRequest(this.mStorageRef.getStorageReferenceUri(), this.mStorageRef.getApp());
        this.mSender.sendWithExponentialBackoff(request);
        request.completeTask(this.mPendingResult, null);
    }
}

