/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.TaskListenerImpl$$Lambda$1;
import com.google.firebase.storage.TaskListenerImpl$$Lambda$2;
import com.google.firebase.storage.TaskListenerImpl$$Lambda$3;
import com.google.firebase.storage.internal.ActivityLifecycleListener;
import com.google.firebase.storage.internal.SmartHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;

@PublicApi
class TaskListenerImpl<TListenerType, TResult extends StorageTask.ProvideError> {
    private final Queue<TListenerType> mListenerQueue = new ConcurrentLinkedQueue<TListenerType>();
    private final HashMap<TListenerType, SmartHandler> mHandlerMap = new HashMap();
    private StorageTask<TResult> mTask;
    private int mTargetStates;
    private OnRaise<TListenerType, TResult> mOnRaise;

    @PublicApi
    public TaskListenerImpl(@NonNull StorageTask<TResult> task, int targetInternalStates, @NonNull OnRaise<TListenerType, TResult> onRaise) {
        this.mTask = task;
        this.mTargetStates = targetInternalStates;
        this.mOnRaise = onRaise;
    }

    public int getListenerCount() {
        return Math.max(this.mListenerQueue.size(), this.mHandlerMap.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublicApi
    public void addListener(@Nullable Activity activity, @Nullable Executor executor, @NonNull TListenerType listener) {
        SmartHandler handler;
        Preconditions.checkNotNull(listener);
        boolean shouldFire = false;
        Object object = this.mTask.getSyncObject();
        synchronized (object) {
            if ((this.mTask.getInternalState() & this.mTargetStates) != 0) {
                shouldFire = true;
            }
            this.mListenerQueue.add(listener);
            handler = new SmartHandler(executor);
            this.mHandlerMap.put(listener, handler);
            if (activity != null) {
                if (Build.VERSION.SDK_INT >= 17) {
                    Preconditions.checkArgument((!activity.isDestroyed() ? 1 : 0) != 0, (Object)"Activity is already destroyed!");
                }
                ActivityLifecycleListener.getInstance().runOnActivityStopped(activity, listener, TaskListenerImpl$$Lambda$1.lambdaFactory$(this, listener));
            }
        }
        if (shouldFire) {
            TResult snappedState = this.mTask.snapState();
            handler.callBack(TaskListenerImpl$$Lambda$2.lambdaFactory$(this, listener, snappedState));
        }
    }

    @PublicApi
    public void onInternalStateChanged() {
        if ((this.mTask.getInternalState() & this.mTargetStates) != 0) {
            TResult snappedState = this.mTask.snapState();
            Iterator iterator = this.mListenerQueue.iterator();
            while (iterator.hasNext()) {
                Object c;
                Object finalCallback = c = iterator.next();
                SmartHandler handler = this.mHandlerMap.get(c);
                if (handler == null) continue;
                handler.callBack(TaskListenerImpl$$Lambda$3.lambdaFactory$(this, finalCallback, snappedState));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublicApi
    public void removeListener(@NonNull TListenerType listener) {
        Preconditions.checkNotNull(listener);
        Object object = this.mTask.getSyncObject();
        synchronized (object) {
            this.mHandlerMap.remove(listener);
            this.mListenerQueue.remove(listener);
            ActivityLifecycleListener.getInstance().removeCookie(listener);
        }
    }

    static /* synthetic */ void lambda$onInternalStateChanged$2(TaskListenerImpl this_, Object finalCallback, StorageTask.ProvideError snappedState) {
        this_.mOnRaise.raise(finalCallback, snappedState);
    }

    static /* synthetic */ void lambda$addListener$1(TaskListenerImpl this_, Object listener, StorageTask.ProvideError snappedState) {
        this_.mOnRaise.raise(listener, snappedState);
    }

    static /* synthetic */ void lambda$addListener$0(TaskListenerImpl this_, Object listener) {
        this_.removeListener(listener);
    }

    static interface OnRaise<TListenerType, TResult> {
        public void raise(@NonNull TListenerType var1, @NonNull TResult var2);
    }
}

