/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.FirebaseException;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.storage.CancelException;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@PublicApi
public class StorageException
extends FirebaseException {
    private static final String TAG = "StorageException";
    @PublicApi
    public static final int ERROR_UNKNOWN = -13000;
    @PublicApi
    public static final int ERROR_OBJECT_NOT_FOUND = -13010;
    @PublicApi
    public static final int ERROR_BUCKET_NOT_FOUND = -13011;
    @PublicApi
    public static final int ERROR_PROJECT_NOT_FOUND = -13012;
    @PublicApi
    public static final int ERROR_QUOTA_EXCEEDED = -13013;
    @PublicApi
    public static final int ERROR_NOT_AUTHENTICATED = -13020;
    @PublicApi
    public static final int ERROR_NOT_AUTHORIZED = -13021;
    @PublicApi
    public static final int ERROR_RETRY_LIMIT_EXCEEDED = -13030;
    @PublicApi
    public static final int ERROR_INVALID_CHECKSUM = -13031;
    @PublicApi
    public static final int ERROR_CANCELED = -13040;
    private static final int NETWORK_UNAVAILABLE = -2;
    static IOException sCancelException = new IOException("The operation was canceled.");
    private final int mErrorCode;
    private final int mHttpResultCode;
    private String mDetailMessage;
    private Throwable mCause;

    StorageException(int errorCode, Throwable inner, int httpResultCode) {
        this.mDetailMessage = StorageException.getErrorMessageForCode(errorCode);
        this.mCause = inner;
        this.mErrorCode = errorCode;
        this.mHttpResultCode = httpResultCode;
        Log.e((String)TAG, (String)("StorageException has occurred.\n" + this.mDetailMessage + "\n Code: " + Integer.toString(this.mErrorCode) + " HttpResult: " + Integer.toString(this.mHttpResultCode)));
        if (this.mCause != null) {
            Log.e((String)TAG, (String)this.mCause.getMessage(), (Throwable)this.mCause);
        }
    }

    private static int calculateErrorCode(Status status) {
        if (status.isCanceled()) {
            return -13040;
        }
        if (status.equals((Object)Status.RESULT_TIMEOUT)) {
            return -13030;
        }
        return -13000;
    }

    private static int calculateErrorCode(@Nullable Throwable inner, int httpResultCode) {
        if (inner instanceof CancelException) {
            return -13040;
        }
        switch (httpResultCode) {
            case -2: {
                return -13030;
            }
            case 401: {
                return -13020;
            }
            case 403: {
                return -13021;
            }
            case 404: {
                return -13010;
            }
            case 409: {
                return -13031;
            }
        }
        return -13000;
    }

    @NonNull
    @PublicApi
    public static StorageException fromErrorStatus(@NonNull Status status) {
        Preconditions.checkNotNull((Object)status);
        Preconditions.checkArgument((!status.isSuccess() ? 1 : 0) != 0);
        return new StorageException(StorageException.calculateErrorCode(status), null, 0);
    }

    @Nullable
    @PublicApi
    public static StorageException fromExceptionAndHttpCode(@Nullable Throwable exception, int httpResultCode) {
        if (exception instanceof StorageException) {
            return (StorageException)((Object)exception);
        }
        if (StorageException.isResultSuccess(httpResultCode) && exception == null) {
            return null;
        }
        return new StorageException(StorageException.calculateErrorCode(exception, httpResultCode), exception, httpResultCode);
    }

    @NonNull
    @PublicApi
    public static StorageException fromException(@NonNull Throwable exception) {
        StorageException se = StorageException.fromExceptionAndHttpCode(exception, 0);
        assert (se != null);
        return se;
    }

    private static boolean isResultSuccess(int resultCode) {
        return resultCode == 0 || resultCode >= 200 && resultCode < 300;
    }

    static String getErrorMessageForCode(int errorCode) {
        switch (errorCode) {
            case -13000: {
                return "An unknown error occurred, please check the HTTP result code and inner exception for server response.";
            }
            case -13010: {
                return "Object does not exist at location.";
            }
            case -13011: {
                return "Bucket does not exist.";
            }
            case -13012: {
                return "Project does not exist.";
            }
            case -13013: {
                return "Quota for bucket exceeded, please view quota on www.firebase.google.com/storage.";
            }
            case -13020: {
                return "User is not authenticated, please authenticate using Firebase Authentication and try again.";
            }
            case -13021: {
                return "User does not have permission to access this object.";
            }
            case -13030: {
                return "The operation retry limit has been exceeded.";
            }
            case -13031: {
                return "Object has a checksum which does not match. Please retry the operation.";
            }
            case -13040: {
                return "The operation was cancelled.";
            }
        }
        return "An unknown error occurred, please check the HTTP result code and inner exception for server response.";
    }

    @PublicApi
    public String getMessage() {
        return this.mDetailMessage;
    }

    @PublicApi
    public synchronized Throwable getCause() {
        if (this.mCause == this) {
            return null;
        }
        return this.mCause;
    }

    @PublicApi
    public int getErrorCode() {
        return this.mErrorCode;
    }

    @PublicApi
    public int getHttpResultCode() {
        return this.mHttpResultCode;
    }

    @PublicApi
    public boolean getIsRecoverableException() {
        return this.getErrorCode() == -13030;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @PublicApi
    public static @interface ErrorCode {
    }
}

