/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.storage.CancelException;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.StorageTaskScheduler;
import com.google.firebase.storage.internal.ExponentialBackoffSender;
import com.google.firebase.storage.network.GetNetworkRequest;
import com.google.firebase.storage.network.NetworkRequest;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

@PublicApi
public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    static final long PREFERRED_CHUNK_SIZE = 262144L;
    private static final String TAG = "StreamDownloadTask";
    private StorageReference mStorageRef;
    private ExponentialBackoffSender mSender;
    private volatile Exception mException = null;
    private volatile int mResultCode = 0;
    private StreamProcessor mProcessor;
    private long mTotalBytes = -1L;
    private long mBytesDownloaded;
    private long mBytesDownloadedSnapped;
    private InputStream mInputStream;
    private NetworkRequest mRequest;
    private String mETagVerification;

    StreamDownloadTask(@NonNull StorageReference storageRef) {
        this.mStorageRef = storageRef;
        this.mSender = new ExponentialBackoffSender(this.mStorageRef.getApp(), this.mStorageRef.getStorage().getMaxDownloadRetryTimeMillis());
    }

    StreamDownloadTask setStreamProcessor(@NonNull StreamProcessor processor) {
        Preconditions.checkNotNull((Object)processor);
        Preconditions.checkState((this.mProcessor == null ? 1 : 0) != 0);
        this.mProcessor = processor;
        return this;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.mStorageRef;
    }

    long getTotalBytes() {
        return this.mTotalBytes;
    }

    void recordDownloadedBytes(long bytesDownloaded) {
        this.mBytesDownloaded += bytesDownloaded;
        if (this.mBytesDownloadedSnapped + 262144L <= this.mBytesDownloaded) {
            if (this.getInternalState() == 4) {
                this.tryChangeState(4, false);
            } else {
                this.mBytesDownloadedSnapped = this.mBytesDownloaded;
            }
        }
    }

    @Override
    protected void schedule() {
        StorageTaskScheduler.getInstance().scheduleDownload(this.getRunnable());
    }

    private InputStream createDownloadStream() throws Exception {
        boolean success;
        this.mSender.reset();
        if (this.mRequest != null) {
            this.mRequest.performRequestEnd();
        }
        this.mRequest = new GetNetworkRequest(this.mStorageRef.getStorageUri(), this.mStorageRef.getApp(), this.mBytesDownloaded);
        this.mSender.sendWithExponentialBackoff(this.mRequest, false);
        this.mResultCode = this.mRequest.getResultCode();
        this.mException = this.mRequest.getException() != null ? this.mRequest.getException() : this.mException;
        boolean bl = success = this.isValidHttpResponseCode(this.mResultCode) && this.mException == null && this.getInternalState() == 4;
        if (success) {
            String newEtag = this.mRequest.getResultString("ETag");
            if (!TextUtils.isEmpty((CharSequence)newEtag) && this.mETagVerification != null && !this.mETagVerification.equals(newEtag)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.mETagVerification = newEtag;
            if (this.mTotalBytes == -1L) {
                this.mTotalBytes = this.mRequest.getResultingContentLength();
            }
            return this.mRequest.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    void run() {
        boolean success;
        if (this.mException != null) {
            this.tryChangeState(64, false);
            return;
        }
        if (!this.tryChangeState(4, false)) {
            return;
        }
        StreamProgressWrapper streamWrapper = new StreamProgressWrapper(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return StreamDownloadTask.this.createDownloadStream();
            }
        }, this);
        this.mInputStream = new BufferedInputStream(streamWrapper);
        try {
            streamWrapper.ensureStream();
            if (this.mProcessor != null) {
                try {
                    this.mProcessor.doInBackground((TaskSnapshot)this.snapState(), this.mInputStream);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)"Exception occurred calling doInBackground.", (Throwable)e);
                    this.mException = e;
                }
            }
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"Initial opening of Stream failed", (Throwable)e);
            this.mException = e;
        }
        if (this.mInputStream == null) {
            this.mRequest.performRequestEnd();
            this.mRequest = null;
        }
        boolean bl = success = this.mException == null && this.getInternalState() == 4;
        if (success) {
            this.tryChangeState(4, false);
            this.tryChangeState(128, false);
        } else if (!this.tryChangeState(this.getInternalState() == 32 ? 256 : 64, false)) {
            Log.w((String)TAG, (String)("Unable to change download task to final state from " + this.getInternalState()));
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    @NonNull
    TaskSnapshot snapStateImpl() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.mException, this.mResultCode)), this.mBytesDownloadedSnapped);
    }

    @Override
    protected void onCanceled() {
        this.mSender.cancel();
        this.mException = StorageException.fromErrorStatus(Status.RESULT_CANCELED);
    }

    @Override
    protected void onProgress() {
        this.mBytesDownloadedSnapped = this.mBytesDownloaded;
    }

    private boolean isValidHttpResponseCode(int code) {
        return code == 308 || code >= 200 && code < 300;
    }

    @PublicApi
    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long mBytesDownloaded;

        TaskSnapshot(Exception error, long bytesDownloaded) {
            super(error);
            this.mBytesDownloaded = bytesDownloaded;
        }

        @PublicApi
        public long getBytesTransferred() {
            return this.mBytesDownloaded;
        }

        @PublicApi
        public long getTotalByteCount() {
            return StreamDownloadTask.this.getTotalBytes();
        }

        @PublicApi
        public InputStream getStream() {
            return StreamDownloadTask.this.mInputStream;
        }
    }

    static class StreamProgressWrapper
    extends InputStream {
        @Nullable
        private StreamDownloadTask mParentTask;
        @Nullable
        private InputStream mWrappedStream;
        private Callable<InputStream> mInputStreamCallable;
        private IOException mTemporaryException;
        private long mDownloadedBytes;
        private long mLastExceptionPosition;
        private boolean mStreamClosed;

        StreamProgressWrapper(@NonNull Callable<InputStream> inputStreamCallable, @Nullable StreamDownloadTask parentTask) {
            this.mParentTask = parentTask;
            this.mInputStreamCallable = inputStreamCallable;
        }

        private void checkCancel() throws IOException {
            if (this.mParentTask != null && this.mParentTask.getInternalState() == 32) {
                throw new CancelException();
            }
        }

        private void recordDownloadedBytes(long delta) {
            if (this.mParentTask != null) {
                this.mParentTask.recordDownloadedBytes(delta);
            }
            this.mDownloadedBytes += delta;
        }

        private boolean ensureStream() throws IOException {
            this.checkCancel();
            if (this.mTemporaryException != null) {
                try {
                    if (this.mWrappedStream != null) {
                        this.mWrappedStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mWrappedStream = null;
                if (this.mLastExceptionPosition == this.mDownloadedBytes) {
                    Log.i((String)StreamDownloadTask.TAG, (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.mTemporaryException);
                    return false;
                }
                Log.i((String)StreamDownloadTask.TAG, (String)("Encountered exception during stream operation. Retrying at " + this.mDownloadedBytes), (Throwable)this.mTemporaryException);
                this.mLastExceptionPosition = this.mDownloadedBytes;
                this.mTemporaryException = null;
            }
            if (this.mStreamClosed) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.mWrappedStream == null) {
                try {
                    this.mWrappedStream = this.mInputStreamCallable.call();
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new IOException("Unable to open stream", e);
                }
            }
            return true;
        }

        @Override
        @PublicApi
        public int read() throws IOException {
            while (this.ensureStream()) {
                try {
                    int returnValue = this.mWrappedStream.read();
                    if (returnValue != -1) {
                        this.recordDownloadedBytes(1L);
                    }
                    return returnValue;
                }
                catch (IOException e) {
                    this.mTemporaryException = e;
                }
            }
            throw this.mTemporaryException;
        }

        @Override
        @PublicApi
        public int available() throws IOException {
            while (this.ensureStream()) {
                try {
                    return this.mWrappedStream.available();
                }
                catch (IOException e) {
                    this.mTemporaryException = e;
                }
            }
            throw this.mTemporaryException;
        }

        @Override
        @PublicApi
        public void close() throws IOException {
            if (this.mWrappedStream != null) {
                this.mWrappedStream.close();
            }
            this.mStreamClosed = true;
            if (this.mParentTask != null && this.mParentTask.mRequest != null) {
                this.mParentTask.mRequest.performRequestEnd();
                this.mParentTask.mRequest = null;
            }
            this.checkCancel();
        }

        @Override
        @PublicApi
        public void mark(int readlimit) {
        }

        @Override
        @PublicApi
        public boolean markSupported() {
            return false;
        }

        @Override
        @PublicApi
        public int read(@NonNull byte[] buffer, int byteOffset, int byteCount) throws IOException {
            int bytesRead = 0;
            while (this.ensureStream()) {
                try {
                    int deltaBytesRead;
                    while ((long)byteCount > 262144L) {
                        deltaBytesRead = this.mWrappedStream.read(buffer, byteOffset, 262144);
                        if (deltaBytesRead == -1) {
                            return bytesRead == 0 ? -1 : bytesRead;
                        }
                        bytesRead += deltaBytesRead;
                        byteOffset += deltaBytesRead;
                        byteCount -= deltaBytesRead;
                        this.recordDownloadedBytes(deltaBytesRead);
                        this.checkCancel();
                    }
                    if (byteCount > 0) {
                        deltaBytesRead = this.mWrappedStream.read(buffer, byteOffset, byteCount);
                        if (deltaBytesRead == -1) {
                            return bytesRead == 0 ? -1 : bytesRead;
                        }
                        byteOffset += deltaBytesRead;
                        bytesRead += deltaBytesRead;
                        byteCount -= deltaBytesRead;
                        this.recordDownloadedBytes(deltaBytesRead);
                    }
                    if (byteCount != 0) continue;
                    return bytesRead;
                }
                catch (IOException e) {
                    this.mTemporaryException = e;
                }
            }
            throw this.mTemporaryException;
        }

        @Override
        @PublicApi
        public long skip(long byteCount) throws IOException {
            long bytesSkipped = 0L;
            while (this.ensureStream()) {
                try {
                    long deltaBytesSkipped;
                    while (byteCount > 262144L) {
                        deltaBytesSkipped = this.mWrappedStream.skip(262144L);
                        if (deltaBytesSkipped < 0L) {
                            return bytesSkipped == 0L ? -1L : bytesSkipped;
                        }
                        bytesSkipped += deltaBytesSkipped;
                        byteCount -= deltaBytesSkipped;
                        this.recordDownloadedBytes(deltaBytesSkipped);
                        this.checkCancel();
                    }
                    if (byteCount > 0L) {
                        deltaBytesSkipped = this.mWrappedStream.skip(byteCount);
                        if (deltaBytesSkipped < 0L) {
                            return bytesSkipped == 0L ? -1L : bytesSkipped;
                        }
                        bytesSkipped += deltaBytesSkipped;
                        byteCount -= deltaBytesSkipped;
                        this.recordDownloadedBytes(deltaBytesSkipped);
                    }
                    if (byteCount != 0L) continue;
                    return bytesSkipped;
                }
                catch (IOException e) {
                    this.mTemporaryException = e;
                }
            }
            throw this.mTemporaryException;
        }
    }

    @PublicApi
    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

