/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.support.annotation.NonNull;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class StorageTaskScheduler {
    public static StorageTaskScheduler sInstance = new StorageTaskScheduler();
    private static BlockingQueue<Runnable> mCommandQueue = new LinkedBlockingQueue<Runnable>();
    private static final ThreadPoolExecutor COMMAND_POOL_EXECUTOR = new ThreadPoolExecutor(5, 5, 5L, TimeUnit.SECONDS, mCommandQueue, new StorageThreadFactory("Command-"));
    private static BlockingQueue<Runnable> mUploadQueue = new LinkedBlockingQueue<Runnable>();
    private static final ThreadPoolExecutor UPLOAD_QUEUE_EXECUTOR = new ThreadPoolExecutor(2, 2, 5L, TimeUnit.SECONDS, mUploadQueue, new StorageThreadFactory("Upload-"));
    private static BlockingQueue<Runnable> mDownloadQueue = new LinkedBlockingQueue<Runnable>();
    private static final ThreadPoolExecutor DOWNLOAD_QUEUE_EXECUTOR = new ThreadPoolExecutor(3, 3, 5L, TimeUnit.SECONDS, mDownloadQueue, new StorageThreadFactory("Download-"));
    private static BlockingQueue<Runnable> mCallbackQueue = new LinkedBlockingQueue<Runnable>();
    private static final ThreadPoolExecutor CALLBACK_QUEUE_EXECUTOR = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, mCallbackQueue, new StorageThreadFactory("Callbacks-"));

    public static StorageTaskScheduler getInstance() {
        return sInstance;
    }

    public void scheduleCommand(Runnable task) {
        COMMAND_POOL_EXECUTOR.execute(task);
    }

    public void scheduleUpload(Runnable task) {
        UPLOAD_QUEUE_EXECUTOR.execute(task);
    }

    public void scheduleDownload(Runnable task) {
        DOWNLOAD_QUEUE_EXECUTOR.execute(task);
    }

    public void scheduleCallback(Runnable task) {
        CALLBACK_QUEUE_EXECUTOR.execute(task);
    }

    static {
        COMMAND_POOL_EXECUTOR.allowCoreThreadTimeOut(true);
        UPLOAD_QUEUE_EXECUTOR.allowCoreThreadTimeOut(true);
        DOWNLOAD_QUEUE_EXECUTOR.allowCoreThreadTimeOut(true);
        CALLBACK_QUEUE_EXECUTOR.allowCoreThreadTimeOut(true);
    }

    static class StorageThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String mNameSuffix;

        StorageThreadFactory(@NonNull String suffix) {
            this.mNameSuffix = suffix;
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread t = new Thread(r, "FirebaseStorage-" + this.mNameSuffix + this.threadNumber.getAndIncrement());
            t.setDaemon(false);
            t.setPriority(9);
            return t;
        }
    }
}

