/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.sessions.EventGDTLoggerInterface;
import com.google.firebase.sessions.InstallationId;
import com.google.firebase.sessions.SessionDetails;
import com.google.firebase.sessions.SessionEvent;
import com.google.firebase.sessions.SessionEvents;
import com.google.firebase.sessions.SessionFirelogPublisher;
import com.google.firebase.sessions.SessionFirelogPublisherImpl;
import com.google.firebase.sessions.api.FirebaseSessionsDependencies;
import com.google.firebase.sessions.api.SessionSubscriber;
import com.google.firebase.sessions.settings.SessionsSettings;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0011\u0010\u0016\u001a\u00020\u0015H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lcom/google/firebase/sessions/SessionFirelogPublisherImpl;", "Lcom/google/firebase/sessions/SessionFirelogPublisher;", "firebaseApp", "Lcom/google/firebase/FirebaseApp;", "firebaseInstallations", "Lcom/google/firebase/installations/FirebaseInstallationsApi;", "sessionSettings", "Lcom/google/firebase/sessions/settings/SessionsSettings;", "eventGDTLogger", "Lcom/google/firebase/sessions/EventGDTLoggerInterface;", "backgroundDispatcher", "Lkotlin/coroutines/CoroutineContext;", "(Lcom/google/firebase/FirebaseApp;Lcom/google/firebase/installations/FirebaseInstallationsApi;Lcom/google/firebase/sessions/settings/SessionsSettings;Lcom/google/firebase/sessions/EventGDTLoggerInterface;Lkotlin/coroutines/CoroutineContext;)V", "attemptLoggingSessionEvent", "", "sessionEvent", "Lcom/google/firebase/sessions/SessionEvent;", "logSession", "sessionDetails", "Lcom/google/firebase/sessions/SessionDetails;", "shouldCollectEvents", "", "shouldLogSession", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "com.google.firebase-firebase-sessions"})
public final class SessionFirelogPublisherImpl
implements SessionFirelogPublisher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirebaseApp firebaseApp;
    @NotNull
    private final FirebaseInstallationsApi firebaseInstallations;
    @NotNull
    private final SessionsSettings sessionSettings;
    @NotNull
    private final EventGDTLoggerInterface eventGDTLogger;
    @NotNull
    private final CoroutineContext backgroundDispatcher;
    @NotNull
    private static final String TAG = "SessionFirelogPublisher";
    private static final double randomValueForSampling = Math.random();

    public SessionFirelogPublisherImpl(@NotNull FirebaseApp firebaseApp, @NotNull FirebaseInstallationsApi firebaseInstallations, @NotNull SessionsSettings sessionSettings, @NotNull EventGDTLoggerInterface eventGDTLogger, @NotNull CoroutineContext backgroundDispatcher) {
        Intrinsics.checkNotNullParameter((Object)firebaseApp, (String)"firebaseApp");
        Intrinsics.checkNotNullParameter((Object)firebaseInstallations, (String)"firebaseInstallations");
        Intrinsics.checkNotNullParameter((Object)sessionSettings, (String)"sessionSettings");
        Intrinsics.checkNotNullParameter((Object)eventGDTLogger, (String)"eventGDTLogger");
        Intrinsics.checkNotNullParameter((Object)backgroundDispatcher, (String)"backgroundDispatcher");
        this.firebaseApp = firebaseApp;
        this.firebaseInstallations = firebaseInstallations;
        this.sessionSettings = sessionSettings;
        this.eventGDTLogger = eventGDTLogger;
        this.backgroundDispatcher = backgroundDispatcher;
    }

    @Override
    public void logSession(@NotNull SessionDetails sessionDetails) {
        Intrinsics.checkNotNullParameter((Object)sessionDetails, (String)"sessionDetails");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.backgroundDispatcher), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, sessionDetails, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int label;
            final /* synthetic */ SessionFirelogPublisherImpl this$0;
            final /* synthetic */ SessionDetails $sessionDetails;
            {
                this.this$0 = $receiver;
                this.$sessionDetails = $sessionDetails;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = SessionFirelogPublisherImpl.access$shouldLogSession(this.this$0, (Continuation)this);
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) ** GOTO lbl50
                        this.label = 2;
                        v1 = InstallationId.Companion.create(SessionFirelogPublisherImpl.access$getFirebaseInstallations$p(this.this$0), (Continuation<? super InstallationId>)((Continuation)this));
                        if (v1 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        installationId = (InstallationId)v1;
                        var7_4 = SessionFirelogPublisherImpl.access$getSessionSettings$p(this.this$0);
                        var6_5 = this.$sessionDetails;
                        var5_6 = SessionFirelogPublisherImpl.access$getFirebaseApp$p(this.this$0);
                        var4_7 = SessionEvents.INSTANCE;
                        var3_8 = this.this$0;
                        this.L$0 = installationId;
                        this.L$1 = var3_8;
                        this.L$2 = var4_7;
                        this.L$3 = var5_6;
                        this.L$4 = var6_5;
                        this.L$5 = var7_4;
                        this.label = 3;
                        v2 = FirebaseSessionsDependencies.INSTANCE.getRegisteredSubscribers$com_google_firebase_firebase_sessions((Continuation<? super Map<SessionSubscriber.Name, ? extends SessionSubscriber>>)((Continuation)this));
                        if (v2 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl48
                    }
                    case 3: {
                        var7_4 = (SessionsSettings)this.L$5;
                        var6_5 = (SessionDetails)this.L$4;
                        var5_6 = (FirebaseApp)this.L$3;
                        var4_7 = (SessionEvents)this.L$2;
                        var3_8 = (SessionFirelogPublisherImpl)this.L$1;
                        installationId = (InstallationId)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl48:
                        // 2 sources

                        var8_9 = v2;
                        SessionFirelogPublisherImpl.access$attemptLoggingSessionEvent(var3_8, var4_7.buildSession(var5_6, var6_5, var7_4, (Map)var8_9, installationId.getFid(), installationId.getAuthToken()));
lbl50:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void attemptLoggingSessionEvent(SessionEvent sessionEvent) {
        try {
            this.eventGDTLogger.log(sessionEvent);
            Log.d((String)TAG, (String)"Successfully logged Session Start event.");
        }
        catch (RuntimeException ex) {
            Log.e((String)TAG, (String)"Error logging Session Start event to DataTransport: ", (Throwable)ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object shouldLogSession(Continuation<? super Boolean> var1_1) {
        if (!(var1_1 instanceof shouldLogSession.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SessionFirelogPublisherImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SessionFirelogPublisherImpl.access$shouldLogSession(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Log.d((String)"SessionFirelogPublisher", (String)"Data Collection is enabled for at least one Subscriber");
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.sessionSettings.updateSettings((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl24
            }
            case 1: {
                this = (SessionFirelogPublisherImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if (!this.sessionSettings.getSessionsEnabled()) {
                    Log.d((String)"SessionFirelogPublisher", (String)"Sessions SDK disabled. Events will not be sent.");
                    return Boxing.boxBoolean((boolean)false);
                }
                if (!this.shouldCollectEvents()) {
                    Log.d((String)"SessionFirelogPublisher", (String)"Sessions SDK has dropped this session due to sampling.");
                    return Boxing.boxBoolean((boolean)false);
                }
                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean shouldCollectEvents() {
        return randomValueForSampling <= this.sessionSettings.getSamplingRate();
    }

    public static final /* synthetic */ Object access$shouldLogSession(SessionFirelogPublisherImpl $this, Continuation $completion) {
        return $this.shouldLogSession((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ FirebaseInstallationsApi access$getFirebaseInstallations$p(SessionFirelogPublisherImpl $this) {
        return $this.firebaseInstallations;
    }

    public static final /* synthetic */ void access$attemptLoggingSessionEvent(SessionFirelogPublisherImpl $this, SessionEvent sessionEvent) {
        $this.attemptLoggingSessionEvent(sessionEvent);
    }

    public static final /* synthetic */ FirebaseApp access$getFirebaseApp$p(SessionFirelogPublisherImpl $this) {
        return $this.firebaseApp;
    }

    public static final /* synthetic */ SessionsSettings access$getSessionSettings$p(SessionFirelogPublisherImpl $this) {
        return $this.sessionSettings;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/google/firebase/sessions/SessionFirelogPublisherImpl$Companion;", "", "()V", "TAG", "", "randomValueForSampling", "", "com.google.firebase-firebase-sessions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

