/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.google.firebase.sessions.SessionDetails;
import com.google.firebase.sessions.SessionGenerator;
import com.google.firebase.sessions.SessionInitiateListener;
import com.google.firebase.sessions.TimeProvider;
import com.google.firebase.sessions.settings.SessionsSettings;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\b\u0010\u0017\u001a\u00020\u0015H\u0002R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0018"}, d2={"Lcom/google/firebase/sessions/SessionInitiator;", "", "timeProvider", "Lcom/google/firebase/sessions/TimeProvider;", "backgroundDispatcher", "Lkotlin/coroutines/CoroutineContext;", "sessionInitiateListener", "Lcom/google/firebase/sessions/SessionInitiateListener;", "sessionsSettings", "Lcom/google/firebase/sessions/settings/SessionsSettings;", "sessionGenerator", "Lcom/google/firebase/sessions/SessionGenerator;", "(Lcom/google/firebase/sessions/TimeProvider;Lkotlin/coroutines/CoroutineContext;Lcom/google/firebase/sessions/SessionInitiateListener;Lcom/google/firebase/sessions/settings/SessionsSettings;Lcom/google/firebase/sessions/SessionGenerator;)V", "activityLifecycleCallbacks", "Landroid/app/Application$ActivityLifecycleCallbacks;", "getActivityLifecycleCallbacks$com_google_firebase_firebase_sessions", "()Landroid/app/Application$ActivityLifecycleCallbacks;", "backgroundTime", "Lkotlin/time/Duration;", "J", "appBackgrounded", "", "appForegrounded", "initiateSession", "com.google.firebase-firebase-sessions"})
public final class SessionInitiator {
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final CoroutineContext backgroundDispatcher;
    @NotNull
    private final SessionInitiateListener sessionInitiateListener;
    @NotNull
    private final SessionsSettings sessionsSettings;
    @NotNull
    private final SessionGenerator sessionGenerator;
    private long backgroundTime;
    @NotNull
    private final Application.ActivityLifecycleCallbacks activityLifecycleCallbacks;

    public SessionInitiator(@NotNull TimeProvider timeProvider, @NotNull CoroutineContext backgroundDispatcher, @NotNull SessionInitiateListener sessionInitiateListener2, @NotNull SessionsSettings sessionsSettings, @NotNull SessionGenerator sessionGenerator) {
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)backgroundDispatcher, (String)"backgroundDispatcher");
        Intrinsics.checkNotNullParameter((Object)sessionInitiateListener2, (String)"sessionInitiateListener");
        Intrinsics.checkNotNullParameter((Object)sessionsSettings, (String)"sessionsSettings");
        Intrinsics.checkNotNullParameter((Object)sessionGenerator, (String)"sessionGenerator");
        this.timeProvider = timeProvider;
        this.backgroundDispatcher = backgroundDispatcher;
        this.sessionInitiateListener = sessionInitiateListener2;
        this.sessionsSettings = sessionsSettings;
        this.sessionGenerator = sessionGenerator;
        this.backgroundTime = this.timeProvider.elapsedRealtime-UwyO8pc();
        this.initiateSession();
        this.activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(this){
            final /* synthetic */ SessionInitiator this$0;
            {
                this.this$0 = $receiver;
            }

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                this.this$0.appForegrounded();
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                this.this$0.appBackgrounded();
            }

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
            }
        };
    }

    public final void appBackgrounded() {
        this.backgroundTime = this.timeProvider.elapsedRealtime-UwyO8pc();
    }

    public final void appForegrounded() {
        long sessionTimeout;
        long interval = Duration.minus-LRDsOJo((long)this.timeProvider.elapsedRealtime-UwyO8pc(), (long)this.backgroundTime);
        if (Duration.compareTo-LRDsOJo((long)interval, (long)(sessionTimeout = this.sessionsSettings.getSessionRestartTimeout-UwyO8pc())) > 0) {
            this.initiateSession();
        }
    }

    private final void initiateSession() {
        SessionDetails sessionDetails = this.sessionGenerator.generateNewSession();
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.backgroundDispatcher), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, sessionDetails, null){
            int label;
            final /* synthetic */ SessionInitiator this$0;
            final /* synthetic */ SessionDetails $sessionDetails;
            {
                this.this$0 = $receiver;
                this.$sessionDetails = $sessionDetails;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = SessionInitiator.access$getSessionInitiateListener$p(this.this$0).onInitiateSession(this.$sessionDetails, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Application.ActivityLifecycleCallbacks getActivityLifecycleCallbacks$com_google_firebase_firebase_sessions() {
        return this.activityLifecycleCallbacks;
    }

    public static final /* synthetic */ SessionInitiateListener access$getSessionInitiateListener$p(SessionInitiator $this) {
        return $this.sessionInitiateListener;
    }
}

