/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.firebase.internal.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Objects {
    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static ToStringHelper toStringHelper(Object object) {
        return new ToStringHelper(object);
    }

    private Objects() {
        throw new AssertionError((Object)"Uninstantiable");
    }

    public static final class ToStringHelper {
        private final List<String> mFieldStrings;
        private final Object mInstance;

        private ToStringHelper(Object instance) {
            this.mInstance = Preconditions.checkNotNull(instance);
            this.mFieldStrings = new ArrayList<String>();
        }

        public ToStringHelper add(String name, Object value) {
            String string = Preconditions.checkNotNull(name);
            String string2 = String.valueOf(String.valueOf(value));
            this.mFieldStrings.add(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString());
            return this;
        }

        public ToStringHelper addValue(Object value) {
            this.mFieldStrings.add(String.valueOf(value));
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(100).append(this.mInstance.getClass().getSimpleName()).append('{');
            int numFields = this.mFieldStrings.size();
            for (int i = 0; i < numFields; ++i) {
                builder.append(this.mFieldStrings.get(i));
                if (i >= numFields - 1) continue;
                builder.append(", ");
            }
            return builder.append('}').toString();
        }
    }
}

