/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.view;

import com.google.firebase.database.core.CompoundWrite;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.WriteTreeRef;
import com.google.firebase.database.core.operation.AckUserWrite;
import com.google.firebase.database.core.operation.Merge;
import com.google.firebase.database.core.operation.Operation;
import com.google.firebase.database.core.operation.Overwrite;
import com.google.firebase.database.core.utilities.ImmutableTree;
import com.google.firebase.database.core.view.CacheNode;
import com.google.firebase.database.core.view.Change;
import com.google.firebase.database.core.view.ViewCache;
import com.google.firebase.database.core.view.filter.ChildChangeAccumulator;
import com.google.firebase.database.core.view.filter.NodeFilter;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.ChildrenNode;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.Index;
import com.google.firebase.database.snapshot.IndexedNode;
import com.google.firebase.database.snapshot.KeyIndex;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ViewProcessor {
    private final NodeFilter filter;
    private static NodeFilter.CompleteChildSource NO_COMPLETE_SOURCE = new NodeFilter.CompleteChildSource(){

        @Override
        public Node getCompleteChild(ChildKey childKey) {
            return null;
        }

        @Override
        public NamedNode getChildAfterChild(Index index, NamedNode child, boolean reverse) {
            return null;
        }
    };

    public ViewProcessor(NodeFilter filter) {
        this.filter = filter;
    }

    public ProcessorResult applyOperation(ViewCache oldViewCache, Operation operation, WriteTreeRef writesCache, Node optCompleteCache) {
        ViewCache newViewCache;
        ChildChangeAccumulator accumulator = new ChildChangeAccumulator();
        switch (operation.getType()) {
            case Overwrite: {
                Overwrite overwrite = (Overwrite)operation;
                if (overwrite.getSource().isFromUser()) {
                    newViewCache = this.applyUserOverwrite(oldViewCache, overwrite.getPath(), overwrite.getSnapshot(), writesCache, optCompleteCache, accumulator);
                    break;
                }
                assert (overwrite.getSource().isFromServer());
                boolean filterServerNode = overwrite.getSource().isTagged() || oldViewCache.getServerCache().isFiltered() && !overwrite.getPath().isEmpty();
                newViewCache = this.applyServerOverwrite(oldViewCache, overwrite.getPath(), overwrite.getSnapshot(), writesCache, optCompleteCache, filterServerNode, accumulator);
                break;
            }
            case Merge: {
                Merge merge = (Merge)operation;
                if (merge.getSource().isFromUser()) {
                    newViewCache = this.applyUserMerge(oldViewCache, merge.getPath(), merge.getChildren(), writesCache, optCompleteCache, accumulator);
                    break;
                }
                assert (merge.getSource().isFromServer());
                boolean filterServerNode = merge.getSource().isTagged() || oldViewCache.getServerCache().isFiltered();
                newViewCache = this.applyServerMerge(oldViewCache, merge.getPath(), merge.getChildren(), writesCache, optCompleteCache, filterServerNode, accumulator);
                break;
            }
            case AckUserWrite: {
                AckUserWrite ackUserWrite = (AckUserWrite)operation;
                if (!ackUserWrite.isRevert()) {
                    newViewCache = this.ackUserWrite(oldViewCache, ackUserWrite.getPath(), ackUserWrite.getAffectedTree(), writesCache, optCompleteCache, accumulator);
                    break;
                }
                newViewCache = this.revertUserWrite(oldViewCache, ackUserWrite.getPath(), writesCache, optCompleteCache, accumulator);
                break;
            }
            case ListenComplete: {
                newViewCache = this.listenComplete(oldViewCache, operation.getPath(), writesCache, optCompleteCache, accumulator);
                break;
            }
            default: {
                String ackUserWrite = String.valueOf((Object)operation.getType());
                throw new AssertionError((Object)new StringBuilder(19 + String.valueOf(ackUserWrite).length()).append("Unknown operation: ").append(ackUserWrite).toString());
            }
        }
        ArrayList<Change> changes = new ArrayList<Change>(accumulator.getChanges());
        this.maybeAddValueEvent(oldViewCache, newViewCache, changes);
        return new ProcessorResult(newViewCache, changes);
    }

    private void maybeAddValueEvent(ViewCache oldViewCache, ViewCache newViewCache, List<Change> accumulator) {
        CacheNode eventSnap = newViewCache.getEventCache();
        if (eventSnap.isFullyInitialized()) {
            boolean isLeafOrEmpty;
            boolean bl = isLeafOrEmpty = eventSnap.getNode().isLeafNode() || eventSnap.getNode().isEmpty();
            if (!accumulator.isEmpty() || !oldViewCache.getEventCache().isFullyInitialized() || isLeafOrEmpty && !eventSnap.getNode().equals(oldViewCache.getCompleteEventSnap()) || !eventSnap.getNode().getPriority().equals(oldViewCache.getCompleteEventSnap().getPriority())) {
                accumulator.add(Change.valueChange(eventSnap.getIndexedNode()));
            }
        }
    }

    private ViewCache generateEventCacheAfterServerEvent(ViewCache viewCache, Path changePath, WriteTreeRef writesCache, NodeFilter.CompleteChildSource source, ChildChangeAccumulator accumulator) {
        IndexedNode newEventCache;
        CacheNode oldEventSnap = viewCache.getEventCache();
        if (writesCache.shadowingWrite(changePath) != null) {
            return viewCache;
        }
        if (changePath.isEmpty()) {
            Node nodeWithLocalWrites;
            assert (viewCache.getServerCache().isFullyInitialized()) : "If change path is empty, we must have complete server data";
            if (viewCache.getServerCache().isFiltered()) {
                Node serverCache = viewCache.getCompleteServerSnap();
                Node completeChildren = serverCache instanceof ChildrenNode ? serverCache : EmptyNode.Empty();
                nodeWithLocalWrites = writesCache.calcCompleteEventChildren(completeChildren);
            } else {
                nodeWithLocalWrites = writesCache.calcCompleteEventCache(viewCache.getCompleteServerSnap());
            }
            IndexedNode indexedNode = IndexedNode.from(nodeWithLocalWrites, this.filter.getIndex());
            newEventCache = this.filter.updateFullNode(viewCache.getEventCache().getIndexedNode(), indexedNode, accumulator);
        } else {
            ChildKey childKey = changePath.getFront();
            if (childKey.isPriorityChildName()) {
                Node serverNode;
                assert (changePath.size() == 1) : "Can't have a priority with additional path components";
                Node oldEventNode = oldEventSnap.getNode();
                Node updatedPriority = writesCache.calcEventCacheAfterServerOverwrite(changePath, oldEventNode, serverNode = viewCache.getServerCache().getNode());
                newEventCache = updatedPriority != null ? this.filter.updatePriority(oldEventSnap.getIndexedNode(), updatedPriority) : oldEventSnap.getIndexedNode();
            } else {
                Node newEventChild;
                Path childChangePath = changePath.popFront();
                if (oldEventSnap.isCompleteForChild(childKey)) {
                    Node serverNode = viewCache.getServerCache().getNode();
                    Node eventChildUpdate = writesCache.calcEventCacheAfterServerOverwrite(changePath, oldEventSnap.getNode(), serverNode);
                    newEventChild = eventChildUpdate != null ? oldEventSnap.getNode().getImmediateChild(childKey).updateChild(childChangePath, eventChildUpdate) : oldEventSnap.getNode().getImmediateChild(childKey);
                } else {
                    newEventChild = writesCache.calcCompleteChild(childKey, viewCache.getServerCache());
                }
                newEventCache = newEventChild != null ? this.filter.updateChild(oldEventSnap.getIndexedNode(), childKey, newEventChild, childChangePath, source, accumulator) : oldEventSnap.getIndexedNode();
            }
        }
        return viewCache.updateEventSnap(newEventCache, oldEventSnap.isFullyInitialized() || changePath.isEmpty(), this.filter.filtersNodes());
    }

    private ViewCache applyServerOverwrite(ViewCache oldViewCache, Path changePath, Node changedSnap, WriteTreeRef writesCache, Node optCompleteCache, boolean filterServerNode, ChildChangeAccumulator accumulator) {
        ChildKey childKey;
        IndexedNode newServerCache;
        NodeFilter serverFilter;
        CacheNode oldServerSnap = oldViewCache.getServerCache();
        NodeFilter nodeFilter = serverFilter = filterServerNode ? this.filter : this.filter.getIndexedFilter();
        if (changePath.isEmpty()) {
            newServerCache = serverFilter.updateFullNode(oldServerSnap.getIndexedNode(), IndexedNode.from(changedSnap, serverFilter.getIndex()), null);
        } else if (serverFilter.filtersNodes() && !oldServerSnap.isFiltered()) {
            assert (!changePath.isEmpty()) : "An empty path should have been caught in the other branch";
            childKey = changePath.getFront();
            Path updatePath = changePath.popFront();
            Node newChild = oldServerSnap.getNode().getImmediateChild(childKey).updateChild(updatePath, changedSnap);
            IndexedNode newServerNode = oldServerSnap.getIndexedNode().updateChild(childKey, newChild);
            newServerCache = serverFilter.updateFullNode(oldServerSnap.getIndexedNode(), newServerNode, null);
        } else {
            childKey = changePath.getFront();
            if (!oldServerSnap.isCompleteForPath(changePath) && changePath.size() > 1) {
                return oldViewCache;
            }
            Path childChangePath = changePath.popFront();
            Node childNode = oldServerSnap.getNode().getImmediateChild(childKey);
            Node newChildNode = childNode.updateChild(childChangePath, changedSnap);
            newServerCache = childKey.isPriorityChildName() ? serverFilter.updatePriority(oldServerSnap.getIndexedNode(), newChildNode) : serverFilter.updateChild(oldServerSnap.getIndexedNode(), childKey, newChildNode, childChangePath, NO_COMPLETE_SOURCE, null);
        }
        ViewCache newViewCache = oldViewCache.updateServerSnap(newServerCache, oldServerSnap.isFullyInitialized() || changePath.isEmpty(), serverFilter.filtersNodes());
        WriteTreeCompleteChildSource source = new WriteTreeCompleteChildSource(writesCache, newViewCache, optCompleteCache);
        return this.generateEventCacheAfterServerEvent(newViewCache, changePath, writesCache, source, accumulator);
    }

    private ViewCache applyUserOverwrite(ViewCache oldViewCache, Path changePath, Node changedSnap, WriteTreeRef writesCache, Node optCompleteCache, ChildChangeAccumulator accumulator) {
        ViewCache newViewCache;
        CacheNode oldEventSnap = oldViewCache.getEventCache();
        WriteTreeCompleteChildSource source = new WriteTreeCompleteChildSource(writesCache, oldViewCache, optCompleteCache);
        if (changePath.isEmpty()) {
            IndexedNode newIndexed = IndexedNode.from(changedSnap, this.filter.getIndex());
            IndexedNode newEventCache = this.filter.updateFullNode(oldViewCache.getEventCache().getIndexedNode(), newIndexed, accumulator);
            newViewCache = oldViewCache.updateEventSnap(newEventCache, true, this.filter.filtersNodes());
        } else {
            ChildKey childKey = changePath.getFront();
            if (childKey.isPriorityChildName()) {
                IndexedNode newEventCache = this.filter.updatePriority(oldViewCache.getEventCache().getIndexedNode(), changedSnap);
                newViewCache = oldViewCache.updateEventSnap(newEventCache, oldEventSnap.isFullyInitialized(), oldEventSnap.isFiltered());
            } else {
                Node childNode;
                Path childChangePath = changePath.popFront();
                Node oldChild = oldEventSnap.getNode().getImmediateChild(childKey);
                Node newChild = childChangePath.isEmpty() ? changedSnap : ((childNode = source.getCompleteChild(childKey)) != null ? (childChangePath.getBack().isPriorityChildName() && childNode.getChild(childChangePath.getParent()).isEmpty() ? childNode : childNode.updateChild(childChangePath, changedSnap)) : EmptyNode.Empty());
                if (!oldChild.equals(newChild)) {
                    IndexedNode newEventSnap = this.filter.updateChild(oldEventSnap.getIndexedNode(), childKey, newChild, childChangePath, source, accumulator);
                    newViewCache = oldViewCache.updateEventSnap(newEventSnap, oldEventSnap.isFullyInitialized(), this.filter.filtersNodes());
                } else {
                    newViewCache = oldViewCache;
                }
            }
        }
        return newViewCache;
    }

    private static boolean cacheHasChild(ViewCache viewCache, ChildKey childKey) {
        return viewCache.getEventCache().isCompleteForChild(childKey);
    }

    private ViewCache applyUserMerge(ViewCache viewCache, Path path, CompoundWrite changedChildren, WriteTreeRef writesCache, Node serverCache, ChildChangeAccumulator accumulator) {
        Path writePath;
        assert (changedChildren.rootWrite() == null) : "Can't have a merge that is an overwrite";
        ViewCache currentViewCache = viewCache;
        for (Map.Entry<Path, Node> entry : changedChildren) {
            writePath = path.child(entry.getKey());
            if (!ViewProcessor.cacheHasChild(viewCache, writePath.getFront())) continue;
            currentViewCache = this.applyUserOverwrite(currentViewCache, writePath, entry.getValue(), writesCache, serverCache, accumulator);
        }
        for (Map.Entry<Path, Node> entry : changedChildren) {
            writePath = path.child(entry.getKey());
            if (ViewProcessor.cacheHasChild(viewCache, writePath.getFront())) continue;
            currentViewCache = this.applyUserOverwrite(currentViewCache, writePath, entry.getValue(), writesCache, serverCache, accumulator);
        }
        return currentViewCache;
    }

    private ViewCache applyServerMerge(ViewCache viewCache, Path path, CompoundWrite changedChildren, WriteTreeRef writesCache, Node serverCache, boolean filterServerNode, ChildChangeAccumulator accumulator) {
        ChildKey childKey;
        if (viewCache.getServerCache().getNode().isEmpty() && !viewCache.getServerCache().isFullyInitialized()) {
            return viewCache;
        }
        ViewCache curViewCache = viewCache;
        assert (changedChildren.rootWrite() == null) : "Can't have a merge that is an overwrite";
        CompoundWrite actualMerge = path.isEmpty() ? changedChildren : CompoundWrite.emptyWrite().addWrites(path, changedChildren);
        Node serverNode = viewCache.getServerCache().getNode();
        Map<ChildKey, CompoundWrite> childCompoundWrites = actualMerge.childCompoundWrites();
        for (Map.Entry<ChildKey, CompoundWrite> childMerge : childCompoundWrites.entrySet()) {
            childKey = childMerge.getKey();
            if (!serverNode.hasChild(childKey)) continue;
            Node serverChild = serverNode.getImmediateChild(childKey);
            Node newChild = childMerge.getValue().apply(serverChild);
            curViewCache = this.applyServerOverwrite(curViewCache, new Path(childKey), newChild, writesCache, serverCache, filterServerNode, accumulator);
        }
        for (Map.Entry<ChildKey, CompoundWrite> childMerge : childCompoundWrites.entrySet()) {
            boolean isUnknownDeepMerge;
            childKey = childMerge.getKey();
            CompoundWrite childCompoundWrite = childMerge.getValue();
            boolean bl = isUnknownDeepMerge = !viewCache.getServerCache().isCompleteForChild(childKey) && childCompoundWrite.rootWrite() == null;
            if (serverNode.hasChild(childKey) || isUnknownDeepMerge) continue;
            Node serverChild = serverNode.getImmediateChild(childKey);
            Node newChild = childMerge.getValue().apply(serverChild);
            curViewCache = this.applyServerOverwrite(curViewCache, new Path(childKey), newChild, writesCache, serverCache, filterServerNode, accumulator);
        }
        return curViewCache;
    }

    private ViewCache ackUserWrite(ViewCache viewCache, Path ackPath, ImmutableTree<Boolean> affectedTree, WriteTreeRef writesCache, Node optCompleteCache, ChildChangeAccumulator accumulator) {
        if (writesCache.shadowingWrite(ackPath) != null) {
            return viewCache;
        }
        boolean filterServerNode = viewCache.getServerCache().isFiltered();
        CacheNode serverCache = viewCache.getServerCache();
        if (affectedTree.getValue() != null) {
            if (ackPath.isEmpty() && serverCache.isFullyInitialized() || serverCache.isCompleteForPath(ackPath)) {
                return this.applyServerOverwrite(viewCache, ackPath, serverCache.getNode().getChild(ackPath), writesCache, optCompleteCache, filterServerNode, accumulator);
            }
            if (ackPath.isEmpty()) {
                CompoundWrite changedChildren = CompoundWrite.emptyWrite();
                for (NamedNode namedNode : serverCache.getNode()) {
                    changedChildren = changedChildren.addWrite(namedNode.getName(), namedNode.getNode());
                }
                return this.applyServerMerge(viewCache, ackPath, changedChildren, writesCache, optCompleteCache, filterServerNode, accumulator);
            }
            return viewCache;
        }
        CompoundWrite changedChildren = CompoundWrite.emptyWrite();
        for (Map.Entry<Path, Boolean> entry : affectedTree) {
            Path mergePath = entry.getKey();
            Path serverCachePath = ackPath.child(mergePath);
            if (!serverCache.isCompleteForPath(serverCachePath)) continue;
            changedChildren = changedChildren.addWrite(mergePath, serverCache.getNode().getChild(serverCachePath));
        }
        return this.applyServerMerge(viewCache, ackPath, changedChildren, writesCache, optCompleteCache, filterServerNode, accumulator);
    }

    public ViewCache revertUserWrite(ViewCache viewCache, Path path, WriteTreeRef writesCache, Node optCompleteServerCache, ChildChangeAccumulator accumulator) {
        IndexedNode newEventCache;
        if (writesCache.shadowingWrite(path) != null) {
            return viewCache;
        }
        WriteTreeCompleteChildSource source = new WriteTreeCompleteChildSource(writesCache, viewCache, optCompleteServerCache);
        IndexedNode oldEventCache = viewCache.getEventCache().getIndexedNode();
        if (path.isEmpty() || path.getFront().isPriorityChildName()) {
            Node newNode = viewCache.getServerCache().isFullyInitialized() ? writesCache.calcCompleteEventCache(viewCache.getCompleteServerSnap()) : writesCache.calcCompleteEventChildren(viewCache.getServerCache().getNode());
            IndexedNode indexedNode = IndexedNode.from(newNode, this.filter.getIndex());
            newEventCache = this.filter.updateFullNode(oldEventCache, indexedNode, accumulator);
        } else {
            Node complete;
            ChildKey childKey = path.getFront();
            Node newChild = writesCache.calcCompleteChild(childKey, viewCache.getServerCache());
            if (newChild == null && viewCache.getServerCache().isCompleteForChild(childKey)) {
                newChild = oldEventCache.getNode().getImmediateChild(childKey);
            }
            if ((newEventCache = newChild != null ? this.filter.updateChild(oldEventCache, childKey, newChild, path.popFront(), source, accumulator) : (newChild == null && viewCache.getEventCache().getNode().hasChild(childKey) ? this.filter.updateChild(oldEventCache, childKey, EmptyNode.Empty(), path.popFront(), source, accumulator) : oldEventCache)).getNode().isEmpty() && viewCache.getServerCache().isFullyInitialized() && (complete = writesCache.calcCompleteEventCache(viewCache.getCompleteServerSnap())).isLeafNode()) {
                IndexedNode indexedNode = IndexedNode.from(complete, this.filter.getIndex());
                newEventCache = this.filter.updateFullNode(newEventCache, indexedNode, accumulator);
            }
        }
        boolean complete = viewCache.getServerCache().isFullyInitialized() || writesCache.shadowingWrite(Path.getEmptyPath()) != null;
        return viewCache.updateEventSnap(newEventCache, complete, this.filter.filtersNodes());
    }

    private ViewCache listenComplete(ViewCache viewCache, Path path, WriteTreeRef writesCache, Node serverCache, ChildChangeAccumulator accumulator) {
        CacheNode oldServerNode = viewCache.getServerCache();
        ViewCache newViewCache = viewCache.updateServerSnap(oldServerNode.getIndexedNode(), oldServerNode.isFullyInitialized() || path.isEmpty(), oldServerNode.isFiltered());
        return this.generateEventCacheAfterServerEvent(newViewCache, path, writesCache, NO_COMPLETE_SOURCE, accumulator);
    }

    private static class WriteTreeCompleteChildSource
    implements NodeFilter.CompleteChildSource {
        private final WriteTreeRef writes;
        private final ViewCache viewCache;
        private final Node optCompleteServerCache;

        public WriteTreeCompleteChildSource(WriteTreeRef writes, ViewCache viewCache, Node optCompleteServerCache) {
            this.writes = writes;
            this.viewCache = viewCache;
            this.optCompleteServerCache = optCompleteServerCache;
        }

        @Override
        public Node getCompleteChild(ChildKey childKey) {
            CacheNode node = this.viewCache.getEventCache();
            if (node.isCompleteForChild(childKey)) {
                return node.getNode().getImmediateChild(childKey);
            }
            CacheNode serverNode = this.optCompleteServerCache != null ? new CacheNode(IndexedNode.from(this.optCompleteServerCache, KeyIndex.getInstance()), true, false) : this.viewCache.getServerCache();
            return this.writes.calcCompleteChild(childKey, serverNode);
        }

        @Override
        public NamedNode getChildAfterChild(Index index, NamedNode child, boolean reverse) {
            Node completeServerData = this.optCompleteServerCache != null ? this.optCompleteServerCache : this.viewCache.getCompleteServerSnap();
            return this.writes.calcNextNodeAfterPost(completeServerData, child, reverse, index);
        }
    }

    public static class ProcessorResult {
        public final ViewCache viewCache;
        public final List<Change> changes;

        public ProcessorResult(ViewCache viewCache, List<Change> changes) {
            this.viewCache = viewCache;
            this.changes = changes;
        }
    }
}

