/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.FirebaseApp;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.connection.ConnectionContext;
import com.google.firebase.database.connection.HostInfo;
import com.google.firebase.database.connection.PersistentConnection;
import com.google.firebase.database.connection.PersistentConnectionImpl;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.database.core.Context;
import com.google.firebase.database.core.EventTarget;
import com.google.firebase.database.core.JvmAuthTokenProvider;
import com.google.firebase.database.core.Platform;
import com.google.firebase.database.core.RunLoop;
import com.google.firebase.database.core.ThreadInitializer;
import com.google.firebase.database.core.ThreadPoolEventTarget;
import com.google.firebase.database.core.persistence.PersistenceManager;
import com.google.firebase.database.logging.DefaultLogger;
import com.google.firebase.database.logging.LogWrapper;
import com.google.firebase.database.logging.Logger;
import com.google.firebase.database.tubesock.WebSocket;
import com.google.firebase.database.utilities.DefaultRunLoop;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

class GaePlatform
implements Platform {
    static ThreadFactory threadFactoryInstance;
    static final ThreadInitializer threadInitializerInstance;
    private final FirebaseApp firebaseApp;

    public GaePlatform(FirebaseApp firebaseApp) {
        this.firebaseApp = firebaseApp;
    }

    @Override
    public Logger newLogger(Context ctx, Logger.Level level, List<String> components) {
        return new DefaultLogger(level, components);
    }

    private static ThreadFactory getGaeThreadFactory() {
        if (threadFactoryInstance == null) {
            try {
                Class<?> c = Class.forName("com.google.appengine.api.ThreadManager");
                if (c != null) {
                    threadFactoryInstance = (ThreadFactory)c.getMethod("backgroundThreadFactory", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return threadFactoryInstance;
    }

    public static boolean isActive() {
        return GaePlatform.getGaeThreadFactory() != null;
    }

    public void initialize() {
        WebSocket.setThreadFactory(threadFactoryInstance, new com.google.firebase.database.tubesock.ThreadInitializer(){

            @Override
            public void setName(Thread thread, String s) {
                threadInitializerInstance.setName(thread, s);
            }
        });
    }

    @Override
    public EventTarget newEventTarget(Context ctx) {
        return new ThreadPoolEventTarget(GaePlatform.getGaeThreadFactory(), threadInitializerInstance);
    }

    @Override
    public RunLoop newRunLoop(Context context) {
        final LogWrapper logger = context.getLogger("RunLoop");
        return new DefaultRunLoop(){

            @Override
            public void handleException(Throwable e) {
                String string = String.valueOf(FirebaseDatabase.getSdkVersion());
                logger.error(new StringBuilder(89 + String.valueOf(string).length()).append("Uncaught exception in Firebase Database runloop (").append(string).append("). Please report to support@firebase.com").toString(), e);
            }

            @Override
            protected ThreadFactory getThreadFactory() {
                return threadFactoryInstance;
            }

            @Override
            protected ThreadInitializer getThreadInitializer() {
                return threadInitializerInstance;
            }
        };
    }

    @Override
    public AuthTokenProvider newAuthTokenProvider(ScheduledExecutorService executorService) {
        return new JvmAuthTokenProvider(this.firebaseApp, executorService);
    }

    @Override
    public PersistentConnection newPersistentConnection(Context context, ConnectionContext connectionContext, HostInfo info, PersistentConnection.Delegate delegate) {
        return new PersistentConnectionImpl(context.getConnectionContext(), info, delegate);
    }

    @Override
    public String getUserAgent(Context ctx) {
        String deviceName = "AppEngine";
        String systemVersion = System.getProperty("java.specification.version", "Unknown");
        return new StringBuilder(1 + String.valueOf(systemVersion).length() + String.valueOf(deviceName).length()).append(systemVersion).append("/").append(deviceName).toString();
    }

    @Override
    public String getPlatformVersion() {
        String string = String.valueOf(FirebaseDatabase.getSdkVersion());
        return string.length() != 0 ? "gae-".concat(string) : new String("gae-");
    }

    @Override
    public PersistenceManager createPersistenceManager(Context ctx, String namespace) {
        return null;
    }

    @Override
    public void runBackgroundTask(final Context ctx, final Runnable r) {
        threadFactoryInstance.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (Throwable e) {
                    ctx.getLogger("BackgroundTask").error("An unexpected error occurred. Please contact support@firebase.com. Details: ", e);
                    throw new RuntimeException(e);
                }
            }
        }).start();
    }

    static {
        threadInitializerInstance = new ThreadInitializer(){

            @Override
            public void setName(Thread t, String name) {
            }

            @Override
            public void setDaemon(Thread t, boolean isDaemon) {
            }

            @Override
            public void setUncaughtExceptionHandler(Thread t, Thread.UncaughtExceptionHandler handler) {
                t.setUncaughtExceptionHandler(handler);
            }
        };
    }
}

