/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.transport;

import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Event;
import com.google.android.datatransport.Transport;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.inject.Provider;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.v1.PerfMetric;
import com.google.protobuf.AbstractMessageLite;

final class FlgTransport {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private final String logSourceName;
    private final Provider<TransportFactory> flgTransportFactoryProvider;
    private Transport<PerfMetric> flgTransport;

    FlgTransport(Provider<TransportFactory> flgTransportFactoryProvider, String logSourceName) {
        this.logSourceName = logSourceName;
        this.flgTransportFactoryProvider = flgTransportFactoryProvider;
    }

    @WorkerThread
    public void log(@NonNull PerfMetric perfMetric) {
        if (!this.initializeFlgTransportClient()) {
            logger.warn("Unable to dispatch event because Flg Transport is not available");
            return;
        }
        this.flgTransport.send(Event.ofData((Object)perfMetric));
    }

    private boolean initializeFlgTransportClient() {
        if (this.flgTransport == null) {
            TransportFactory factory = (TransportFactory)this.flgTransportFactoryProvider.get();
            if (factory != null) {
                this.flgTransport = factory.getTransport(this.logSourceName, PerfMetric.class, Encoding.of((String)"proto"), AbstractMessageLite::toByteArray);
            } else {
                logger.warn("Flg TransportFactory is not available at the moment");
            }
        }
        return this.flgTransport != null;
    }
}

