/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class FrameMetricsCalculator {
    @NonNull
    public static PerfFrameMetrics calculateFrameMetrics(@Nullable SparseIntArray[] arr) {
        SparseIntArray frameTimes;
        int totalFrames = 0;
        int slowFrames = 0;
        int frozenFrames = 0;
        if (arr != null && (frameTimes = arr[0]) != null) {
            for (int i = 0; i < frameTimes.size(); ++i) {
                int frameTime = frameTimes.keyAt(i);
                int numFrames = frameTimes.valueAt(i);
                totalFrames += numFrames;
                if (frameTime > 700) {
                    frozenFrames += numFrames;
                }
                if (frameTime <= 16) continue;
                slowFrames += numFrames;
            }
        }
        return new PerfFrameMetrics(totalFrames, slowFrames, frozenFrames);
    }

    public static class PerfFrameMetrics {
        int totalFrames = 0;
        int slowFrames = 0;
        int frozenFrames = 0;

        public PerfFrameMetrics(int totalFrames, int slowFrames, int frozenFrames) {
            this.totalFrames = totalFrames;
            this.slowFrames = slowFrames;
            this.frozenFrames = frozenFrames;
        }

        public int getFrozenFrames() {
            return this.frozenFrames;
        }

        public int getSlowFrames() {
            return this.slowFrames;
        }

        public int getTotalFrames() {
            return this.totalFrames;
        }

        public PerfFrameMetrics deltaFrameMetricsFromSnapshot(PerfFrameMetrics that) {
            int newTotalFrames = this.totalFrames - that.getTotalFrames();
            int newSlowFrames = this.slowFrames - that.getSlowFrames();
            int newFrozenFrames = this.frozenFrames - that.getFrozenFrames();
            return new PerfFrameMetrics(newTotalFrames, newSlowFrames, newFrozenFrames);
        }
    }
}

