/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.config;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@VisibleForTesting(otherwise=3)
public class DeviceCacheManager {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final String PREFS_NAME = "FirebasePerfSharedPrefs";
    private static DeviceCacheManager instance;
    private volatile SharedPreferences sharedPref;
    private final ExecutorService serialExecutor;

    @VisibleForTesting
    public DeviceCacheManager(ExecutorService serialExecutor) {
        this.serialExecutor = serialExecutor;
    }

    @SuppressLint(value={"ThreadPoolCreation"})
    public static synchronized DeviceCacheManager getInstance() {
        if (instance == null) {
            instance = new DeviceCacheManager(Executors.newSingleThreadExecutor());
        }
        return instance;
    }

    @VisibleForTesting
    public static void clearInstance() {
        instance = null;
    }

    public synchronized void setContext(Context appContext) {
        if (this.sharedPref == null && appContext != null) {
            this.serialExecutor.execute(() -> {
                if (this.sharedPref == null && appContext != null) {
                    this.sharedPref = appContext.getSharedPreferences(PREFS_NAME, 0);
                }
            });
        }
    }

    public boolean containsKey(String key) {
        return this.sharedPref != null && key != null && this.sharedPref.contains(key);
    }

    public Optional<Boolean> getBoolean(String key) {
        if (key == null) {
            logger.debug("Key is null when getting boolean value on device cache.");
            return Optional.absent();
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return Optional.absent();
            }
        }
        if (!this.sharedPref.contains(key)) {
            return Optional.absent();
        }
        try {
            return Optional.of(this.sharedPref.getBoolean(key, false));
        }
        catch (ClassCastException e) {
            logger.debug("Key %s from sharedPreferences has type other than long: %s", key, e.getMessage());
            return Optional.absent();
        }
    }

    public void clear(String key) {
        if (key == null) {
            logger.debug("Key is null. Cannot clear nullable key");
            return;
        }
        this.sharedPref.edit().remove(key).apply();
    }

    public boolean setValue(String key, boolean value) {
        if (key == null) {
            logger.debug("Key is null when setting boolean value on device cache.");
            return false;
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return false;
            }
        }
        this.sharedPref.edit().putBoolean(key, value).apply();
        return true;
    }

    public Optional<String> getString(String key) {
        if (key == null) {
            logger.debug("Key is null when getting String value on device cache.");
            return Optional.absent();
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return Optional.absent();
            }
        }
        if (!this.sharedPref.contains(key)) {
            return Optional.absent();
        }
        try {
            return Optional.of(this.sharedPref.getString(key, ""));
        }
        catch (ClassCastException e) {
            logger.debug("Key %s from sharedPreferences has type other than String: %s", key, e.getMessage());
            return Optional.absent();
        }
    }

    public boolean setValue(String key, String value) {
        if (key == null) {
            logger.debug("Key is null when setting String value on device cache.");
            return false;
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return false;
            }
        }
        if (value == null) {
            this.sharedPref.edit().remove(key).apply();
            return true;
        }
        this.sharedPref.edit().putString(key, value).apply();
        return true;
    }

    public Optional<Double> getDouble(String key) {
        if (key == null) {
            logger.debug("Key is null when getting double value on device cache.");
            return Optional.absent();
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return Optional.absent();
            }
        }
        if (!this.sharedPref.contains(key)) {
            return Optional.absent();
        }
        try {
            return Optional.of(Double.longBitsToDouble(this.sharedPref.getLong(key, 0L)));
        }
        catch (ClassCastException unused) {
            try {
                return Optional.of(Float.valueOf(this.sharedPref.getFloat(key, 0.0f)).doubleValue());
            }
            catch (ClassCastException e) {
                logger.debug("Key %s from sharedPreferences has type other than double: %s", key, e.getMessage());
                return Optional.absent();
            }
        }
    }

    public boolean setValue(String key, double value) {
        if (key == null) {
            logger.debug("Key is null when setting double value on device cache.");
            return false;
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return false;
            }
        }
        this.sharedPref.edit().putLong(key, Double.doubleToRawLongBits(value)).apply();
        return true;
    }

    public Optional<Long> getLong(String key) {
        if (key == null) {
            logger.debug("Key is null when getting long value on device cache.");
            return Optional.absent();
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return Optional.absent();
            }
        }
        if (!this.sharedPref.contains(key)) {
            return Optional.absent();
        }
        try {
            return Optional.of(this.sharedPref.getLong(key, 0L));
        }
        catch (ClassCastException e) {
            logger.debug("Key %s from sharedPreferences has type other than long: %s", key, e.getMessage());
            return Optional.absent();
        }
    }

    public boolean setValue(String key, long value) {
        if (key == null) {
            logger.debug("Key is null when setting long value on device cache.");
            return false;
        }
        if (this.sharedPref == null) {
            this.setContext(this.getFirebaseApplicationContext());
            if (this.sharedPref == null) {
                return false;
            }
        }
        this.sharedPref.edit().putLong(key, value).apply();
        return true;
    }

    @Nullable
    private Context getFirebaseApplicationContext() {
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException e) {
            return null;
        }
        return FirebaseApp.getInstance().getApplicationContext();
    }
}

