/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.application;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.google.firebase.perf.application.AppStateMonitor;
import com.google.firebase.perf.application.FrameMetricsRecorder;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.metrics.FrameMetricsCalculator;
import com.google.firebase.perf.metrics.Trace;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Clock;
import com.google.firebase.perf.util.Optional;
import com.google.firebase.perf.util.ScreenTraceUtil;
import java.util.WeakHashMap;

public class FragmentStateMonitor
extends FragmentManager.FragmentLifecycleCallbacks {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private final WeakHashMap<Fragment, Trace> fragmentToTraceMap = new WeakHashMap();
    private final Clock clock;
    private final TransportManager transportManager;
    private final AppStateMonitor appStateMonitor;
    private final FrameMetricsRecorder activityFramesRecorder;

    public FragmentStateMonitor(Clock clock, TransportManager transportManager, AppStateMonitor appStateMonitor, FrameMetricsRecorder recorder) {
        this.clock = clock;
        this.transportManager = transportManager;
        this.appStateMonitor = appStateMonitor;
        this.activityFramesRecorder = recorder;
    }

    public String getFragmentScreenTraceName(Fragment fragment) {
        return "_st_" + fragment.getClass().getSimpleName();
    }

    public void onFragmentResumed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        super.onFragmentResumed(fm, f);
        logger.debug("FragmentMonitor %s.onFragmentResumed", f.getClass().getSimpleName());
        Trace fragmentTrace = new Trace(this.getFragmentScreenTraceName(f), this.transportManager, this.clock, this.appStateMonitor);
        fragmentTrace.start();
        fragmentTrace.putAttribute("Parent_fragment", f.getParentFragment() == null ? "No parent" : f.getParentFragment().getClass().getSimpleName());
        if (f.getActivity() != null) {
            fragmentTrace.putAttribute("Hosting_activity", f.getActivity().getClass().getSimpleName());
        }
        this.fragmentToTraceMap.put(f, fragmentTrace);
        this.activityFramesRecorder.startFragment(f);
    }

    public void onFragmentPaused(@NonNull FragmentManager fm, @NonNull Fragment f) {
        super.onFragmentPaused(fm, f);
        logger.debug("FragmentMonitor %s.onFragmentPaused ", f.getClass().getSimpleName());
        if (!this.fragmentToTraceMap.containsKey(f)) {
            logger.warn("FragmentMonitor: missed a fragment trace from %s", f.getClass().getSimpleName());
            return;
        }
        Trace fragmentTrace = this.fragmentToTraceMap.get(f);
        this.fragmentToTraceMap.remove(f);
        Optional<FrameMetricsCalculator.PerfFrameMetrics> frameMetricsData = this.activityFramesRecorder.stopFragment(f);
        if (!frameMetricsData.isAvailable()) {
            logger.warn("onFragmentPaused: recorder failed to trace %s", f.getClass().getSimpleName());
            return;
        }
        ScreenTraceUtil.addFrameCounters(fragmentTrace, frameMetricsData.get());
        fragmentTrace.stop();
    }

    @VisibleForTesting
    WeakHashMap<Fragment, Trace> getFragmentToTraceMap() {
        return this.fragmentToTraceMap;
    }
}

