/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewTreeObserver;
import java.util.concurrent.atomic.AtomicReference;

public class PreDrawListener
implements ViewTreeObserver.OnPreDrawListener {
    @SuppressLint(value={"ThreadPoolCreation"})
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private final AtomicReference<View> viewReference;
    private final Runnable callbackBoQ;
    private final Runnable callbackFoQ;

    public static void registerForNextDraw(View view, Runnable drawDoneCallbackBoQ, Runnable drawDoneCallbackFoQ) {
        PreDrawListener listener = new PreDrawListener(view, drawDoneCallbackBoQ, drawDoneCallbackFoQ);
        view.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)listener);
    }

    private PreDrawListener(View view, Runnable callbackBoQ, Runnable callbackFoQ) {
        this.viewReference = new AtomicReference<View>(view);
        this.callbackBoQ = callbackBoQ;
        this.callbackFoQ = callbackFoQ;
    }

    public boolean onPreDraw() {
        View view = this.viewReference.getAndSet(null);
        if (view == null) {
            return true;
        }
        view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.mainThreadHandler.post(this.callbackBoQ);
        this.mainThreadHandler.postAtFrontOfQueue(this.callbackFoQ);
        return true;
    }
}

