/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.v1;

import com.google.firebase.perf.v1.NetworkConnectionInfoOrBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class NetworkConnectionInfo
extends GeneratedMessageLite<NetworkConnectionInfo, Builder>
implements NetworkConnectionInfoOrBuilder {
    private int bitField0_;
    public static final int NETWORK_TYPE_FIELD_NUMBER = 1;
    private int networkType_ = -1;
    public static final int MOBILE_SUBTYPE_FIELD_NUMBER = 2;
    private int mobileSubtype_;
    private static final NetworkConnectionInfo DEFAULT_INSTANCE;
    private static volatile Parser<NetworkConnectionInfo> PARSER;

    private NetworkConnectionInfo() {
    }

    @Override
    public boolean hasNetworkType() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public NetworkType getNetworkType() {
        NetworkType result = NetworkType.forNumber(this.networkType_);
        return result == null ? NetworkType.NONE : result;
    }

    private void setNetworkType(NetworkType value) {
        this.networkType_ = value.getNumber();
        this.bitField0_ |= 1;
    }

    private void clearNetworkType() {
        this.bitField0_ &= 0xFFFFFFFE;
        this.networkType_ = -1;
    }

    @Override
    public boolean hasMobileSubtype() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public MobileSubtype getMobileSubtype() {
        MobileSubtype result = MobileSubtype.forNumber(this.mobileSubtype_);
        return result == null ? MobileSubtype.UNKNOWN_MOBILE_SUBTYPE : result;
    }

    private void setMobileSubtype(MobileSubtype value) {
        this.mobileSubtype_ = value.getNumber();
        this.bitField0_ |= 2;
    }

    private void clearMobileSubtype() {
        this.bitField0_ &= 0xFFFFFFFD;
        this.mobileSubtype_ = 0;
    }

    public static NetworkConnectionInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (NetworkConnectionInfo)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteBuffer)data);
    }

    public static NetworkConnectionInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NetworkConnectionInfo)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteBuffer)data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NetworkConnectionInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (NetworkConnectionInfo)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data);
    }

    public static NetworkConnectionInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NetworkConnectionInfo)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NetworkConnectionInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (NetworkConnectionInfo)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data);
    }

    public static NetworkConnectionInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NetworkConnectionInfo)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NetworkConnectionInfo parseFrom(InputStream input) throws IOException {
        return (NetworkConnectionInfo)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static NetworkConnectionInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NetworkConnectionInfo)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NetworkConnectionInfo parseDelimitedFrom(InputStream input) throws IOException {
        return (NetworkConnectionInfo)NetworkConnectionInfo.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static NetworkConnectionInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NetworkConnectionInfo)NetworkConnectionInfo.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NetworkConnectionInfo parseFrom(CodedInputStream input) throws IOException {
        return (NetworkConnectionInfo)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input);
    }

    public static NetworkConnectionInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NetworkConnectionInfo)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Builder newBuilder() {
        return (Builder)DEFAULT_INSTANCE.createBuilder();
    }

    public static Builder newBuilder(NetworkConnectionInfo prototype) {
        return (Builder)DEFAULT_INSTANCE.createBuilder(prototype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
        switch (method) {
            case NEW_MUTABLE_INSTANCE: {
                return new NetworkConnectionInfo();
            }
            case NEW_BUILDER: {
                return new Builder();
            }
            case BUILD_MESSAGE_INFO: {
                Object[] objects = new Object[]{"bitField0_", "networkType_", NetworkType.internalGetVerifier(), "mobileSubtype_", MobileSubtype.internalGetVerifier()};
                String info = "\u0001\u0002\u0000\u0001\u0001\u0002\u0002\u0000\u0000\u0000\u0001\u100c\u0000\u0002\u100c\u0001";
                return NetworkConnectionInfo.newMessageInfo((MessageLite)DEFAULT_INSTANCE, (String)info, (Object[])objects);
            }
            case GET_DEFAULT_INSTANCE: {
                return DEFAULT_INSTANCE;
            }
            case GET_PARSER: {
                GeneratedMessageLite.DefaultInstanceBasedParser parser = PARSER;
                if (parser != null) return parser;
                Class<NetworkConnectionInfo> clazz = NetworkConnectionInfo.class;
                synchronized (NetworkConnectionInfo.class) {
                    parser = PARSER;
                    if (parser != null) return parser;
                    PARSER = parser = new GeneratedMessageLite.DefaultInstanceBasedParser((GeneratedMessageLite)DEFAULT_INSTANCE);
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    return parser;
                }
            }
            case GET_MEMOIZED_IS_INITIALIZED: {
                return (byte)1;
            }
            case SET_MEMOIZED_IS_INITIALIZED: {
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static NetworkConnectionInfo getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<NetworkConnectionInfo> parser() {
        return DEFAULT_INSTANCE.getParserForType();
    }

    static {
        NetworkConnectionInfo defaultInstance;
        DEFAULT_INSTANCE = defaultInstance = new NetworkConnectionInfo();
        GeneratedMessageLite.registerDefaultInstance(NetworkConnectionInfo.class, (GeneratedMessageLite)defaultInstance);
    }

    public static final class Builder
    extends GeneratedMessageLite.Builder<NetworkConnectionInfo, Builder>
    implements NetworkConnectionInfoOrBuilder {
        private Builder() {
            super((GeneratedMessageLite)DEFAULT_INSTANCE);
        }

        @Override
        public boolean hasNetworkType() {
            return ((NetworkConnectionInfo)this.instance).hasNetworkType();
        }

        @Override
        public NetworkType getNetworkType() {
            return ((NetworkConnectionInfo)this.instance).getNetworkType();
        }

        public Builder setNetworkType(NetworkType value) {
            this.copyOnWrite();
            ((NetworkConnectionInfo)this.instance).setNetworkType(value);
            return this;
        }

        public Builder clearNetworkType() {
            this.copyOnWrite();
            ((NetworkConnectionInfo)this.instance).clearNetworkType();
            return this;
        }

        @Override
        public boolean hasMobileSubtype() {
            return ((NetworkConnectionInfo)this.instance).hasMobileSubtype();
        }

        @Override
        public MobileSubtype getMobileSubtype() {
            return ((NetworkConnectionInfo)this.instance).getMobileSubtype();
        }

        public Builder setMobileSubtype(MobileSubtype value) {
            this.copyOnWrite();
            ((NetworkConnectionInfo)this.instance).setMobileSubtype(value);
            return this;
        }

        public Builder clearMobileSubtype() {
            this.copyOnWrite();
            ((NetworkConnectionInfo)this.instance).clearMobileSubtype();
            return this;
        }
    }

    public static enum MobileSubtype implements Internal.EnumLite
    {
        UNKNOWN_MOBILE_SUBTYPE(0),
        GPRS(1),
        EDGE(2),
        UMTS(3),
        CDMA(4),
        EVDO_0(5),
        EVDO_A(6),
        RTT(7),
        HSDPA(8),
        HSUPA(9),
        HSPA(10),
        IDEN(11),
        EVDO_B(12),
        LTE(13),
        EHRPD(14),
        HSPAP(15),
        GSM(16),
        TD_SCDMA(17),
        IWLAN(18),
        LTE_CA(19),
        COMBINED(100);

        public static final int UNKNOWN_MOBILE_SUBTYPE_VALUE = 0;
        public static final int GPRS_VALUE = 1;
        public static final int EDGE_VALUE = 2;
        public static final int UMTS_VALUE = 3;
        public static final int CDMA_VALUE = 4;
        public static final int EVDO_0_VALUE = 5;
        public static final int EVDO_A_VALUE = 6;
        public static final int RTT_VALUE = 7;
        public static final int HSDPA_VALUE = 8;
        public static final int HSUPA_VALUE = 9;
        public static final int HSPA_VALUE = 10;
        public static final int IDEN_VALUE = 11;
        public static final int EVDO_B_VALUE = 12;
        public static final int LTE_VALUE = 13;
        public static final int EHRPD_VALUE = 14;
        public static final int HSPAP_VALUE = 15;
        public static final int GSM_VALUE = 16;
        public static final int TD_SCDMA_VALUE = 17;
        public static final int IWLAN_VALUE = 18;
        public static final int LTE_CA_VALUE = 19;
        public static final int COMBINED_VALUE = 100;
        private static final Internal.EnumLiteMap<MobileSubtype> internalValueMap;
        private final int value;

        public final int getNumber() {
            return this.value;
        }

        @Deprecated
        public static MobileSubtype valueOf(int value) {
            return MobileSubtype.forNumber(value);
        }

        public static MobileSubtype forNumber(int value) {
            switch (value) {
                case 0: {
                    return UNKNOWN_MOBILE_SUBTYPE;
                }
                case 1: {
                    return GPRS;
                }
                case 2: {
                    return EDGE;
                }
                case 3: {
                    return UMTS;
                }
                case 4: {
                    return CDMA;
                }
                case 5: {
                    return EVDO_0;
                }
                case 6: {
                    return EVDO_A;
                }
                case 7: {
                    return RTT;
                }
                case 8: {
                    return HSDPA;
                }
                case 9: {
                    return HSUPA;
                }
                case 10: {
                    return HSPA;
                }
                case 11: {
                    return IDEN;
                }
                case 12: {
                    return EVDO_B;
                }
                case 13: {
                    return LTE;
                }
                case 14: {
                    return EHRPD;
                }
                case 15: {
                    return HSPAP;
                }
                case 16: {
                    return GSM;
                }
                case 17: {
                    return TD_SCDMA;
                }
                case 18: {
                    return IWLAN;
                }
                case 19: {
                    return LTE_CA;
                }
                case 100: {
                    return COMBINED;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<MobileSubtype> internalGetValueMap() {
            return internalValueMap;
        }

        public static Internal.EnumVerifier internalGetVerifier() {
            return MobileSubtypeVerifier.INSTANCE;
        }

        private MobileSubtype(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<MobileSubtype>(){

                public MobileSubtype findValueByNumber(int number) {
                    return MobileSubtype.forNumber(number);
                }
            };
        }

        private static final class MobileSubtypeVerifier
        implements Internal.EnumVerifier {
            static final Internal.EnumVerifier INSTANCE = new MobileSubtypeVerifier();

            private MobileSubtypeVerifier() {
            }

            public boolean isInRange(int number) {
                return MobileSubtype.forNumber(number) != null;
            }
        }
    }

    public static enum NetworkType implements Internal.EnumLite
    {
        NONE(-1),
        MOBILE(0),
        WIFI(1),
        MOBILE_MMS(2),
        MOBILE_SUPL(3),
        MOBILE_DUN(4),
        MOBILE_HIPRI(5),
        WIMAX(6),
        BLUETOOTH(7),
        DUMMY(8),
        ETHERNET(9),
        MOBILE_FOTA(10),
        MOBILE_IMS(11),
        MOBILE_CBS(12),
        WIFI_P2P(13),
        MOBILE_IA(14),
        MOBILE_EMERGENCY(15),
        PROXY(16),
        VPN(17);

        public static final int NONE_VALUE = -1;
        public static final int MOBILE_VALUE = 0;
        public static final int WIFI_VALUE = 1;
        public static final int MOBILE_MMS_VALUE = 2;
        public static final int MOBILE_SUPL_VALUE = 3;
        public static final int MOBILE_DUN_VALUE = 4;
        public static final int MOBILE_HIPRI_VALUE = 5;
        public static final int WIMAX_VALUE = 6;
        public static final int BLUETOOTH_VALUE = 7;
        public static final int DUMMY_VALUE = 8;
        public static final int ETHERNET_VALUE = 9;
        public static final int MOBILE_FOTA_VALUE = 10;
        public static final int MOBILE_IMS_VALUE = 11;
        public static final int MOBILE_CBS_VALUE = 12;
        public static final int WIFI_P2P_VALUE = 13;
        public static final int MOBILE_IA_VALUE = 14;
        public static final int MOBILE_EMERGENCY_VALUE = 15;
        public static final int PROXY_VALUE = 16;
        public static final int VPN_VALUE = 17;
        private static final Internal.EnumLiteMap<NetworkType> internalValueMap;
        private final int value;

        public final int getNumber() {
            return this.value;
        }

        @Deprecated
        public static NetworkType valueOf(int value) {
            return NetworkType.forNumber(value);
        }

        public static NetworkType forNumber(int value) {
            switch (value) {
                case -1: {
                    return NONE;
                }
                case 0: {
                    return MOBILE;
                }
                case 1: {
                    return WIFI;
                }
                case 2: {
                    return MOBILE_MMS;
                }
                case 3: {
                    return MOBILE_SUPL;
                }
                case 4: {
                    return MOBILE_DUN;
                }
                case 5: {
                    return MOBILE_HIPRI;
                }
                case 6: {
                    return WIMAX;
                }
                case 7: {
                    return BLUETOOTH;
                }
                case 8: {
                    return DUMMY;
                }
                case 9: {
                    return ETHERNET;
                }
                case 10: {
                    return MOBILE_FOTA;
                }
                case 11: {
                    return MOBILE_IMS;
                }
                case 12: {
                    return MOBILE_CBS;
                }
                case 13: {
                    return WIFI_P2P;
                }
                case 14: {
                    return MOBILE_IA;
                }
                case 15: {
                    return MOBILE_EMERGENCY;
                }
                case 16: {
                    return PROXY;
                }
                case 17: {
                    return VPN;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<NetworkType> internalGetValueMap() {
            return internalValueMap;
        }

        public static Internal.EnumVerifier internalGetVerifier() {
            return NetworkTypeVerifier.INSTANCE;
        }

        private NetworkType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<NetworkType>(){

                public NetworkType findValueByNumber(int number) {
                    return NetworkType.forNumber(number);
                }
            };
        }

        private static final class NetworkTypeVerifier
        implements Internal.EnumVerifier {
            static final Internal.EnumVerifier INSTANCE = new NetworkTypeVerifier();

            private NetworkTypeVerifier() {
            }

            public boolean isInRange(int number) {
                return NetworkType.forNumber(number) != null;
            }
        }
    }
}

