/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.concurrent.TimeUnit;

public class Timer
implements Parcelable {
    private long wallClockMicros;
    private long elapsedRealtimeMicros;
    public static final Parcelable.Creator<Timer> CREATOR = new Parcelable.Creator<Timer>(){

        public Timer createFromParcel(Parcel in) {
            return new Timer(in);
        }

        public Timer[] newArray(int size) {
            return new Timer[size];
        }
    };

    public static Timer ofElapsedRealtime(long elapsedRealtimeMillis) {
        long elapsedRealtimeMicros = TimeUnit.MILLISECONDS.toMicros(elapsedRealtimeMillis);
        long wallClockMicros = Timer.wallClockMicros() + (elapsedRealtimeMicros - Timer.elapsedRealtimeMicros());
        return new Timer(wallClockMicros, elapsedRealtimeMicros);
    }

    private static long wallClockMicros() {
        return TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
    }

    private static long elapsedRealtimeMicros() {
        if (Build.VERSION.SDK_INT >= 17) {
            return TimeUnit.NANOSECONDS.toMicros(SystemClock.elapsedRealtimeNanos());
        }
        return TimeUnit.MILLISECONDS.toMicros(SystemClock.elapsedRealtime());
    }

    public Timer() {
        this(Timer.wallClockMicros(), Timer.elapsedRealtimeMicros());
    }

    @VisibleForTesting
    Timer(long epochMicros, long elapsedRealtimeMicros) {
        this.wallClockMicros = epochMicros;
        this.elapsedRealtimeMicros = elapsedRealtimeMicros;
    }

    @VisibleForTesting
    public Timer(long testTime) {
        this(testTime, testTime);
    }

    private Timer(Parcel in) {
        this(in.readLong(), in.readLong());
    }

    public void reset() {
        this.wallClockMicros = Timer.wallClockMicros();
        this.elapsedRealtimeMicros = Timer.elapsedRealtimeMicros();
    }

    public long getMicros() {
        return this.wallClockMicros;
    }

    public long getDurationMicros() {
        return this.getDurationMicros(new Timer());
    }

    public long getDurationMicros(@NonNull Timer end) {
        return end.elapsedRealtimeMicros - this.elapsedRealtimeMicros;
    }

    public long getCurrentTimestampMicros() {
        return this.wallClockMicros + this.getDurationMicros();
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.wallClockMicros);
        out.writeLong(this.elapsedRealtimeMicros);
    }

    public int describeContents() {
        return 0;
    }
}

