/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.metrics.NetworkRequestMetricBuilder;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;

public final class NetworkRequestMetricBuilderUtil {
    private static final Pattern FLG_USER_AGENT_PATTERN = Pattern.compile("(^|.*\\s)datatransport/\\S+ android/($|\\s.*)");

    private NetworkRequestMetricBuilderUtil() {
    }

    public static Long getApacheHttpMessageContentLength(@NonNull HttpMessage request) {
        try {
            Header contentLengthHeader = request.getFirstHeader("content-length");
            if (contentLengthHeader != null) {
                return Long.parseLong(contentLengthHeader.getValue());
            }
        }
        catch (NumberFormatException e) {
            AndroidLogger.getInstance().debug("The content-length value is not a valid number");
        }
        return null;
    }

    public static String getApacheHttpResponseContentType(@NonNull HttpResponse response) {
        String contentType;
        Header responseContentTypeHeader = response.getFirstHeader("content-type");
        if (responseContentTypeHeader != null && (contentType = responseContentTypeHeader.getValue()) != null) {
            return contentType;
        }
        return null;
    }

    public static void logError(NetworkRequestMetricBuilder builder) {
        if (!builder.hasHttpResponseCode()) {
            builder.setNetworkClientErrorReason();
        }
        builder.build();
    }

    public static boolean isAllowedUserAgent(@Nullable String userAgent) {
        return userAgent == null || !FLG_USER_AGENT_PATTERN.matcher(userAgent).matches();
    }
}

