/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import com.google.firebase.perf.metrics.NetworkRequestMetricBuilder;
import com.google.firebase.perf.network.FirebasePerfOkHttpClient;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Timer;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public class InstrumentOkHttpEnqueueCallback
implements Callback {
    private final Callback callback;
    private final NetworkRequestMetricBuilder networkMetricBuilder;
    private final Timer timer;
    private final long startTimeMicros;

    public InstrumentOkHttpEnqueueCallback(Callback callback, TransportManager transportManager, Timer timer, long startTime) {
        this.callback = callback;
        this.networkMetricBuilder = NetworkRequestMetricBuilder.builder(transportManager);
        this.startTimeMicros = startTime;
        this.timer = timer;
    }

    public void onFailure(Call call, IOException e) {
        Request request = call.request();
        if (request != null) {
            String method;
            HttpUrl url = request.url();
            if (url != null) {
                this.networkMetricBuilder.setUrl(url.url().toString());
            }
            if ((method = request.method()) != null) {
                this.networkMetricBuilder.setHttpMethod(request.method());
            }
        }
        this.networkMetricBuilder.setRequestStartTimeMicros(this.startTimeMicros);
        this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
        NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
        this.callback.onFailure(call, e);
    }

    public void onResponse(Call call, Response response) throws IOException {
        long responseCompletedTimeMicros = this.timer.getDurationMicros();
        FirebasePerfOkHttpClient.sendNetworkMetric(response, this.networkMetricBuilder, this.startTimeMicros, responseCompletedTimeMicros);
        this.callback.onResponse(call, response);
    }
}

