/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import com.google.firebase.perf.metrics.NetworkRequestMetricBuilder;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.util.Timer;
import java.io.IOException;
import java.io.InputStream;

public final class InstrHttpInputStream
extends InputStream {
    private final InputStream inputStream;
    private final NetworkRequestMetricBuilder networkMetricBuilder;
    private final Timer timer;
    private long bytesRead = -1L;
    private long timeToResponseInitiated;
    private long timeToResponseLastRead = -1L;

    public InstrHttpInputStream(InputStream inputStream, NetworkRequestMetricBuilder builder, Timer timer) {
        this.timer = timer;
        this.inputStream = inputStream;
        this.networkMetricBuilder = builder;
        this.timeToResponseInitiated = this.networkMetricBuilder.getTimeToResponseInitiatedMicros();
    }

    @Override
    public int available() throws IOException {
        try {
            return this.inputStream.available();
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        long tempTime = this.timer.getDurationMicros();
        if (this.timeToResponseLastRead == -1L) {
            this.timeToResponseLastRead = tempTime;
        }
        try {
            this.inputStream.close();
            if (this.bytesRead != -1L) {
                this.networkMetricBuilder.setResponsePayloadBytes(this.bytesRead);
            }
            if (this.timeToResponseInitiated != -1L) {
                this.networkMetricBuilder.setTimeToResponseInitiatedMicros(this.timeToResponseInitiated);
            }
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timeToResponseLastRead);
            this.networkMetricBuilder.build();
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    @Override
    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        try {
            int bytesRead = this.inputStream.read();
            long tempTime = this.timer.getDurationMicros();
            if (this.timeToResponseInitiated == -1L) {
                this.timeToResponseInitiated = tempTime;
            }
            if (bytesRead == -1 && this.timeToResponseLastRead == -1L) {
                this.timeToResponseLastRead = tempTime;
                this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timeToResponseLastRead);
                this.networkMetricBuilder.build();
            } else {
                ++this.bytesRead;
                this.networkMetricBuilder.setResponsePayloadBytes(this.bytesRead);
            }
            return bytesRead;
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        try {
            int bytesRead = this.inputStream.read(buffer, byteOffset, byteCount);
            long tempTime = this.timer.getDurationMicros();
            if (this.timeToResponseInitiated == -1L) {
                this.timeToResponseInitiated = tempTime;
            }
            if (bytesRead == -1 && this.timeToResponseLastRead == -1L) {
                this.timeToResponseLastRead = tempTime;
                this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timeToResponseLastRead);
                this.networkMetricBuilder.build();
            } else {
                this.bytesRead += (long)bytesRead;
                this.networkMetricBuilder.setResponsePayloadBytes(this.bytesRead);
            }
            return bytesRead;
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        try {
            int bytesRead = this.inputStream.read(buffer);
            long tempTime = this.timer.getDurationMicros();
            if (this.timeToResponseInitiated == -1L) {
                this.timeToResponseInitiated = tempTime;
            }
            if (bytesRead == -1 && this.timeToResponseLastRead == -1L) {
                this.timeToResponseLastRead = tempTime;
                this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timeToResponseLastRead);
                this.networkMetricBuilder.build();
            } else {
                this.bytesRead += (long)bytesRead;
                this.networkMetricBuilder.setResponsePayloadBytes(this.bytesRead);
            }
            return bytesRead;
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            this.inputStream.reset();
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    @Override
    public long skip(long byteCount) throws IOException {
        try {
            long skipped = this.inputStream.skip(byteCount);
            long tempTime = this.timer.getDurationMicros();
            if (this.timeToResponseInitiated == -1L) {
                this.timeToResponseInitiated = tempTime;
            }
            if (skipped == -1L && this.timeToResponseLastRead == -1L) {
                this.timeToResponseLastRead = tempTime;
                this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timeToResponseLastRead);
            } else {
                this.bytesRead += skipped;
                this.networkMetricBuilder.setResponsePayloadBytes(this.bytesRead);
            }
            return skipped;
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }
}

